/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import org.geotools.feature.LenientFeatureFactory;
import org.opengis.feature.Attribute;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class LenientBuilder {
    private SimpleFeatureType schema;
    private FeatureFactory factory;
    private Object[] properties;

    public LenientBuilder(SimpleFeatureType schmea) {
        this.schema = schmea;
        this.factory = new LenientFeatureFactory();
        this.reset();
    }

    public static SimpleFeature build(SimpleFeatureType ft, Object[] atts, String fid) {
        LenientFeatureFactory featureFactory = new LenientFeatureFactory();
        ArrayList<Attribute> properties = new ArrayList<Attribute>();
        for (int i = 0; i < atts.length; ++i) {
            Object value = atts[i];
            Attribute property = featureFactory.createAttribute(value, ft.getDescriptor(i), null);
            properties.add(property);
        }
        return featureFactory.createSimpleFeature(properties, ft, fid);
    }

    public void setFeatureFactory(FeatureFactory featureFactory) {
        this.factory = featureFactory;
    }

    public void addAll(Object[] values) {
        System.arraycopy(values, 0, this.properties, 0, this.properties.length);
    }

    public SimpleFeature buildFeature(String fid) {
        return this.factory.createSimpleFeature(this.properties, this.schema, fid);
    }

    public void reset() {
        this.properties = new Object[this.schema.getAttributeCount()];
    }

    public static SimpleFeature copy(SimpleFeature f) {
        if (f == null) {
            return null;
        }
        LenientBuilder builder = new LenientBuilder(f.getFeatureType());
        builder.addAll(f.getAttributes().toArray());
        return builder.buildFeature(f.getID());
    }
}

