/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.geotools.data.db2.DB2DialectInfo;
import org.geotools.data.db2.DB2FilterToSQL;
import org.geotools.data.db2.DB2SQLDialect;
import org.geotools.data.db2.DB2Util;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.factory.Hints;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2SQLDialectBasic
extends BasicSQLDialect {
    private DB2SQLDialect delegate = null;

    public DB2SQLDialectBasic(JDBCDataStore dataStore, DB2DialectInfo info) {
        super(dataStore);
        this.delegate = new DB2SQLDialect(dataStore, info);
    }

    public boolean isLooseBBOXEnabled() {
        return this.delegate.isLooseBBOXEnabled();
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.delegate.setLooseBBOXEnabled(looseBBOXEnabled);
    }

    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        return this.delegate.createCRS(srid, cx);
    }

    public FilterToSQL createFilterToSQL() {
        DB2FilterToSQL sql = new DB2FilterToSQL((Writer)null);
        sql.setLooseBBOXEnabled(this.delegate.isLooseBBOXEnabled());
        return sql;
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    public String getGeometryTypeName(Integer type) {
        return this.delegate.getGeometryTypeName(type);
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, srid, sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, Hints hints, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, srid, hints, sql);
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        DB2Util.encodeGeometryValue(value, srid, sql);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String name, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, name, factory, cx);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        this.delegate.registerSqlTypeToClassMappings(mappings);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        this.delegate.registerSqlTypeNameToClassMappings(mappings);
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getSequenceForColumn(schemaName, tableName, columnName, cx);
    }

    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return this.delegate.getNextSequenceValue(schemaName, sequenceName, cx);
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }

    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, int srid, StringBuffer sql, Double distance) {
        this.delegate.encodeGeometryColumnGeneralized(gatt, srid, sql, distance);
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        this.delegate.addSupportedHints(hints);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    public DB2DialectInfo getDb2DialectInfo() {
        return this.delegate.getDb2DialectInfo();
    }
}

