/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import geodb.GeoDB;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.h2.H2Dialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2DialectPrepared
extends PreparedStatementSQLDialect {
    H2Dialect delegate;

    protected H2DialectPrepared(JDBCDataStore dataStore) {
        super(dataStore);
        this.delegate = new H2Dialect(dataStore);
    }

    public void initializeConnection(Connection cx) throws SQLException {
        this.delegate.initializeConnection(cx);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    public String getNameEscape() {
        return this.delegate.getNameEscape();
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        this.delegate.registerSqlTypeToClassMappings(mappings);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        return this.delegate.getMapping(columnMetaData, cx);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        this.delegate.encodePostColumnCreateTable(att, sql);
    }

    public void encodePostCreateTable(String tableName, StringBuffer sql) {
        this.delegate.encodePostCreateTable(tableName, sql);
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData metadata, String schemaName, Connection cx) throws SQLException {
        this.delegate.postCreateFeatureType(featureType, metadata, schemaName, cx);
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getSequenceForColumn(schemaName, tableName, columnName, cx);
    }

    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return this.delegate.getNextSequenceValue(schemaName, sequenceName, cx);
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getNextAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    public void setGeometryValue(Geometry g, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null || g.isEmpty()) {
            ps.setNull(column, 2004);
            return;
        }
        ps.setBytes(column, GeoDB.gToWKB((Geometry)g));
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx);
    }

    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }
}

