/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.data.oracle.OracleFilterToSQL;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.geotools.data.oracle.sdo.SDOSqlDumper;
import org.geotools.data.oracle.sdo.TT;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.SoftValueHashMap;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends PreparedStatementSQLDialect {
    private static final int DEFAULT_AXIS_MAX = 1000000;
    private static final int DEFAULT_AXIS_MIN = -10000000;
    public static final String GEODETIC = "geodetic";
    UnWrapper uw;
    public static final Map<Class, String> CLASSES_TO_GEOM = Collections.unmodifiableMap(new GeomClasses());
    static final Map<String, Class> TYPES_TO_CLASSES = new HashMap<String, Class>(){
        {
            this.put("CHAR", String.class);
            this.put("NCHAR", String.class);
            this.put("NVARCHAR", String.class);
            this.put("NVARCHAR2", String.class);
        }
    };
    boolean looseBBOXEnabled = false;
    boolean estimatedExtentsEnabled = false;
    SoftValueHashMap<Integer, Boolean> geodeticCache = new SoftValueHashMap(20);
    Boolean canAccessUserViews;
    String geometryMetadataTable;

    public OracleDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtenstEnabled) {
        this.estimatedExtentsEnabled = estimatedExtenstEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAccessUserViews(Connection cx) {
        if (this.canAccessUserViews == null) {
            Statement st = null;
            ResultSet rs = null;
            try {
                st = cx.createStatement();
                String sql = "SELECT * FROM MDSYS.USER_SDO_INDEX_METADATA WHERE ROWNUM < 2";
                LOGGER.log(Level.FINE, "Check user can access user metadata views: {0}", sql);
                rs = st.executeQuery(sql);
                this.dataStore.closeSafe(rs);
                sql = "SELECT * FROM MDSYS.USER_SDO_GEOM_METADATA WHERE ROWNUM < 2";
                LOGGER.log(Level.FINE, "Check user can access user metadata views: {0}", sql);
                LOGGER.log(Level.FINE, sql);
                rs = st.executeQuery(sql);
                this.dataStore.closeSafe(rs);
                this.canAccessUserViews = true;
            }
            catch (SQLException e) {
                try {
                    this.canAccessUserViews = false;
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(st);
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(st);
                this.dataStore.closeSafe(rs);
            }
            this.dataStore.closeSafe(st);
            this.dataStore.closeSafe(rs);
        }
        return this.canAccessUserViews;
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        int TABLE_NAME = 3;
        int COLUMN_NAME = 4;
        int TYPE_NAME = 6;
        String typeName = columnMetaData.getString(6);
        if (typeName.equals("SDO_GEOMETRY")) {
            String schema;
            String columnName;
            String tableName = columnMetaData.getString(3);
            Class<Object> geometryClass = this.lookupGeometryOnMetadataTable(cx, tableName, columnName = columnMetaData.getString(4), schema = this.dataStore.getDatabaseSchema());
            if (geometryClass == null) {
                this.lookupGeometryClassOnUserIndex(cx, tableName, columnName, schema);
            }
            if (geometryClass == null) {
                geometryClass = this.lookupGeometryClassOnAllIndex(cx, tableName, columnName, schema);
            }
            if (geometryClass == null) {
                geometryClass = Geometry.class;
            }
            return geometryClass;
        }
        return TYPES_TO_CLASSES.get(typeName);
    }

    private Class<?> lookupGeometryOnMetadataTable(Connection cx, String tableName, String columnName, String schema) throws SQLException {
        if (this.geometryMetadataTable == null) {
            return null;
        }
        String metadataTableStatement = "SELECT TYPE FROM " + this.geometryMetadataTable + " WHERE F_TABLE_NAME = '" + tableName + "'" + " AND F_GEOMETRY_COLUMN = '" + columnName + "'";
        if (schema != null && !"".equals(schema)) {
            metadataTableStatement = metadataTableStatement + " AND F_TABLE_SCHEMA = '" + schema + "'";
        }
        return this.readGeometryClassFromStatement(cx, metadataTableStatement);
    }

    private Class<?> lookupGeometryClassOnAllIndex(Connection cx, String tableName, String columnName, String schema) throws SQLException {
        String allSdoSqlStatement = "SELECT META.SDO_LAYER_GTYPE\nFROM ALL_INDEXES INFO\nINNER JOIN MDSYS.ALL_SDO_INDEX_METADATA META\nON INFO.INDEX_NAME = META.SDO_INDEX_NAME\nWHERE INFO.TABLE_NAME = '" + tableName + "'\n" + "AND REPLACE(meta.sdo_column_name, '\"') = '" + columnName + "'\n";
        if (schema != null && !"".equals(schema)) {
            allSdoSqlStatement = allSdoSqlStatement + " AND INFO.TABLE_OWNER = '" + schema + "'";
            allSdoSqlStatement = allSdoSqlStatement + " AND META.SDO_INDEX_OWNER = '" + schema + "'";
        }
        return this.readGeometryClassFromStatement(cx, allSdoSqlStatement);
    }

    private Class lookupGeometryClassOnUserIndex(Connection cx, String tableName, String columnName, String schema) throws SQLException {
        if (!this.canAccessUserViews(cx)) {
            return null;
        }
        String userSdoSqlStatement = "SELECT META.SDO_LAYER_GTYPE\nFROM ALL_INDEXES INFO\nINNER JOIN MDSYS.USER_SDO_INDEX_METADATA META\nON INFO.INDEX_NAME = META.SDO_INDEX_NAME\nWHERE INFO.TABLE_NAME = '" + tableName + "'\n" + "AND REPLACE(meta.sdo_column_name, '\"') = '" + columnName + "'\n";
        if (schema != null && !"".equals(schema)) {
            userSdoSqlStatement = userSdoSqlStatement + " AND INFO.TABLE_OWNER = '" + schema + "'";
        }
        return this.readGeometryClassFromStatement(cx, userSdoSqlStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class readGeometryClassFromStatement(Connection cx, String sql) throws SQLException {
        ResultSet rs;
        Statement st;
        block3: {
            Class<Geometry> clazz;
            st = null;
            rs = null;
            try {
                st = cx.createStatement();
                LOGGER.log(Level.FINE, "Geometry type check; {0} ", sql);
                rs = st.executeQuery(sql);
                if (!rs.next()) break block3;
                String gType = rs.getString(1);
                Class<Geometry> geometryClass = (Class<Geometry>)TT.GEOM_CLASSES.get(gType);
                if (geometryClass == null) {
                    LOGGER.log(Level.WARNING, "Unrecognized geometry type " + gType + " falling back on generic 'GEOMETRY'");
                    geometryClass = Geometry.class;
                }
                clazz = geometryClass;
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(st);
            return clazz;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(st);
        return null;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (tableName.endsWith("$")) {
            return false;
        }
        if (tableName.startsWith("BIN$")) {
            return false;
        }
        if (tableName.startsWith("XDB$")) {
            return false;
        }
        if (tableName.startsWith("DR$")) {
            return false;
        }
        if (tableName.startsWith("DEF$")) {
            return false;
        }
        if (tableName.startsWith("SDO_")) {
            return false;
        }
        if (tableName.startsWith("WM$")) {
            return false;
        }
        if (tableName.startsWith("WK$")) {
            return false;
        }
        if (tableName.startsWith("AW$")) {
            return false;
        }
        if (tableName.startsWith("AQ$")) {
            return false;
        }
        if (tableName.startsWith("APPLY$")) {
            return false;
        }
        if (tableName.startsWith("REPCAT$")) {
            return false;
        }
        if (tableName.startsWith("CWM$")) {
            return false;
        }
        if (tableName.startsWith("CWM2$")) {
            return false;
        }
        if (tableName.startsWith("EXF$")) {
            return false;
        }
        return !tableName.startsWith("DM$");
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("SDO_GEOMETRY", Geometry.class);
        mappings.put("MDSYS.SDO_GEOMETRY", Geometry.class);
    }

    public String getNameEscape() {
        return "";
    }

    public void encodeColumnName(String raw, StringBuffer sql) {
        if ((raw = raw.toUpperCase()).length() > 30) {
            raw = raw.substring(0, 30);
        }
        sql.append(raw);
    }

    public void encodeTableName(String raw, StringBuffer sql) {
        if ((raw = raw.toUpperCase()).length() > 30) {
            raw = raw.substring(0, 30);
        }
        sql.append(raw);
    }

    public String getGeometryTypeName(Integer type) {
        return "MDSYS.SDO_GEOMETRY";
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry geom = this.readGeometry(rs, column, new GeometryFactory(), cx);
        return geom != null ? geom.getEnvelopeInternal() : null;
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        Geometry geom = this.readGeometry(rs, column, factory, cx);
        return this.convertGeometry(geom, descriptor, factory);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        Geometry geom = this.readGeometry(rs, column, factory, cx);
        return this.convertGeometry(geom, descriptor, factory);
    }

    Geometry convertGeometry(Geometry geom, GeometryDescriptor descriptor, GeometryFactory factory) {
        if (geom == null) {
            return null;
        }
        Class targetClazz = descriptor.getType().getBinding();
        if (targetClazz.equals(MultiPolygon.class) && geom instanceof Polygon) {
            return factory.createMultiPolygon(new Polygon[]{(Polygon)geom});
        }
        if (targetClazz.equals(MultiPoint.class) && geom instanceof Point) {
            return factory.createMultiPoint(new Point[]{(Point)geom});
        }
        if (targetClazz.equals(MultiLineString.class) && geom instanceof LineString) {
            return factory.createMultiLineString(new LineString[]{(LineString)geom});
        }
        if (targetClazz.equals(GeometryCollection.class)) {
            return factory.createGeometryCollection(new Geometry[]{geom});
        }
        return geom;
    }

    Geometry readGeometry(ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.readGeometry(rs.getObject(column), factory, cx);
    }

    Geometry readGeometry(ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.readGeometry(rs.getObject(column), factory, cx);
    }

    Geometry readGeometry(Object struct, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        if (struct == null) {
            return null;
        }
        OracleConnection ocx = this.unwrapConnection(cx);
        GeometryConverter converter = factory != null ? new GeometryConverter(ocx, factory) : new GeometryConverter(ocx);
        return converter.asGeometry((STRUCT)struct);
    }

    public void setGeometryValue(Geometry g, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null) {
            ps.setNull(column, 2002, "MDSYS.SDO_GEOMETRY");
            return;
        }
        OracleConnection ocx = this.unwrapConnection(ps.getConnection());
        GeometryConverter converter = new GeometryConverter(ocx);
        STRUCT s = converter.toSDO(g, srid);
        ps.setObject(column, s);
        if (LOGGER.isLoggable(Level.FINE)) {
            String sdo = SDOSqlDumper.toSDOGeom(g, srid);
            LOGGER.fine("Setting parameter " + column + " as " + sdo);
        }
    }

    OracleConnection unwrapConnection(Connection cx) throws SQLException {
        if (cx == null) {
            return null;
        }
        if (cx instanceof OracleConnection) {
            return (OracleConnection)cx;
        }
        try {
            Connection uwcx;
            if (this.uw == null) {
                this.uw = DataSourceFinder.getUnWrapper((Connection)cx);
            }
            if (this.uw != null && (uwcx = this.uw.unwrap(cx)) != null && uwcx instanceof OracleConnection) {
                return (OracleConnection)uwcx;
            }
        }
        catch (IOException e) {
            throw (SQLException)new SQLException("Could not obtain native oracle connection.").initCause(e);
        }
        throw new SQLException("Could not obtain native oracle connection for " + cx.getClass());
    }

    public FilterToSQL createFilterToSQL() {
        throw new UnsupportedOperationException("This dialect works with prepared statements only");
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        OracleFilterToSQL sql = new OracleFilterToSQL(this);
        sql.setLooseBBOXEnabled(this.looseBBOXEnabled);
        return sql;
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer srid = this.lookupSRIDOnMetadataTable(schemaName, tableName, columnName, cx);
        if (srid == null) {
            srid = this.lookupSRIDFromUserViews(tableName, columnName, cx);
        }
        if (srid == null) {
            srid = this.lookupSRIDFromAllViews(schemaName, tableName, columnName, cx);
        }
        return srid;
    }

    private Integer lookupSRIDOnMetadataTable(String schema, String tableName, String columnName, Connection cx) throws SQLException {
        if (this.geometryMetadataTable == null) {
            return null;
        }
        String metadataTableStatement = "SELECT SRID FROM " + this.geometryMetadataTable + " WHERE F_TABLE_NAME = '" + tableName + "'" + " AND F_GEOMETRY_COLUMN = '" + columnName + "'";
        if (schema != null && !"".equals(schema)) {
            metadataTableStatement = metadataTableStatement + " AND F_TABLE_SCHEMA = '" + schema + "'";
        }
        return this.readSRIDFromStatement(cx, metadataTableStatement);
    }

    private Integer lookupSRIDFromAllViews(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer allSdoSql = new StringBuffer("SELECT SRID FROM MDSYS.ALL_SDO_GEOM_METADATA WHERE ");
        allSdoSql.append("TABLE_NAME='").append(tableName.toUpperCase()).append("' AND ");
        allSdoSql.append("COLUMN_NAME='").append(columnName.toUpperCase()).append("'");
        if (schemaName != null) {
            allSdoSql.append(" AND OWNER='" + schemaName + "'");
        }
        return this.readSRIDFromStatement(cx, allSdoSql.toString());
    }

    private Integer lookupSRIDFromUserViews(String tableName, String columnName, Connection cx) throws SQLException {
        if (!this.canAccessUserViews(cx)) {
            return null;
        }
        StringBuffer userSdoSql = new StringBuffer("SELECT SRID FROM MDSYS.USER_SDO_GEOM_METADATA WHERE ");
        userSdoSql.append("TABLE_NAME='").append(tableName.toUpperCase()).append("' AND ");
        userSdoSql.append("COLUMN_NAME='").append(columnName.toUpperCase()).append("'");
        return this.readSRIDFromStatement(cx, userSdoSql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer readSRIDFromStatement(Connection cx, String sql) throws SQLException {
        ResultSet userSdoResult;
        Statement userSdoStatement;
        block2: {
            Integer n;
            userSdoStatement = null;
            userSdoResult = null;
            try {
                Object srid;
                userSdoStatement = cx.createStatement();
                LOGGER.log(Level.FINE, "SRID check; {0} ", sql);
                userSdoResult = userSdoStatement.executeQuery(sql);
                if (!userSdoResult.next() || (srid = userSdoResult.getObject(1)) == null) break block2;
                n = ((Number)srid).intValue();
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(userSdoResult);
                this.dataStore.closeSafe(userSdoStatement);
                throw throwable;
            }
            this.dataStore.closeSafe(userSdoResult);
            this.dataStore.closeSafe(userSdoStatement);
            return n;
        }
        this.dataStore.closeSafe(userSdoResult);
        this.dataStore.closeSafe(userSdoStatement);
        return null;
    }

    /*
     * Exception decompiling
     */
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("SDO_AGGR_MBR(");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ArrayList<ReferencedEnvelope> result;
        ResultSet rs;
        Statement st;
        block10: {
            if (!this.estimatedExtentsEnabled) return null;
            if (this.dataStore.getVirtualTables().get(featureType.getTypeName()) != null) {
                return null;
            }
            String tableName = featureType.getTypeName();
            st = null;
            rs = null;
            result = new ArrayList<ReferencedEnvelope>();
            Savepoint savePoint = null;
            try {
                st = cx.createStatement();
                if (!cx.getAutoCommit()) {
                    savePoint = cx.setSavepoint();
                }
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    Envelope env;
                    if (!(att instanceof GeometryDescriptor)) continue;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select SDO_TUNE.EXTENT_OF('");
                    sql.append(tableName);
                    sql.append("', '");
                    sql.append(att.getName().getLocalPart());
                    sql.append("') FROM DUAL");
                    rs = st.executeQuery(sql.toString());
                    if (rs.next() && (env = this.decodeGeometryEnvelope(rs, 1, cx)) != null && !env.isNull()) {
                        CoordinateReferenceSystem crs = ((GeometryDescriptor)att).getCoordinateReferenceSystem();
                        result.add(new ReferencedEnvelope(env, crs));
                    }
                    rs.close();
                }
                if (savePoint == null) break block10;
            }
            catch (SQLException e) {
                List<ReferencedEnvelope> list;
                block11: {
                    try {
                        if (savePoint != null) {
                            cx.rollback(savePoint);
                        }
                        LOGGER.log(Level.WARNING, "Failed to use SDO_TUNE.EXTENT_OF, falling back on envelope aggregation", e);
                        list = null;
                        if (savePoint == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (savePoint != null) {
                            cx.rollback(savePoint);
                        }
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe(st);
                        throw throwable;
                    }
                    cx.rollback(savePoint);
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                return list;
            }
            cx.rollback(savePoint);
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(st);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        String tableName = featureType.getName().getLocalPart().toUpperCase();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                double tolerance;
                int i;
                String[] axisNames;
                double[] max;
                double[] min;
                int dims;
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor geom = (GeometryDescriptor)att;
                if (geom.getCoordinateReferenceSystem() != null) {
                    CoordinateSystem cs = geom.getCoordinateReferenceSystem().getCoordinateSystem();
                    dims = geom.getUserData().get(Hints.COORDINATE_DIMENSION) != null ? ((Number)geom.getUserData().get(Hints.COORDINATE_DIMENSION)).intValue() : cs.getDimension();
                    min = new double[dims];
                    max = new double[dims];
                    axisNames = new String[dims];
                    double extent = Double.MAX_VALUE;
                    for (i = 0; i < dims; ++i) {
                        if (i < cs.getDimension()) {
                            CoordinateSystemAxis axis = cs.getAxis(i);
                            axisNames[i] = axis.getAbbreviation();
                            min[i] = Double.isInfinite(axis.getMinimumValue()) ? -1.0E7 : axis.getMinimumValue();
                            double d = max[i] = Double.isInfinite(axis.getMaximumValue()) ? 1000000.0 : axis.getMaximumValue();
                            if (!(max[i] - min[i] < extent)) continue;
                            extent = max[i] - min[i];
                            continue;
                        }
                        min[i] = -1.0E7;
                        max[i] = 1.0E7;
                    }
                    tolerance = extent / 1.0E7;
                } else {
                    dims = 2;
                    axisNames = new String[2];
                    min = new double[2];
                    max = new double[2];
                    axisNames[0] = "X";
                    axisNames[1] = "Y";
                    min[0] = -1.0E7;
                    min[1] = -1.0E7;
                    max[0] = 1.0E7;
                    max[1] = 1.0E7;
                    tolerance = 0.01;
                }
                int srid = -1;
                if (geom.getUserData().get("nativeSRID") != null) {
                    srid = (Integer)geom.getUserData().get("nativeSRID");
                } else if (geom.getCoordinateReferenceSystem() != null) {
                    try {
                        Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)geom.getCoordinateReferenceSystem(), (boolean)true);
                        if (result != null) {
                            srid = result;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                    }
                }
                String geomColumnName = geom.getLocalName().toUpperCase();
                String sql = "INSERT INTO USER_SDO_GEOM_METADATA(TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)\nVALUES (\n'" + tableName + "',\n" + "'" + geomColumnName + "',\n" + "MDSYS.SDO_DIM_ARRAY(\n";
                for (i = 0; i < dims; ++i) {
                    sql = sql + "   MDSYS.SDO_DIM_ELEMENT('" + axisNames[i] + "', " + min[i] + ", " + max[i] + ", " + tolerance + ")";
                    if (i < dims - 1) {
                        sql = sql + ", ";
                    }
                    sql = sql + "\n";
                }
                sql = sql + "),\n" + (srid == -1 ? "NULL" : String.valueOf(srid)) + ")";
                LOGGER.log(Level.FINE, "Creating metadata with sql: {0}", sql);
                st.execute(sql);
                int idxDim = this.isGeodeticSrid(srid, cx) ? 2 : dims;
                String type = CLASSES_TO_GEOM.get(geom.getType().getBinding());
                String idxName = tableName + "_" + geomColumnName + "_IDX";
                sql = "CREATE INDEX " + idxName + " ON \"" + tableName + "\"(\"" + geomColumnName + "\")" + " INDEXTYPE IS MDSYS.SPATIAL_INDEX" + " PARAMETERS ('SDO_INDX_DIMS=" + idxDim;
                sql = type != null ? sql + " LAYER_GTYPE=\"" + type + "\"')" : sql + "')";
                LOGGER.log(Level.FINE, "Creating index with sql: {0}", sql);
                st.execute(sql);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = (tableName + "_" + columnName + "_SEQUENCE").toUpperCase();
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery("SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName + "'");
            try {
                if (rs.next()) {
                    String string = sequenceName;
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
            this.dataStore.closeSafe(rs);
            rs = st.executeQuery("SELECT * FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName + "'");
            try {
                if (rs.next()) {
                    String schema = rs.getString("OWNER");
                    String string = schema + "." + sequenceName;
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery("SELECT " + sequenceName + ".NEXTVAL FROM DUAL");
            try {
                rs.next();
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isGeodeticSrid(Integer srid, Connection cx) {
        if (srid == null) {
            return false;
        }
        Boolean geodetic = (Boolean)this.geodeticCache.get((Object)srid);
        if (geodetic != null) return geodetic;
        OracleDialect oracleDialect = this;
        synchronized (oracleDialect) {
            geodetic = (Boolean)this.geodeticCache.get((Object)srid);
            if (geodetic != null) return geodetic;
            PreparedStatement ps = null;
            ResultSet rs = null;
            boolean closeConnection = false;
            try {
                ps = cx.prepareStatement("SELECT COUNT(*) FROM MDSYS.GEODETIC_SRIDS WHERE SRID = ?");
                ps.setInt(1, srid);
                rs = ps.executeQuery();
                rs.next();
                geodetic = rs.getInt(1) > 0;
                this.geodeticCache.put((Object)srid, (Object)geodetic);
            }
            catch (SQLException e) {
                try {
                    LOGGER.log(Level.WARNING, "Could not evaluate if the SRID " + srid + " is geodetic", e);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe((Statement)ps);
                    if (!closeConnection) throw throwable;
                    this.dataStore.closeSafe(cx);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe((Statement)ps);
                if (!closeConnection) return geodetic;
                this.dataStore.closeSafe(cx);
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
            if (!closeConnection) return geodetic;
            this.dataStore.closeSafe(cx);
            return geodetic;
        }
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (offset == 0) {
            sql.insert(0, "SELECT * FROM (");
            sql.append(") WHERE ROWNUM <= " + limit);
        } else {
            long max = limit == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)(limit + offset);
            sql.insert(0, "SELECT * FROM (SELECT A.*, ROWNUM RNUM FROM ( ");
            sql.append(") A WHERE ROWNUM <= " + max + ")");
            sql.append("WHERE RNUM > " + offset);
        }
    }

    public void encodeTableAlias(String raw, StringBuffer sql) {
        sql.append(" ");
        this.encodeTableName(raw, sql);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(7, "DOUBLE PRECISION");
        overrides.put(8, "DOUBLE PRECISION");
        overrides.put(6, "FLOAT");
    }

    public void postCreateAttribute(AttributeDescriptor att, String tableName, String schemaName, Connection cx) throws SQLException {
        super.postCreateAttribute(att, tableName, schemaName, cx);
        if (att instanceof GeometryDescriptor) {
            Integer srid = (Integer)att.getUserData().get("nativeSRID");
            boolean geodetic = this.isGeodeticSrid(srid, cx);
            att.getUserData().put(GEODETIC, geodetic);
        }
    }

    public String getGeometryMetadataTable() {
        return this.geometryMetadataTable;
    }

    public void setGeometryMetadataTable(String geometryMetadataTable) {
        this.geometryMetadataTable = geometryMetadataTable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class GeomClasses
    extends HashMap<Class, String> {
        private static final long serialVersionUID = -3359664692996608331L;

        public GeomClasses() {
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINE");
            this.put(LinearRing.class, "LINE");
            this.put(Polygon.class, "POLYGON");
            this.put(GeometryCollection.class, "COLLECTION");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINE");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
        }
    }
}

