/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.PostgisFilterToSQL;
import org.geotools.data.postgis.PostgisPSFilterToSql;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.SQLDialect;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterToSqlHelper {
    protected static final String IO_ERROR = "io problem writing filter";
    private static final Map<String, Double> UNITS_MAP = new HashMap<String, Double>(){
        {
            this.put("kilometers", 1000.0);
            this.put("kilometer", 1000.0);
            this.put("mm", 0.001);
            this.put("millimeter", 0.001);
            this.put("mi", 1609.344);
            this.put("miles", 1609.344);
            this.put("NM", 1852.0);
            this.put("feet", 0.3048);
            this.put("ft", 0.3048);
            this.put("in", 0.0254);
        }
    };
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    FilterToSQL delegate;
    Writer out;
    boolean looseBBOXEnabled;

    public FilterToSqlHelper(FilterToSQL delegate) {
        this.delegate = delegate;
    }

    public static FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
            } else {
                this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (filter instanceof DWithin && !swapped || filter instanceof Beyond && swapped) {
            this.out.write("ST_DWithin(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            this.out.write(this.toMeters(filter.getDistance(), filter.getDistanceUnits()));
            this.out.write(")");
        }
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.out.write("ST_Distance(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(") > ");
            this.out.write(Double.toString(filter.getDistance()));
        }
    }

    private String toMeters(double distance, String unit) {
        Double conversion;
        if (this.isCurrentGeography() && (conversion = UNITS_MAP.get(unit)) != null) {
            return String.valueOf(distance * conversion);
        }
        return String.valueOf(distance);
    }

    void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (this.isCurrentGeography()) {
            if (this.isWorld(geometry = this.clipToWorld(geometry))) {
                this.out.write(" TRUE ");
                return;
            }
            if (this.isEmpty(geometry)) {
                if (!(filter instanceof Disjoint)) {
                    this.out.write(" FALSE ");
                } else {
                    this.out.write(" TRUE ");
                }
                return;
            }
        }
        if (!(filter instanceof Disjoint)) {
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(" && ");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            if (filter instanceof BBOX && this.looseBBOXEnabled) {
                return;
            }
            this.out.write(" AND ");
        }
        String closingParenthesis = ")";
        if (filter instanceof Equals) {
            this.out.write("ST_Equals");
        } else if (filter instanceof Disjoint) {
            this.out.write("NOT (ST_Intersects");
            closingParenthesis = closingParenthesis + ")";
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            this.out.write("ST_Intersects");
        } else if (filter instanceof Crosses) {
            this.out.write("ST_Crosses");
        } else if (filter instanceof Within) {
            if (swapped) {
                this.out.write("ST_Contains");
            } else {
                this.out.write("ST_Within");
            }
        } else if (filter instanceof Contains) {
            if (swapped) {
                this.out.write("ST_Within");
            } else {
                this.out.write("ST_Contains");
            }
        } else if (filter instanceof Overlaps) {
            this.out.write("ST_Overlaps");
        } else if (filter instanceof Touches) {
            this.out.write("ST_Touches");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        this.out.write("(");
        property.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(", ");
        geometry.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(closingParenthesis);
    }

    boolean isCurrentGeography() {
        GeometryDescriptor geom = null;
        if (this.delegate instanceof PostgisPSFilterToSql) {
            geom = ((PostgisPSFilterToSql)this.delegate).getCurrentGeometry();
        } else if (this.delegate instanceof PostgisFilterToSQL) {
            geom = ((PostgisFilterToSQL)this.delegate).getCurrentGeometry();
        }
        return geom != null && "geography".equals(geom.getUserData().get("org.geotools.jdbc.nativeTypeName"));
    }

    private Literal clipToWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            Envelope env = g.getEnvelopeInternal();
            if (!WORLD.contains(env)) {
                g = this.sanitizePolygons(g.intersection((Geometry)JTS.toGeometry((Envelope)WORLD)));
            }
            if (Math.sqrt((env = g.getEnvelopeInternal()).getWidth() * env.getWidth() + env.getHeight() * env.getHeight()) >= 180.0) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (double lon = Math.floor(env.getMinX()); lon < env.getMaxX(); lon += 90.0) {
                    for (double lat = Math.floor(env.getMinY()); lat < env.getMaxY(); lat += 90.0) {
                        Polygon quadrant = JTS.toGeometry((Envelope)new Envelope(lon, lon + 90.0, lat, lat + 90.0));
                        Geometry cut = this.sanitizePolygons(g.intersection((Geometry)quadrant));
                        if (cut.isEmpty()) continue;
                        if (cut instanceof Polygon) {
                            polygons.add((Polygon)cut);
                            continue;
                        }
                        for (int i = 0; i < cut.getNumGeometries(); ++i) {
                            polygons.add((Polygon)cut.getGeometryN(i));
                        }
                    }
                }
                g = this.toPolygon(g.getFactory(), polygons);
            }
            geometry = CommonFactoryFinder.getFilterFactory(null).literal((Object)g);
        }
        return geometry;
    }

    private Geometry sanitizePolygons(Geometry geometry) {
        if (geometry == null || geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return geometry;
        }
        final ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                if (geom instanceof Polygon) {
                    polygons.add((Polygon)geom);
                }
            }
        });
        return this.toPolygon(geometry.getFactory(), polygons);
    }

    private Geometry toPolygon(GeometryFactory gf, List<Polygon> polygons) {
        if (polygons.size() == 0) {
            return gf.createGeometryCollection(null);
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    private boolean isWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            return JTS.toGeometry((Envelope)WORLD).equals(g.union());
        }
        return false;
    }

    private boolean isEmpty(Literal geometry) {
        if (geometry != null) {
            Geometry g = (Geometry)geometry.evaluate(null, Geometry.class);
            return g == null || g.isEmpty();
        }
        return false;
    }
}

