/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.PostgisFilterToSQL;
import org.geotools.data.postgis.WKBAttributeIO;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostGISDialect
extends BasicSQLDialect {
    static final Map<String, Class> TYPE_TO_CLASS_MAP = new HashMap<String, Class>(){
        {
            this.put("GEOMETRY", Geometry.class);
            this.put("GEOGRAPHY", Geometry.class);
            this.put("POINT", Point.class);
            this.put("POINTM", Point.class);
            this.put("LINESTRING", LineString.class);
            this.put("LINESTRINGM", LineString.class);
            this.put("POLYGON", Polygon.class);
            this.put("POLYGONM", Polygon.class);
            this.put("MULTIPOINT", MultiPoint.class);
            this.put("MULTIPOINTM", MultiPoint.class);
            this.put("MULTILINESTRING", MultiLineString.class);
            this.put("MULTILINESTRINGM", MultiLineString.class);
            this.put("MULTIPOLYGON", MultiPolygon.class);
            this.put("MULTIPOLYGONM", MultiPolygon.class);
            this.put("GEOMETRYCOLLECTION", GeometryCollection.class);
            this.put("GEOMETRYCOLLECTIONM", GeometryCollection.class);
            this.put("BYTEA", byte[].class);
        }
    };
    static final Map<Class, String> CLASS_TO_TYPE_MAP = new HashMap<Class, String>(){
        {
            this.put(Geometry.class, "GEOMETRY");
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINESTRING");
            this.put(Polygon.class, "POLYGON");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINESTRING");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
            this.put(GeometryCollection.class, "GEOMETRYCOLLECTION");
            this.put(byte[].class, "BYTEA");
        }
    };
    static final Version V_1_5_0 = new Version("1.5.0");
    boolean looseBBOXEnabled = false;
    boolean estimatedExtentsEnabled = false;
    Version version;
    ThreadLocal<WKBAttributeIO> wkbReader = new ThreadLocal();

    public PostGISDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtentsEnabled) {
        this.estimatedExtentsEnabled = estimatedExtentsEnabled;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (tableName.equals("geometry_columns")) {
            return false;
        }
        if (tableName.startsWith("spatial_ref_sys")) {
            return false;
        }
        return !tableName.equals("geography_columns");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        WKBAttributeIO reader = this.getWKBReader(factory);
        return (Geometry)reader.read(rs, column);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        WKBAttributeIO reader = this.getWKBReader(factory);
        return (Geometry)reader.read(rs, column);
    }

    private WKBAttributeIO getWKBReader(GeometryFactory factory) {
        WKBAttributeIO reader = this.wkbReader.get();
        if (reader == null) {
            reader = new WKBAttributeIO(factory);
            this.wkbReader.set(reader);
        } else {
            reader.setGeometryFactory(factory);
        }
        return reader;
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        this.encodeGeometryColumn(gatt, srid, null, sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, Hints hints, StringBuffer sql) {
        boolean geography = "geography".equals(gatt.getUserData().get("org.geotools.jdbc.nativeTypeName"));
        if (geography) {
            sql.append("encode(ST_AsBinary(");
            this.encodeColumnName(gatt.getLocalName(), sql);
            sql.append("),'base64')");
        } else {
            boolean force2D;
            boolean bl = force2D = hints != null && hints.containsKey((Object)Hints.FEATURE_2D) && Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D));
            if (force2D) {
                sql.append("encode(ST_AsBinary(ST_Force_2D(");
                this.encodeColumnName(gatt.getLocalName(), sql);
                sql.append(")),'base64')");
            } else {
                sql.append("encode(ST_AsEWKB(");
                this.encodeColumnName(gatt.getLocalName(), sql);
                sql.append("),'base64')");
            }
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_AsText(ST_Force_2D(ST_Envelope(");
        sql.append("ST_Extent(\"" + geometryColumn + "\"::geometry))))");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ArrayList<ReferencedEnvelope> result;
        ResultSet rs;
        Statement st;
        block11: {
            if (!this.estimatedExtentsEnabled) {
                return null;
            }
            String tableName = featureType.getTypeName();
            st = null;
            rs = null;
            result = new ArrayList<ReferencedEnvelope>();
            Savepoint savePoint = null;
            try {
                st = cx.createStatement();
                if (!cx.getAutoCommit()) {
                    savePoint = cx.setSavepoint();
                }
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    Envelope env;
                    if (!(att instanceof GeometryDescriptor)) continue;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select AsText(force_2d(Envelope(ST_Estimated_Extent('");
                    if (schema != null) {
                        sql.append(schema);
                        sql.append("', '");
                    }
                    sql.append(tableName);
                    sql.append("', '");
                    sql.append(att.getName().getLocalPart());
                    sql.append("'))))");
                    rs = st.executeQuery(sql.toString());
                    if (rs.next() && !(env = this.decodeGeometryEnvelope(rs, 1, cx)).isNull()) {
                        CoordinateReferenceSystem crs = ((GeometryDescriptor)att).getCoordinateReferenceSystem();
                        result.add(new ReferencedEnvelope(env, crs));
                    }
                    rs.close();
                }
                if (savePoint == null) break block11;
            }
            catch (SQLException e) {
                List<ReferencedEnvelope> list;
                block12: {
                    try {
                        if (savePoint != null) {
                            cx.rollback(savePoint);
                        }
                        LOGGER.log(Level.WARNING, "Failed to use ST_Estimated_Extent, falling back on envelope aggregation", e);
                        list = null;
                        if (savePoint == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (savePoint != null) {
                            cx.releaseSavepoint(savePoint);
                        }
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe(st);
                        throw throwable;
                    }
                    cx.releaseSavepoint(savePoint);
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                return list;
            }
            cx.releaseSavepoint(savePoint);
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(st);
        return result;
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        try {
            String envelope = rs.getString(column);
            if (envelope != null) {
                return new WKTReader().read(envelope).getEnvelopeInternal();
            }
            return new Envelope();
        }
        catch (ParseException e) {
            throw (IOException)new IOException("Error occurred parsing the bounds WKT").initCause(e);
        }
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String typeName = columnMetaData.getString("TYPE_NAME");
        if ("uuid".equalsIgnoreCase(typeName)) {
            return UUID.class;
        }
        String gType = null;
        if ("geometry".equalsIgnoreCase(typeName)) {
            gType = this.lookupGeometryType(columnMetaData, cx, "geometry_columns", "f_geometry_column");
        } else if ("geography".equalsIgnoreCase(typeName)) {
            gType = this.lookupGeometryType(columnMetaData, cx, "geography_columns", "f_geography_column");
        } else {
            return null;
        }
        if (gType == null) {
            return Geometry.class;
        }
        Class<Geometry> geometryClass = TYPE_TO_CLASS_MAP.get(gType.toUpperCase());
        if (geometryClass == null) {
            geometryClass = Geometry.class;
        }
        return geometryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lookupGeometryType(ResultSet columnMetaData, Connection cx, String gTableName, String gColumnName) throws SQLException {
        ResultSet result;
        Statement statement;
        block2: {
            String string;
            String tableName = columnMetaData.getString("TABLE_NAME");
            String columnName = columnMetaData.getString("COLUMN_NAME");
            String schemaName = columnMetaData.getString("TABLE_SCHEM");
            Object conn = null;
            statement = null;
            result = null;
            try {
                String sqlStatement = "SELECT TYPE FROM " + gTableName + " WHERE " + "F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND " + gColumnName + " = '" + columnName + "'";
                LOGGER.log(Level.FINE, "Geometry type check; {0} ", sqlStatement);
                statement = cx.createStatement();
                result = statement.executeQuery(sqlStatement);
                if (!result.next()) break block2;
                string = result.getString(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                throw throwable;
            }
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            return string;
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUserDefinedType(ResultSet columnMetaData, ColumnMetadata metadata, Connection cx) throws SQLException {
        String tableName = columnMetaData.getString("TABLE_NAME");
        String columnName = columnMetaData.getString("COLUMN_NAME");
        String schemaName = columnMetaData.getString("TABLE_SCHEM");
        String sql = "SELECT udt_name FROM information_schema.columns  WHERE table_schema = '" + schemaName + "' " + "   AND table_name = '" + tableName + "' " + "   AND column_name = '" + columnName + "' ";
        LOGGER.fine(sql);
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    metadata.setTypeName(rs.getString(1));
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sqlStatement;
        Integer srid;
        ResultSet result;
        Statement statement;
        block16: {
            block17: {
                Integer n;
                statement = null;
                result = null;
                srid = null;
                try {
                    if (schemaName == null) {
                        schemaName = "public";
                    }
                    if (!this.supportsGeography(cx)) break block16;
                    try {
                        sqlStatement = "SELECT SRID FROM GEOGRAPHY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOGRAPHY_COLUMN = '" + columnName + "'";
                        LOGGER.log(Level.FINE, "Geography srid check; {0} ", sqlStatement);
                        statement = cx.createStatement();
                        result = statement.executeQuery(sqlStatement);
                        if (!result.next()) break block17;
                        n = 4326;
                        this.dataStore.closeSafe(result);
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking geometry_columns instead", e);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(result);
                    this.dataStore.closeSafe(statement);
                    throw throwable;
                }
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                return n;
            }
            this.dataStore.closeSafe(result);
            break block16;
            finally {
                this.dataStore.closeSafe(result);
            }
        }
        try {
            sqlStatement = "SELECT SRID FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOMETRY_COLUMN = '" + columnName + "'";
            LOGGER.log(Level.FINE, "Geometry srid check; {0} ", sqlStatement);
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                srid = result.getInt(1);
            }
            this.dataStore.closeSafe(result);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking the first geometry instead", e);
        }
        finally {
            this.dataStore.closeSafe(result);
        }
        if (srid == null && (result = statement.executeQuery(sqlStatement = "SELECT SRID(\"" + columnName + "\") " + "FROM \"" + schemaName + "\".\"" + tableName + "\" " + "WHERE " + columnName + " IS NOT NULL " + "LIMIT 1")).next()) {
            srid = result.getInt(1);
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT pg_get_serial_sequence('\"";
            if (schemaName != null && !"".equals(schemaName)) {
                sql = sql + schemaName + "\".\"";
            }
            sql = sql + tableName + "\"', '" + columnName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT nextval('" + sequenceName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT lastval()";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("geometry", Geometry.class);
        mappings.put("geography", Geometry.class);
        mappings.put("text", String.class);
        mappings.put("int8", Long.class);
        mappings.put("int4", Integer.class);
        mappings.put("bool", Boolean.class);
        mappings.put("character", String.class);
        mappings.put("float8", Double.class);
        mappings.put("int", Integer.class);
        mappings.put("float4", Float.class);
        mappings.put("int2", Short.class);
        mappings.put("time", Time.class);
        mappings.put("timetz", Time.class);
        mappings.put("timestamp", Timestamp.class);
        mappings.put("timestamptz", Timestamp.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(12, "VARCHAR");
        overrides.put(16, "BOOL");
    }

    public String getGeometryTypeName(Integer type) {
        return "geometry";
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" SERIAL PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        schemaName = schemaName != null ? schemaName : "public";
        String tableName = featureType.getName().getLocalPart();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)att;
                int srid = -1;
                if (gd.getUserData().get("nativeSRID") != null) {
                    srid = (Integer)gd.getUserData().get("nativeSRID");
                } else if (gd.getCoordinateReferenceSystem() != null) {
                    try {
                        Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)true);
                        if (result != null) {
                            srid = result;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                    }
                }
                int dimensions = 2;
                String geomType = CLASS_TO_TYPE_MAP.get(gd.getType().getBinding());
                if (geomType == null) {
                    geomType = "GEOMETRY";
                }
                String sql = "DELETE FROM GEOMETRY_COLUMNS WHERE f_table_catalog='' AND f_table_schema = '" + schemaName + "'" + " AND f_table_name = '" + tableName + "'" + " AND f_geometry_column = '" + gd.getLocalName() + "'";
                LOGGER.fine(sql);
                st.execute(sql);
                sql = "INSERT INTO GEOMETRY_COLUMNS VALUES ('','" + schemaName + "'," + "'" + tableName + "'," + "'" + gd.getLocalName() + "'," + dimensions + "," + srid + "," + "'" + geomType + "')";
                LOGGER.fine(sql);
                st.execute(sql);
                if (srid > -1) {
                    sql = "ALTER TABLE \"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_srid_" + gd.getLocalName() + "\"" + " CHECK (SRID(" + "\"" + gd.getLocalName() + "\"" + ") = " + srid + ")";
                    LOGGER.fine(sql);
                    st.execute(sql);
                }
                sql = "ALTER TABLE \"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_dims_" + gd.getLocalName() + "\"" + " CHECK (st_ndims(\"" + gd.getLocalName() + "\")" + " = 2)";
                LOGGER.fine(sql);
                st.execute(sql);
                if (!geomType.equals("GEOMETRY")) {
                    sql = "ALTER TABLE \"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_geotype_" + gd.getLocalName() + "\"" + " CHECK (geometrytype(" + "\"" + gd.getLocalName() + "\"" + ") = '" + geomType + "'::text " + "OR \"" + gd.getLocalName() + "\"" + " IS NULL)";
                    LOGGER.fine(sql);
                    st.execute(sql);
                }
                sql = "CREATE INDEX \"spatial_" + tableName + "_" + gd.getLocalName().toLowerCase() + "\"" + " ON " + "\"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " USING GIST (" + "\"" + gd.getLocalName() + "\"" + ")";
                LOGGER.fine(sql);
                st.execute(sql);
            }
            cx.commit();
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        if (value == null || value.isEmpty()) {
            sql.append("NULL");
        } else {
            if (value instanceof LinearRing) {
                value = value.getFactory().createLineString(((LinearRing)value).getCoordinateSequence());
            }
            sql.append("GeomFromText('" + value.toText() + "', " + srid + ")");
        }
    }

    public FilterToSQL createFilterToSQL() {
        PostgisFilterToSQL sql = new PostgisFilterToSQL(this);
        sql.setLooseBBOXEnabled(this.looseBBOXEnabled);
        return sql;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET " + offset);
        }
    }

    public void encodeValue(Object value, Class type, StringBuffer sql) {
        if (byte[].class.equals((Object)type)) {
            StringBuffer sb = new StringBuffer();
            byte[] input = (byte[])value;
            for (int i = 0; i < input.length; ++i) {
                byte b = input[i];
                if (b == 0) {
                    sb.append("\\\\000");
                    continue;
                }
                if (b == 39) {
                    sb.append("\\'");
                    continue;
                }
                if (b == 92) {
                    sb.append("\\\\134'");
                    continue;
                }
                if (b < 31 || b >= 127) {
                    sb.append("\\\\");
                    String octal = Integer.toOctalString(b);
                    if (octal.length() == 1) {
                        sb.append("00");
                    } else if (octal.length() == 2) {
                        sb.append("0");
                    }
                    sb.append(octal);
                    continue;
                }
                sb.append((char)b);
            }
            super.encodeValue((Object)sb.toString(), String.class, sql);
        } else {
            super.encodeValue(value, type, sql);
        }
    }

    public int getDefaultVarcharSize() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion(Connection conn) throws SQLException {
        if (this.version == null) {
            ResultSet rs;
            Statement st;
            block3: {
                st = null;
                rs = null;
                try {
                    st = conn.createStatement();
                    rs = st.executeQuery("select PostGIS_Lib_Version()");
                    if (!rs.next()) break block3;
                    this.version = new Version(rs.getString(1));
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe(st);
                    throw throwable;
                }
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(st);
        }
        return this.version;
    }

    boolean supportsGeography(Connection cx) throws SQLException {
        return this.getVersion(cx).compareTo(V_1_5_0) >= 0;
    }
}

