/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.postgis.PostGISPSDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class PostgisNGDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"postgis");
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extends", Boolean.class, "Use the spatial index information to quickly get an estimate of the data bounds", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)5432);
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "Schema", false, (Object)"public");
    public static final DataAccessFactory.Param PREPARED_STATEMENTS = new DataAccessFactory.Param("preparedStatements", Boolean.class, "Use prepared statements", false, (Object)Boolean.FALSE);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new PostGISDialect(dataStore);
    }

    protected String getDatabaseID() {
        return (String)PostgisNGDataStoreFactory.DBTYPE.sample;
    }

    public String getDisplayName() {
        return "PostGIS";
    }

    public String getDescription() {
        return "PostGIS Database";
    }

    protected String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    protected boolean checkDBType(Map params) {
        if (super.checkDBType(params)) {
            try {
                Class.forName("org.geotools.data.postgis.PostgisDataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return this.checkDBType(params, "postgisng");
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        PostGISDialect dialect = (PostGISDialect)dataStore.getSQLDialect();
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated == null || Boolean.TRUE.equals(estimated));
        Boolean usePs = (Boolean)PREPARED_STATEMENTS.lookUp(params);
        if (Boolean.TRUE.equals(usePs)) {
            dataStore.setSQLDialect((SQLDialect)new PostGISPSDialect(dataStore, dialect));
        }
        return dataStore;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(PostgisNGDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(PostgisNGDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(PostgisNGDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(PostgisNGDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
        parameters.put(PostgisNGDataStoreFactory.PORT.key, PORT);
        parameters.put(PostgisNGDataStoreFactory.PREPARED_STATEMENTS.key, PREPARED_STATEMENTS);
        parameters.put(PostgisNGDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
    }

    protected String getValidationQuery() {
        return "select now()";
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        return "jdbc:postgresql://" + host + ":" + port + "/" + db;
    }
}

