/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.teradata;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;

public class WKBAttributeIO {
    WKBReader wkbr;
    ByteArrayInStream byteArrayInStream = new ByteArrayInStream();
    InputStreamInStream inputStreamInStream = new InputStreamInStream();

    public WKBAttributeIO() {
        this.wkbr = new WKBReader();
    }

    public WKBAttributeIO(GeometryFactory gf) {
        this.wkbr = new WKBReader(gf);
    }

    public Geometry wkb2Geometry(byte[] wkbBytes) throws IOException {
        if (wkbBytes == null) {
            return null;
        }
        try {
            this.byteArrayInStream.setBytes(wkbBytes);
            return this.wkbr.read((InStream)this.byteArrayInStream);
        }
        catch (Exception e) {
            throw new DataSourceException("An exception occurred while parsing WKB data", (Throwable)e);
        }
    }

    public Geometry wkb2Geometry(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try {
            this.inputStreamInStream.setIn(inputStream);
            return this.wkbr.read((InStream)this.inputStreamInStream);
        }
        catch (Exception e) {
            throw new DataSourceException("An exception occurred while parsing WKB data", (Throwable)e);
        }
    }

    public Geometry read(ResultSet rs, String columnName) throws IOException {
        try {
            return this.read(rs, rs.findColumn(columnName));
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("columnName " + e + " is not a column in result set");
        }
    }

    public Geometry read(ResultSet rs, int columnIndex) throws IOException {
        try {
            switch (rs.getMetaData().getColumnType(columnIndex)) {
                case 2004: {
                    return this.readFromBlob(rs, columnIndex);
                }
            }
            return this.readFromBytes(rs, columnIndex);
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    private Geometry readFromBytes(ResultSet rs, int columnIndex) throws IOException {
        try {
            return this.wkb2Geometry(rs.getBytes(columnIndex));
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    private Geometry doReadFromBlob(Blob blob) throws IOException {
        if (blob == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            if (is == null || is.available() == 0) {
                return null;
            }
            Geometry geometry = this.wkb2Geometry(is);
            return geometry;
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private Geometry readFromBlob(ResultSet rs, int columnIndex) throws IOException {
        try {
            return this.doReadFromBlob(rs.getBlob(columnIndex));
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                ps.setBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public static byte getFromChar(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        return (byte)(c - 97 + 10);
    }

    private static class ByteArrayInStream
    implements InStream {
        byte[] buffer;
        int position;

        private ByteArrayInStream() {
        }

        public void setBytes(byte[] buffer) {
            this.buffer = buffer;
            this.position = 0;
        }

        public void read(byte[] buf) throws IOException {
            int size = buf.length;
            System.arraycopy(this.buffer, this.position, buf, 0, size);
            this.position += size;
        }
    }

    private static class InputStreamInStream
    implements InStream {
        private InputStream in;

        private InputStreamInStream() {
        }

        public void setIn(InputStream in) {
            this.in = in;
        }

        public void read(byte[] buf) throws IOException {
            this.in.read(buf);
        }
    }
}

