/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class JarCollector
extends AbstractMojo {
    private static final String SUB_DIRECTORY = "binaries";
    private String collectDirectory;
    private String outputDirectory;
    private String jarName;
    private Set<Artifact> dependencies;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        MavenProject parent = this.project;
        while (parent.hasParent()) {
            parent = parent.getParent();
        }
        this.collectDirectory = parent.getBuild().getDirectory();
        try {
            this.collect();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error collecting the JAR file.", (Exception)e);
        }
    }

    private void collect() throws MojoExecutionException, IOException {
        File jarFile = new File(this.outputDirectory, this.jarName + ".jar");
        if (!jarFile.isFile()) {
            return;
        }
        File collect = new File(this.collectDirectory);
        if (!collect.exists() && !collect.mkdir()) {
            throw new MojoExecutionException("Failed to create target directory: " + collect.getAbsolutePath());
        }
        if (collect.getCanonicalFile().equals(jarFile.getParentFile().getCanonicalFile())) {
            return;
        }
        if (!(collect = new File(collect, SUB_DIRECTORY)).exists() && !collect.mkdir()) {
            throw new MojoExecutionException("Failed to create binaries directory.");
        }
        FileUtils.copyFileToDirectory((File)jarFile, (File)collect);
        if (this.dependencies != null) {
            for (Artifact artifact : this.dependencies) {
                File copy;
                String scope = artifact.getScope();
                if (scope == null || !scope.equalsIgnoreCase("compile") && !scope.equalsIgnoreCase("runtime")) continue;
                File file = artifact.getFile();
                if (!artifact.getGroupId().startsWith("org.geotools") && (copy = new File(collect, file.getName())).exists()) continue;
                FileUtils.copyFileToDirectory((File)file, (File)collect);
            }
        }
    }
}

