/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertSourceTag {
    private final Pattern findSVNLine = Pattern.compile(".+\\/(trunk|tags|branches)\\/.*\\.java");
    private final Pattern findJavadocStart = Pattern.compile("^\\s*\\Q/**\\E");
    private final Pattern findCommentStart = Pattern.compile("^\\s*\\Q/*\\E([^\\*]|$)");
    private final Pattern findCommentEnd = Pattern.compile("\\Q*/\\E");
    private final Pattern findSourceTag = Pattern.compile("^.*?\\Q@source\\E");
    private final Pattern findCompleteSourceTag = Pattern.compile("^.*?\\Q@source\\E(.*?)\\Q.java\\E\\s*\\$?");
    private final Pattern findCompletePath = Pattern.compile("^.*?http.*?\\Q.java\\E\\s*\\$?");
    private final Pattern findVersionTag = Pattern.compile("^.*?\\Q@version\\E");
    private final Pattern findPublicClass = Pattern.compile("\\s*public[a-zA-Z\\s]+(class|interface|enum)");
    private final Pattern findClass = Pattern.compile(".*?(class|interface|enum)");
    private final Pattern findAnnotation = Pattern.compile("^@[a-zA-Z]+");
    private final String lineSeparator = System.getProperty("line.separator", "\n");
    private static final String ADD_HEADER_OPTION = "--add-header";
    private boolean optionAddHeader;
    private static final String ANY_CLASS_OPTION = "--any-class";
    private boolean optionAnyClass;
    private static final String FIX_BROKEN_TAG_OPTION = "--fix";
    private boolean optionFixBreaks;
    private static final String REPLACE_OPTION = "--replace-tag";
    private boolean optionReplace;
    private static final String SVN_OPTION = "--svn";
    private boolean optionSVNDelims;

    public static void main(String[] args) {
        InsertSourceTag app = new InsertSourceTag();
        app.run(args);
    }

    public void run(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: InsertSourceTag {options} fileOrDirName");
            System.out.println("options:");
            System.out.println("   --any-class: Process any class. Default is only public classes.");
            System.out.println("   --add-header: Add class header javadocs if absent. Default is skip classes with no header.");
            System.out.println("   --fix: Attempt to fix source tags that have been broken across lines. Default is do not fix.");
            System.out.println("   --replace-tag: Replace existing source tags. Default is do not replace.");
            System.out.println("   --svn: Add the svn URL keyword. Default is do not add keyword.");
            return;
        }
        File inputPath = null;
        InsertSourceTag me = new InsertSourceTag();
        for (String s : args) {
            if ((s = s.trim()).startsWith("--")) {
                if (ADD_HEADER_OPTION.equals(s)) {
                    me.optionAddHeader = true;
                    continue;
                }
                if (ANY_CLASS_OPTION.equals(s)) {
                    me.optionAnyClass = true;
                    continue;
                }
                if (FIX_BROKEN_TAG_OPTION.equals(s)) {
                    me.optionFixBreaks = true;
                    continue;
                }
                if (REPLACE_OPTION.equals(s)) {
                    me.optionReplace = true;
                    continue;
                }
                if (SVN_OPTION.equals(s)) {
                    me.optionSVNDelims = true;
                    continue;
                }
                System.out.println("Unrecognized option: " + s);
                return;
            }
            if (inputPath == null) {
                inputPath = new File(s);
                if (inputPath.exists()) continue;
                System.out.println("Can't find " + inputPath);
                return;
            }
            System.out.println("Two input paths ?");
            System.out.println("   " + inputPath);
            System.out.println("   " + s);
            return;
        }
        me.process(inputPath);
    }

    private void process(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.process(child);
            }
        } else if (file.getName().endsWith(".java")) {
            try {
                System.out.println(file.getPath());
                this.processFile(file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private boolean processFile(File file) throws FileNotFoundException, IOException {
        String line;
        StringBuilder sb;
        Matcher matcher = null;
        matcher = this.findSVNLine.matcher(file.getAbsolutePath());
        if (matcher.matches()) {
            int pos = matcher.start(1);
            String repoURL = "http://svn.osgeo.org/geotools/";
            sb = new StringBuilder(" * @source ");
            if (this.optionSVNDelims) {
                sb.append("$URL: ");
            }
            sb.append("http://svn.osgeo.org/geotools/");
            sb.append(file.getAbsolutePath().substring(pos));
            if (this.optionSVNDelims) {
                sb.append(" $");
            }
        } else {
            System.out.println("   --- skipped this file");
            System.out.println();
            return false;
        }
        String sourceTagText = sb.toString();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> buffer = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            buffer.add(line);
        }
        reader.close();
        boolean inJavadocBlock = false;
        boolean inCommentBlock = false;
        boolean unknownPrecedingContent = false;
        boolean classFound = false;
        int javadocStartLine = -1;
        int javadocEndLine = -1;
        int sourceTagLine = -1;
        for (int lineNo = 0; sourceTagLine < 0 && lineNo < buffer.size(); ++lineNo) {
            String text = (String)buffer.get(lineNo);
            if (inJavadocBlock || inCommentBlock) {
                matcher = this.findCommentEnd.matcher(text);
                if (!matcher.find()) continue;
                if (inJavadocBlock) {
                    inJavadocBlock = false;
                    javadocEndLine = lineNo;
                    continue;
                }
                if (inCommentBlock) {
                    inCommentBlock = false;
                    continue;
                }
                System.out.println("   *** Mis-placed end marker for comment block - skipping this file ***");
                System.out.println();
                return false;
            }
            if (this.findJavadocStart.matcher(text).find()) {
                inJavadocBlock = true;
                unknownPrecedingContent = false;
                javadocStartLine = lineNo;
                continue;
            }
            if (this.findCommentStart.matcher(text).find()) {
                inCommentBlock = true;
                continue;
            }
            if (inJavadocBlock || inCommentBlock || classFound) continue;
            matcher = this.optionAnyClass ? this.findClass.matcher(text) : this.findPublicClass.matcher(text);
            if (matcher.find()) {
                classFound = true;
                if (javadocStartLine < 0) {
                    if (this.optionAddHeader) {
                        buffer.add(lineNo, " */");
                        buffer.add(lineNo, " * ");
                        buffer.add(lineNo, "/**");
                        javadocStartLine = lineNo;
                        javadocEndLine = lineNo + 2;
                        unknownPrecedingContent = false;
                    } else {
                        System.out.println("   *** No class javadocs - skipping file ***");
                        System.out.println();
                        return false;
                    }
                }
                if (unknownPrecedingContent) {
                    System.out.println("   *** Javadocs do not directly precede class - skipping file ***");
                    System.out.println();
                    return false;
                }
                for (int blockLineNo = javadocStartLine; blockLineNo <= javadocEndLine; ++blockLineNo) {
                    String commentText = (String)buffer.get(blockLineNo);
                    matcher = this.findSourceTag.matcher(commentText);
                    if (!matcher.find()) continue;
                    matcher = this.findCompleteSourceTag.matcher(commentText);
                    if (!matcher.find()) {
                        if (this.optionFixBreaks) {
                            matcher = this.findCompletePath.matcher((CharSequence)buffer.get(blockLineNo + 1));
                            if (matcher.find()) {
                                buffer.remove(blockLineNo + 1);
                                buffer.remove(blockLineNo);
                                sourceTagLine = blockLineNo;
                                if (!this.optionReplace) {
                                    String http = matcher.group();
                                    int start = http.indexOf("$URL");
                                    if (start < 0) {
                                        start = http.indexOf("http");
                                    }
                                    http = http.substring(start, http.length());
                                    sourceTagText = commentText + http;
                                }
                                System.out.println("   *** Fixing broken source tag ***");
                                break;
                            }
                        } else {
                            System.out.println("   *** Incomplete source tag detected- skipping this file ***");
                            System.out.println();
                            return false;
                        }
                    }
                    if (this.optionReplace) {
                        sourceTagLine = blockLineNo;
                        buffer.remove(blockLineNo);
                        break;
                    }
                    return false;
                }
                if (sourceTagLine < 0) {
                    for (int i = javadocStartLine; i <= javadocEndLine; ++i) {
                        matcher = this.findVersionTag.matcher((CharSequence)buffer.get(i));
                        if (!matcher.find()) continue;
                        sourceTagLine = i;
                        break;
                    }
                }
                if (sourceTagLine >= 0) continue;
                sourceTagLine = javadocEndLine;
                continue;
            }
            if (text.trim().length() <= 0 || (matcher = this.findAnnotation.matcher(text)).find()) continue;
            unknownPrecedingContent = true;
        }
        if (sourceTagLine > 0) {
            return this.writeFile(file, buffer, sourceTagLine, sourceTagText);
        }
        return false;
    }

    private boolean writeFile(File file, List<String> buffer, int sourceTagLine, String sourceTag) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (int i = 0; i < buffer.size(); ++i) {
            if (i == sourceTagLine) {
                writer.write(" *" + this.lineSeparator);
                writer.write(sourceTag);
                writer.write(this.lineSeparator);
            }
            writer.write(buffer.get(i));
            writer.write(this.lineSeparator);
        }
        writer.close();
        return true;
    }
}

