/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.util.Converters;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.XSD;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class GML3EncodingUtils {
    static GML3EncodingUtils INSTANCE = new GML3EncodingUtils();
    XSD gml;
    GMLEncodingUtils e;

    public GML3EncodingUtils() {
        this(GML.getInstance());
    }

    public GML3EncodingUtils(XSD gml) {
        this.gml = gml;
        this.e = new GMLEncodingUtils(gml);
    }

    static DirectPosition[] positions(LineString line) {
        CoordinateSequence coordinates = line.getCoordinateSequence();
        DirectPosition[] dps = new DirectPosition[coordinates.size()];
        int i = 0;
        while (i < dps.length) {
            double x = coordinates.getOrdinate(i, 0);
            double y = coordinates.getOrdinate(i, 1);
            dps[i] = new DirectPosition2D(x, y);
            ++i;
        }
        return dps;
    }

    static URI toURI(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        try {
            String crsCode = GML2EncodingUtils.crs((CoordinateReferenceSystem)crs);
            if (crsCode != null) {
                return new URI(crsCode);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static URI crs(CoordinateReferenceSystem crs) {
        return GML3EncodingUtils.toURI(crs);
    }

    static CoordinateReferenceSystem getCRS(Geometry g) {
        return GML2EncodingUtils.getCRS((Geometry)g);
    }

    static String getID(Geometry g) {
        return GML2EncodingUtils.getID((Geometry)g);
    }

    static String getName(Geometry g) {
        return GML2EncodingUtils.getName((Geometry)g);
    }

    static String getDescription(Geometry g) {
        return GML2EncodingUtils.getDescription((Geometry)g);
    }

    public Object GeometryPropertyType_GetProperty(Geometry geometry, QName name) {
        return this.e.GeometryPropertyType_getProperty(geometry, name);
    }

    public Object GeometryPropertyType_GetProperty(Geometry geometry, QName name, boolean makeEmpty) {
        return this.e.GeometryPropertyType_getProperty(geometry, name, true, makeEmpty);
    }

    public static Object getProperty(Geometry geometry, QName name) {
        return INSTANCE.GeometryPropertyType_GetProperty(geometry, name);
    }

    public List GeometryPropertyType_GetProperties(Geometry geometry) {
        return this.e.GeometryPropertyType_getProperties(geometry);
    }

    public static List getProperties(Geometry geometry) {
        return INSTANCE.GeometryPropertyType_GetProperties(geometry);
    }

    public Element AbstractFeatureTypeEncode(Object object, Document document, Element value, XSDIdRegistry idSet) {
        Feature feature = (Feature)object;
        String id = feature.getIdentifier() != null ? feature.getIdentifier().getID() : null;
        Name typeName = feature.getDescriptor() == null ? feature.getType().getName() : feature.getDescriptor().getName();
        Element encoding = document.createElementNS(typeName.getNamespaceURI(), typeName.getLocalPart());
        if (id != null) {
            if (!(feature instanceof SimpleFeature) && idSet != null) {
                if (idSet.idExists(id)) {
                    encoding.setAttributeNS("http://www.w3.org/1999/xlink", XLINK.HREF.getLocalPart(), "#" + id.toString());
                    feature.setValue(Collections.emptyList());
                    return encoding;
                }
                idSet.add(id);
            }
            encoding.setAttributeNS(this.gml.getNamespaceURI(), "id", id);
        }
        GML3EncodingUtils.encodeClientProperties((Property)feature, value);
        return encoding;
    }

    public static Element AbstractFeatureType_encode(Object object, Document document, Element value, XSDIdRegistry idSet) {
        return INSTANCE.AbstractFeatureTypeEncode(object, document, value, idSet);
    }

    public List AbstractFeatureTypeGetProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Configuration configuration) {
        return this.e.AbstractFeatureType_getProperties(object, element, schemaIndex, new HashSet<String>(Arrays.asList("name", "description", "boundedBy", "location", "metaDataProperty")), configuration);
    }

    public static List AbstractFeatureType_getProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Configuration configuration) {
        return INSTANCE.AbstractFeatureTypeGetProperties(object, element, schemaIndex, configuration);
    }

    public static void encodeClientProperties(Property complex, Element element) {
        Map clientProperties = (Map)complex.getUserData().get(Attributes.class);
        if (clientProperties != null) {
            for (Name name : clientProperties.keySet()) {
                if (clientProperties.get(name) == null) continue;
                element.setAttributeNS(name.getNamespaceURI(), name.getLocalPart(), clientProperties.get(name).toString());
            }
        }
    }

    public static void encodeSimpleContent(ComplexAttribute complex, Document document, Element element) {
        Object value = GML3EncodingUtils.getSimpleContent(complex);
        if (value != null) {
            Text text = document.createTextNode((String)Converters.convert((Object)value, String.class));
            element.appendChild(text);
        }
    }

    public static Object getSimpleContent(ComplexAttribute complex) {
        Property simpleContent = complex.getProperty((Name)new NameImpl("simpleContent"));
        if (simpleContent == null) {
            return null;
        }
        return simpleContent.getValue();
    }
}

