/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.Name;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class GML3EncodingUtils {
    static DirectPosition[] positions(LineString line) {
        CoordinateSequence coordinates = line.getCoordinateSequence();
        DirectPosition[] dps = new DirectPosition[coordinates.size()];
        for (int i = 0; i < dps.length; ++i) {
            double x = coordinates.getOrdinate(i, 0);
            double y = coordinates.getOrdinate(i, 1);
            dps[i] = new DirectPosition2D(x, y);
        }
        return dps;
    }

    static URI toURI(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        try {
            String crsCode = GML2EncodingUtils.crs((CoordinateReferenceSystem)crs);
            if (crsCode != null) {
                return new URI(crsCode);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static URI crs(CoordinateReferenceSystem crs) {
        return GML3EncodingUtils.toURI(crs);
    }

    static CoordinateReferenceSystem getCRS(Geometry g) {
        return GML2EncodingUtils.getCRS((Geometry)g);
    }

    static String getID(Geometry g) {
        return GML2EncodingUtils.getID((Geometry)g);
    }

    static String getName(Geometry g) {
        return GML2EncodingUtils.getName((Geometry)g);
    }

    static String getDescription(Geometry g) {
        return GML2EncodingUtils.getDescription((Geometry)g);
    }

    public static Object getProperty(Geometry geometry, QName name) {
        return GML2EncodingUtils.GeometryPropertyType_getProperty((Geometry)geometry, (QName)name);
    }

    public static List getProperties(Geometry geometry) {
        return GML2EncodingUtils.GeometryPropertyType_getProperties((Geometry)geometry);
    }

    public static Element AbstractFeatureType_encode(Object object, Document document, Element value, XSDIdRegistry idSet) {
        Feature feature = (Feature)object;
        String id = feature.getIdentifier().getID();
        Name typeName = feature.getDescriptor() == null ? feature.getType().getName() : feature.getDescriptor().getName();
        Element encoding = document.createElementNS(typeName.getNamespaceURI(), typeName.getLocalPart());
        if (idSet != null) {
            if (idSet.idExists(id)) {
                encoding.setAttributeNS("http://www.w3.org/1999/xlink", XLINK.HREF.getLocalPart(), "#" + id.toString());
                feature.setValue(Collections.emptyList());
                return encoding;
            }
            idSet.add(id);
        }
        encoding.setAttributeNS("http://www.opengis.net/gml", "id", id);
        GML3EncodingUtils.encodeClientProperties((Property)feature, value);
        return encoding;
    }

    public static List AbstractFeatureType_getProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Configuration configuration) {
        return GML2EncodingUtils.AbstractFeatureType_getProperties((Object)object, (XSDElementDeclaration)element, (SchemaIndex)schemaIndex, new HashSet<String>(Arrays.asList("name", "description", "boundedBy", "location", "metaDataProperty")), (Configuration)configuration);
    }

    public static void encodeClientProperties(Property complex, Element element) {
        Map clientProperties = (Map)complex.getUserData().get(Attributes.class);
        if (clientProperties != null) {
            for (Name name : clientProperties.keySet()) {
                element.setAttributeNS(name.getNamespaceURI(), name.getLocalPart(), clientProperties.get(name).toString());
            }
        }
    }

    public static void encodeSimpleContent(ComplexAttribute complex, Document document, Element element) {
        Property simpleContent = complex.getProperty((Name)new NameImpl("simpleContent"));
        if (simpleContent != null) {
            Text text = document.createTextNode(simpleContent.getValue().toString());
            element.appendChild(text);
        }
    }
}

