/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class PolygonTypeBinding
extends AbstractComplexBinding {
    GeometryFactory geometryFactory;

    public PolygonTypeBinding(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public QName getTarget() {
        return KML.PolygonType;
    }

    public Class getType() {
        return Polygon.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LinearRing outer = (LinearRing)node.getChildValue("outerBoundaryIs");
        LinearRing[] inner = null;
        if (node.hasChild("innerBoundaryIs")) {
            List l = node.getChildValues("innerBoundaryIs");
            inner = l.toArray(new LinearRing[l.size()]);
        }
        return this.geometryFactory.createPolygon(outer, inner);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        Polygon p = (Polygon)object;
        if ("outerBoundaryIs".equals(name.getLocalPart())) {
            return p.getExteriorRing();
        }
        if ("innerBoundaryIs".equals(name.getLocalPart()) && p.getNumInteriorRing() > 0) {
            LinearRing[] interior = new LinearRing[p.getNumInteriorRing()];
            for (int i = 0; i < interior.length; ++i) {
                interior[i] = (LinearRing)p.getInteriorRingN(i);
            }
            return interior;
        }
        return null;
    }
}

