/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.UnicodeErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.UnicodeError})
public final class UnicodeErrorBuiltins
extends PythonBuiltins {
    public static final int IDX_ENCODING = 0;
    public static final int IDX_OBJECT = 1;
    public static final int IDX_START = 2;
    public static final int IDX_END = 3;
    public static final int IDX_REASON = 4;
    public static final int UNICODE_ERR_NUM_ATTRS = 5;
    public static final BaseExceptionAttrNode.StorageFactory UNICODE_ERROR_ATTR_FACTORY = (args, factory) -> new Object[5];

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnicodeErrorBuiltinsFactory.getFactories();
    }

    public static TruffleString getArgAsString(Node inliningTarget, Object[] args, int index, PRaiseNode.Lazy raiseNode, CastToTruffleStringNode castNode) {
        if (args.length < index + 1 || !PGuards.isString(args[index])) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError);
        }
        return castNode.execute(inliningTarget, args[index]);
    }

    public static int getArgAsInt(Node inliningTarget, Object[] args, int index, PRaiseNode.Lazy raiseNode, CastToJavaIntExactNode castNode) {
        if (args.length < index + 1 || !PGuards.isInteger(args[index]) && !PGuards.isPInt(args[index])) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError);
        }
        return castNode.execute(inliningTarget, args[index]);
    }

    public static Object getArgAsBytes(VirtualFrame frame, Node inliningTarget, Object[] args, int index, PRaiseNode.Lazy raiseNode, GetArgAsBytesNode getArgAsBytesNode) {
        if (args.length < index + 1) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError);
        }
        return getArgAsBytesNode.execute(frame, inliningTarget, args[index]);
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetArgAsBytesNode
    extends PNodeWithContext {
        abstract PBytes execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PBytes doString(TruffleString value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createBytes(value.toJavaStringUncached().getBytes());
        }

        @Specialization
        static PBytes doBytes(PBytes value) {
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isPBytes(value)", "!isString(value)"})
        static PBytes doOther(VirtualFrame frame, Object value, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            try {
                byte[] buffer = bufferLib.getInternalOrCopiedByteArray(value);
                int bufferLength = bufferLib.getBufferLength(value);
                PBytes pBytes = factory.createBytes(buffer, 0, bufferLength);
                return pBytes;
            }
            finally {
                bufferLib.release(value, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="reason", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception reason")
    @GenerateNodeFactory
    public static abstract class UnicodeErrorReasonNode
    extends PythonBuiltinNode {
        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 4, UNICODE_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="end", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception end")
    @GenerateNodeFactory
    public static abstract class UnicodeErrorEndNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object get(PBaseException self, PNone none, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, none, 3, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setBool(PBaseException self, boolean value, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value ? 1 : 0, 3, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setInt(PBaseException self, int value, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 3, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setPInt(PBaseException self, PInt value, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, castToJavaIntExactNode.execute(inliningTarget, value), 3, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization(guards={"!isNoValue(value)", "!canBeInteger(value)"})
        static Object generic(PBaseException self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
        }
    }

    @Builtin(name="start", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception start")
    @GenerateNodeFactory
    public static abstract class UnicodeErrorStartNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object get(PBaseException self, PNone none, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, none, 2, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setBool(PBaseException self, boolean value, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value ? 1 : 0, 2, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setInt(PBaseException self, int value, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 2, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setInt(PBaseException self, long value, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, (int)value, 2, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization
        static Object setPInt(PBaseException self, PInt value, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached.Shared @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, castToJavaIntExactNode.execute(inliningTarget, value), 2, UNICODE_ERROR_ATTR_FACTORY);
        }

        @Specialization(guards={"!isNoValue(value)", "!canBeInteger(value)"})
        static Object generic(PBaseException self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
        }
    }

    @Builtin(name="object", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception object")
    @GenerateNodeFactory
    public static abstract class UnicodeErrorNode
    extends PythonBuiltinNode {
        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 1, UNICODE_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="encoding", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="exception encoding")
    @GenerateNodeFactory
    public static abstract class UnicodeErrorEncodingNode
    extends PythonBuiltinNode {
        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, UNICODE_ERROR_ATTR_FACTORY);
        }
    }
}

