/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot.libgraal;

import com.oracle.truffle.compiler.TruffleCompilationSupport;
import com.oracle.truffle.compiler.TruffleCompiler;
import com.oracle.truffle.compiler.TruffleCompilerOptionDescriptor;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntime;
import com.oracle.truffle.runtime.hotspot.libgraal.BinaryInput;
import com.oracle.truffle.runtime.hotspot.libgraal.DestroyedIsolateException;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalHotSpotTruffleCompiler;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalObject;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalScope;
import com.oracle.truffle.runtime.hotspot.libgraal.TruffleFromLibGraalEntryPoints;
import com.oracle.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;

public final class LibGraalTruffleCompilationSupport
implements TruffleCompilationSupport {
    private volatile String cachedCompilerConfigurationName;

    public LibGraalTruffleCompilationSupport() {
        assert (TruffleFromLibGraalEntryPoints.checkHotSpotCalls());
    }

    public static void initializeIsolate(long isolateThreadId) {
        HotSpotJVMCIRuntime.runtime().registerNativeMethods(TruffleToLibGraalCalls.class);
        TruffleToLibGraalCalls.initializeIsolate(isolateThreadId, LibGraalTruffleCompilationSupport.class);
    }

    public String getCompilerConfigurationName(TruffleCompilerRuntime runtime) {
        String compilerConfiguration = this.cachedCompilerConfigurationName;
        if (compilerConfiguration == null) {
            this.cachedCompilerConfigurationName = compilerConfiguration = LibGraalTruffleCompilationSupport.getCompilerConfigurationNameImpl(runtime);
        }
        return compilerConfiguration;
    }

    private static String getCompilerConfigurationNameImpl(TruffleCompilerRuntime runtime) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            String string = TruffleToLibGraalCalls.getCompilerConfigurationFactoryName(LibGraalScope.getIsolateThread(), LibGraalTruffleCompilationSupport.handle(runtime));
            return string;
        }
    }

    public TruffleCompiler createCompiler(TruffleCompilerRuntime runtime) {
        return new LibGraalHotSpotTruffleCompiler((HotSpotTruffleRuntime)runtime);
    }

    public void registerRuntime(TruffleCompilerRuntime runtime) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            HotSpotJVMCIRuntime.runtime().registerNativeMethods(TruffleToLibGraalCalls.class);
            if (!TruffleToLibGraalCalls.registerRuntime(LibGraalScope.getIsolateThread(), runtime)) {
                throw new IllegalStateException("Truffle with libgraal cannot be loaded in multiple class loaders. Make sure Truffle is loaded with the system class loader.");
            }
        }
    }

    public TruffleCompilerOptionDescriptor[] listCompilerOptions() {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            byte[] binary = TruffleToLibGraalCalls.listCompilerOptions(LibGraalScope.getIsolateThread());
            BinaryInput input = BinaryInput.create(binary);
            int length = input.readInt();
            TruffleCompilerOptionDescriptor[] descriptors = new TruffleCompilerOptionDescriptor[length];
            TruffleCompilerOptionDescriptor.Type[] types = TruffleCompilerOptionDescriptor.Type.values();
            for (int i = 0; i < length; ++i) {
                String name = input.readUTF();
                int typeOrdinal = input.readInt();
                boolean deprecated = input.readBoolean();
                String help = input.readUTF();
                String deprecationMessage = input.readUTF();
                descriptors[i] = new TruffleCompilerOptionDescriptor(name, types[typeOrdinal], deprecated, help, deprecationMessage);
            }
            TruffleCompilerOptionDescriptor[] truffleCompilerOptionDescriptorArray = descriptors;
            return truffleCompilerOptionDescriptorArray;
        }
    }

    public String validateCompilerOption(String key, String value) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            String string = TruffleToLibGraalCalls.validateCompilerOption(LibGraalScope.getIsolateThread(), key, value);
            return string;
        }
    }

    public boolean compilerOptionExists(String key) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            boolean bl = TruffleToLibGraalCalls.compilerOptionExists(LibGraalScope.getIsolateThread(), key);
            return bl;
        }
    }

    public AutoCloseable openCompilerThreadScope() {
        return new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);
    }

    public boolean isSuppressedCompilationFailure(Throwable throwable) {
        return throwable instanceof DestroyedIsolateException && ((DestroyedIsolateException)throwable).isVmExit();
    }

    static long handle(TruffleCompilerRuntime runtime) {
        try (LibGraalScope scope = new LibGraalScope();){
            long l = scope.getIsolate().getSingleton(Handle.class, () -> new Handle(TruffleToLibGraalCalls.initializeRuntime(LibGraalScope.getIsolateThread(), runtime, runtime.getClass()))).getHandle();
            return l;
        }
    }

    public String getCompilerVersion() {
        LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);
        try {
            String string = TruffleToLibGraalCalls.getCompilerVersion(LibGraalScope.getIsolateThread());
            scope.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scope.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsatisfiedLinkError linkError) {
                return null;
            }
        }
    }

    static final class Handle
    extends LibGraalObject {
        Handle(long handle) {
            super(handle);
        }
    }
}

