/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.io.ConfigurationWriter;

public interface AttributeSerializer<T> {
    public static final AttributeSerializer<Object> DEFAULT = (writer, name, value) -> {
        if (Boolean.class == value.getClass()) {
            writer.writeAttribute(name, (boolean)((Boolean)value));
        } else {
            writer.writeAttribute(name, value.toString());
        }
    };
    public static final AttributeSerializer<Supplier<char[]>> SECRET = (writer, name, value) -> {
        if (writer.clearTextSecrets()) {
            writer.writeAttribute(name, new String((char[])value.get()));
        } else {
            writer.writeAttribute(name, "***");
        }
    };
    public static final AttributeSerializer<String[]> STRING_ARRAY = (writer, name, value) -> writer.writeAttribute(name, Arrays.asList(value));
    public static final AttributeSerializer<Collection<String>> STRING_COLLECTION = (writer, name, value) -> writer.writeAttribute(name, (Iterable<String>)value);
    public static final AttributeSerializer<Collection<? extends Enum<?>>> ENUM_COLLECTION = (writer, name, value) -> writer.writeAttribute(name, (Iterable<String>)value.stream().map(Enum::toString).collect(Collectors.toList()));
    public static final AttributeSerializer<Object> INSTANCE_CLASS_NAME = (writer, name, value) -> writer.writeAttribute(name, value.getClass().getName());
    public static final AttributeSerializer<Class> CLASS_NAME = (writer, name, value) -> writer.writeAttribute(name, value.getName());

    public void serialize(ConfigurationWriter var1, String var2, T var3);
}

