/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.ServletMappingMetaData;

public class ServletMappingMetaDataParser
extends MetaDataElementParser {
    public static ServletMappingMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        ServletMappingMetaData servletMapping = new ServletMappingMetaData();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (ServletMappingMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    servletMapping.setId(value);
                    continue block7;
                }
                default: {
                    throw ServletMappingMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVLET_NAME: {
                    servletMapping.setServletName(ServletMappingMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block8;
                }
                case URL_PATTERN: {
                    List<String> urlPatterns = servletMapping.getUrlPatterns();
                    if (urlPatterns == null) {
                        urlPatterns = new ArrayList<String>();
                        servletMapping.setUrlPatterns(urlPatterns);
                    }
                    urlPatterns.add(ServletMappingMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block8;
                }
            }
            throw ServletMappingMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        boolean validServletName = servletMapping.validateServletName();
        boolean validUrlPatterns = servletMapping.validateUrlPatterns();
        if (!validServletName) {
            throw new XMLStreamException("servlet-name element missing in servlet-mapping", reader.getLocation());
        }
        if (!validUrlPatterns) {
            throw new XMLStreamException("url-pattern element missing in servlet-mapping", reader.getLocation());
        }
        return servletMapping;
    }
}

