/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import com.arjuna.ats.jta.cdi.RunnableWithException;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;

public final class TransactionHandler {
    public static void handleExceptionNoThrow(Transactional transactional, Throwable e, Transaction tx) throws IllegalStateException, SystemException {
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(e.getClass())) continue;
            return;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(e.getClass())) continue;
            tx.setRollbackOnly();
            return;
        }
        if (e instanceof RuntimeException) {
            tx.setRollbackOnly();
            return;
        }
    }

    public static void endTransaction(TransactionManager tm, Transaction tx, RunnableWithException afterEndTransaction) throws Exception {
        try {
            if (tx != tm.getTransaction()) {
                throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        finally {
            afterEndTransaction.run();
        }
    }
}

