/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.repository;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;

class MavenRemoteRepositoryImpl
implements MavenRemoteRepository {
    String id;
    String layout;
    URL url;
    MavenUpdatePolicy upPolicy = null;
    MavenChecksumPolicy ckPolicy = null;

    MavenRemoteRepositoryImpl(String id, String url, String layout) throws MalformedURLException {
        this(id, new URL(url), layout);
    }

    MavenRemoteRepositoryImpl(String id, URL url, String layout) {
        if (id == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (layout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        if (!layout.equals("default")) {
            throw new IllegalArgumentException("layout must be default. Parameter reserved for later use");
        }
        this.id = id;
        this.layout = layout;
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.layout;
    }

    public String getUrl() {
        return this.url.toString();
    }

    public MavenUpdatePolicy getUpdatePolicy() {
        return this.upPolicy;
    }

    public MavenChecksumPolicy getChecksumPolicy() {
        return this.ckPolicy;
    }

    public MavenRemoteRepository setUpdatePolicy(MavenUpdatePolicy policy) {
        this.upPolicy = policy;
        return this;
    }

    public MavenRemoteRepository setChecksumPolicy(MavenChecksumPolicy policy) {
        this.ckPolicy = policy;
        return this;
    }
}

