/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.livecoin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.livecoin.dto.marketdata.LivecoinOrderBook;
import org.knowm.xchange.livecoin.dto.marketdata.LivecoinRestriction;
import org.knowm.xchange.livecoin.dto.marketdata.LivecoinTicker;
import org.knowm.xchange.livecoin.dto.marketdata.LivecoinTrade;
import org.knowm.xchange.livecoin.service.LivecoinAsksBidsData;

public class LivecoinAdapters {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    private LivecoinAdapters() {
    }

    public static CurrencyPair adaptCurrencyPair(LivecoinRestriction product) {
        String[] data = product.getCurrencyPair().split("\\/");
        return new CurrencyPair(data[0], data[1]);
    }

    public static OrderBook adaptOrderBook(LivecoinOrderBook book, CurrencyPair currencyPair) {
        List<LimitOrder> asks = LivecoinAdapters.toLimitOrderList(book.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = LivecoinAdapters.toLimitOrderList(book.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    private static List<LimitOrder> toLimitOrderList(LivecoinAsksBidsData[] levels, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> allLevels = new ArrayList<LimitOrder>(levels.length);
        for (int i = 0; i < levels.length; ++i) {
            LivecoinAsksBidsData ask = levels[i];
            allLevels.add(new LimitOrder(orderType, ask.getQuantity(), currencyPair, "0", null, ask.getRate()));
        }
        return allLevels;
    }

    public static ExchangeMetaData adaptToExchangeMetaData(ExchangeMetaData exchangeMetaData, List<LivecoinRestriction> products) {
        HashMap<CurrencyPair, CurrencyPairMetaData> currencyPairs = new HashMap<CurrencyPair, CurrencyPairMetaData>();
        Map currencies = exchangeMetaData.getCurrencies();
        for (LivecoinRestriction product : products) {
            BigDecimal minSize = product.getMinLimitQuantity().setScale((int)product.getPriceScale(), 7);
            CurrencyPair pair = LivecoinAdapters.adaptCurrencyPair(product);
            CurrencyPairMetaData staticMetaData = (CurrencyPairMetaData)exchangeMetaData.getCurrencyPairs().get(pair);
            int priceScale = staticMetaData == null ? 8 : staticMetaData.getPriceScale();
            CurrencyPairMetaData cpmd = new CurrencyPairMetaData(null, minSize, null, Integer.valueOf(priceScale));
            currencyPairs.put(pair, cpmd);
            if (!currencies.containsKey(pair.base)) {
                currencies.put(pair.base, null);
            }
            if (currencies.containsKey(pair.counter)) continue;
            currencies.put(pair.counter, null);
        }
        return new ExchangeMetaData(currencyPairs, currencies, null, null, Boolean.valueOf(true));
    }

    public static Trades adaptTrades(LivecoinTrade[] coinbaseExTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>(coinbaseExTrades.length);
        for (int i = 0; i < coinbaseExTrades.length; ++i) {
            LivecoinTrade trade = coinbaseExTrades[i];
            Order.OrderType type = trade.getType().equals("SELL") ? Order.OrderType.BID : Order.OrderType.ASK;
            Trade t = new Trade(type, trade.getQuantity(), currencyPair, trade.getPrice(), LivecoinAdapters.parseDate(trade.getTime()), String.valueOf(trade.getId()));
            trades.add(t);
        }
        return new Trades(trades, coinbaseExTrades[0].getId().longValue(), Trades.TradeSortType.SortByID);
    }

    private static Date parseDate(Long rawDateLong) {
        return new Date(rawDateLong * 1000L);
    }

    public static Ticker adaptTicker(LivecoinTicker ticker, CurrencyPair currencyPair) {
        BigDecimal last = ticker.getLast();
        BigDecimal bid = ticker.getBestBid();
        BigDecimal ask = ticker.getBestAsk();
        BigDecimal high = ticker.getHigh();
        BigDecimal low = ticker.getLow();
        BigDecimal volume = ticker.getVolume();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).build();
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

