/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class EnvEntry
extends NamingEntry {
    private boolean overrideWebXml;

    public static EnvEntry getEnvEntry(int scopeType, String jndiName) throws NamingException {
        return (EnvEntry)EnvEntry.lookupNamingEntry(scopeType, EnvEntry.class, jndiName);
    }

    public static void bindToENC(String name, String overrideName, Object value) throws NamingException {
        EnvEntry envEntry;
        if (name == null || name.trim().equals("")) {
            throw new NamingException("No name for EnvEntry");
        }
        if (overrideName == null || overrideName.trim().equals("")) {
            overrideName = name;
        }
        if ((envEntry = EnvEntry.getEnvEntry(1, name)) != null && envEntry.isOverrideWebXml()) {
            if (!overrideName.equals(name)) {
                envEntry.bindToENC(overrideName);
            } else {
                envEntry.bindToENC();
            }
            return;
        }
        envEntry = EnvEntry.getEnvEntry(0, name);
        if (envEntry != null && envEntry.isOverrideWebXml()) {
            if (!overrideName.equals(name)) {
                envEntry.bindToENC(overrideName);
            } else {
                envEntry.bindToENC();
            }
            return;
        }
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        NamingUtil.bind((Context)envCtx, (String)name, (Object)value);
        Log.debug((String)("Bound java:comp/env/" + name + "=" + value));
    }

    public EnvEntry(String jndiName, Object objToBind) throws NamingException {
        this(jndiName, objToBind, false);
    }

    public EnvEntry(String jndiName, Object objToBind, boolean overrideWebXml) throws NamingException {
        super(jndiName, objToBind);
        this.overrideWebXml = overrideWebXml;
    }

    public boolean isOverrideWebXml() {
        return this.overrideWebXml;
    }

    public void bindToENC() throws NamingException {
        super.bindToENC();
    }
}

