/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.animator;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Widget;

public final class PreferredBoundsAnimator
extends Animator {
    private HashMap<Widget, Rectangle> sourceBounds = new HashMap();
    private HashMap<Widget, Rectangle> targetBounds = new HashMap();
    private HashMap<Widget, Boolean> nullBounds = new HashMap();

    public PreferredBoundsAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setPreferredBounds(Widget widget, Rectangle preferredBounds) {
        assert (widget != null);
        this.sourceBounds.clear();
        boolean extra = preferredBounds == null;
        this.nullBounds.put(widget, extra);
        Rectangle rect = null;
        if (extra && widget.isPreferredBoundsSet()) {
            rect = widget.getPreferredBounds();
            widget.setPreferredBounds(null);
        }
        this.targetBounds.put(widget, extra ? widget.getPreferredBounds() : preferredBounds);
        if (rect != null) {
            widget.setPreferredBounds(rect);
        }
        this.start();
    }

    @Override
    protected void tick(double progress) {
        for (Map.Entry<Widget, Rectangle> entry : this.targetBounds.entrySet()) {
            Widget widget = entry.getKey();
            Rectangle sourceBoundary = this.sourceBounds.get(widget);
            if (sourceBoundary == null) {
                sourceBoundary = widget.getBounds();
                if (sourceBoundary == null) {
                    sourceBoundary = new Rectangle();
                }
                this.sourceBounds.put(widget, sourceBoundary);
            }
            Rectangle targetBoundary = entry.getValue();
            Rectangle boundary = progress >= 1.0 ? (this.nullBounds.get(widget) != false ? null : targetBoundary) : new Rectangle((int)((double)sourceBoundary.x + progress * (double)(targetBoundary.x - sourceBoundary.x)), (int)((double)sourceBoundary.y + progress * (double)(targetBoundary.y - sourceBoundary.y)), (int)((double)sourceBoundary.width + progress * (double)(targetBoundary.width - sourceBoundary.width)), (int)((double)sourceBoundary.height + progress * (double)(targetBoundary.height - sourceBoundary.height)));
            widget.setPreferredBounds(boundary);
        }
        if (progress >= 1.0) {
            this.sourceBounds.clear();
            this.targetBounds.clear();
            this.nullBounds.clear();
        }
    }
}

