/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.Enumerations;

public final class Exceptions {
    private static final String LOC_MSG_PLACEHOLDER = "msg";

    private Exceptions() {
    }

    public static <E extends Throwable> E attachMessage(E e, String msg) {
        AnnException ae = AnnException.findOrCreate(e, true);
        LogRecord rec = new LogRecord(Level.ALL, msg);
        ae.addRecord(rec);
        return e;
    }

    public static <E extends Throwable> E attachLocalizedMessage(E e, final String localizedMessage) {
        AnnException ae = AnnException.findOrCreate(e, true);
        LogRecord rec = new LogRecord(Level.ALL, LOC_MSG_PLACEHOLDER);
        ResourceBundle rb = new ResourceBundle(){

            @Override
            public Object handleGetObject(String key) {
                if (Exceptions.LOC_MSG_PLACEHOLDER.equals(key)) {
                    return localizedMessage;
                }
                return null;
            }

            @Override
            public Enumeration<String> getKeys() {
                return Enumerations.singleton(Exceptions.LOC_MSG_PLACEHOLDER);
            }
        };
        rec.setResourceBundle(rb);
        ae.addRecord(rec);
        return e;
    }

    public static String findLocalizedMessage(Throwable t) {
        while (t != null) {
            AnnException extra = (AnnException)AnnException.extras.get(t);
            String msg = extra != null ? Exceptions.extractLocalizedMessage(extra) : Exceptions.extractLocalizedMessage(t);
            if (msg != null) {
                return msg;
            }
            t = t.getCause();
        }
        return null;
    }

    private static String extractLocalizedMessage(Throwable t) {
        String msg = null;
        if (t instanceof Callable) {
            Object res = null;
            try {
                res = ((Callable)((Object)t)).call();
            }
            catch (Exception ex) {
                Logger.global.log(Level.WARNING, null, t);
            }
            if (res instanceof LogRecord[]) {
                for (LogRecord r : (LogRecord[])res) {
                    ResourceBundle b = r.getResourceBundle();
                    if (b == null) continue;
                    msg = b.getString(r.getMessage());
                    break;
                }
            }
        }
        return msg;
    }

    public static void printStackTrace(Throwable t) {
        AnnException extra = (AnnException)AnnException.extras.get(t);
        if (extra != null) {
            assert (t == extra.getCause());
            t = extra;
        }
        Logger.global.log(OwnLevel.UNKNOWN, null, t);
    }

    private static final class OwnLevel
    extends Level {
        public static final Level UNKNOWN = new OwnLevel("SEVERE", Level.SEVERE.intValue() + 1);

        private OwnLevel(String s, int i) {
            super(s, i);
        }
    }

    private static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;
        private static Map<Throwable, AnnException> extras = new WeakHashMap<Throwable, AnnException>();

        private AnnException() {
        }

        private AnnException(String msg) {
            super(msg);
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (LogRecord r : this.records) {
                String m = r.getMessage();
                if (m == null || m.equals(Exceptions.LOC_MSG_PLACEHOLDER)) continue;
                sb.append(sep);
                sb.append(m);
                sep = "\n";
            }
            return sb.toString();
        }

        static AnnException findOrCreate(Throwable t, boolean create) {
            if (t instanceof AnnException) {
                return (AnnException)t;
            }
            if (t.getCause() == null) {
                if (create) {
                    try {
                        t.initCause(new AnnException());
                    }
                    catch (IllegalStateException x) {
                        AnnException ann = extras.get(t);
                        if (ann == null) {
                            ann = new AnnException(t.getMessage());
                            ann.initCause(t);
                            Logger.getLogger(Exceptions.class.getName()).log(Level.FINE, "getCause was null yet initCause failed for " + t, x);
                            extras.put(t, ann);
                        }
                        return ann;
                    }
                }
                return (AnnException)t.getCause();
            }
            return AnnException.findOrCreate(t.getCause(), create);
        }

        public synchronized void addRecord(LogRecord rec) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(rec);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> r = this.records;
            LogRecord[] empty = new LogRecord[]{};
            return r == null ? empty : r.toArray(empty);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            super.printStackTrace(s);
            this.logRecords(s);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            super.printStackTrace(s);
            this.logRecords(s);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }

        private void logRecords(Appendable a) {
            List<LogRecord> r = this.records;
            if (r == null) {
                return;
            }
            try {
                for (LogRecord log : r) {
                    if (log.getMessage() != null) {
                        a.append(log.getMessage()).append("\n");
                    }
                    if (log.getThrown() == null) continue;
                    StringWriter w = new StringWriter();
                    log.getThrown().printStackTrace(new PrintWriter(w));
                    a.append(w.toString()).append("\n");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

