/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class Lookup {
    public static final Lookup EMPTY = new Empty();
    private static Lookup defaultLookup;

    public static synchronized Lookup getDefault() {
        if (defaultLookup != null) {
            return defaultLookup;
        }
        String className = System.getProperty("org.openide.util.Lookup");
        if ("-".equals(className)) {
            return EMPTY;
        }
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        try {
            if (className != null) {
                defaultLookup = (Lookup)Class.forName(className, true, l).newInstance();
                return defaultLookup;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Lookup misl = Lookups.metaInfServices(l);
        defaultLookup = misl.lookup(Lookup.class);
        if (defaultLookup != null) {
            return defaultLookup;
        }
        Provider prov = misl.lookup(Provider.class);
        if (prov != null) {
            defaultLookup = Lookups.proxy(prov);
            return defaultLookup;
        }
        DefLookup def = new DefLookup();
        def.init(l, misl);
        defaultLookup = def;
        return defaultLookup;
    }

    private static void resetDefaultLookup() {
        if (defaultLookup instanceof DefLookup) {
            DefLookup def = (DefLookup)defaultLookup;
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            def.init(l, Lookups.metaInfServices(l));
        }
    }

    public abstract <T> T lookup(Class<T> var1);

    public abstract <T> Result<T> lookup(Template<T> var1);

    public <T> Item<T> lookupItem(Template<T> template) {
        Result<T> res = this.lookup(template);
        Iterator<Item<T>> it = res.allItems().iterator();
        return it.hasNext() ? it.next() : null;
    }

    public <T> Result<T> lookupResult(Class<T> clazz) {
        return this.lookup(new Template<T>(clazz));
    }

    public <T> Collection<? extends T> lookupAll(Class<T> clazz) {
        return this.lookupResult(clazz).allInstances();
    }

    private static final class Empty
    extends Lookup {
        private static final Result NO_RESULT = new Result(){

            @Override
            public void addLookupListener(LookupListener l) {
            }

            @Override
            public void removeLookupListener(LookupListener l) {
            }

            public Collection allInstances() {
                return Collections.EMPTY_SET;
            }
        };

        Empty() {
        }

        @Override
        public <T> T lookup(Class<T> clazz) {
            return null;
        }

        @Override
        public <T> Result<T> lookup(Template<T> template) {
            return NO_RESULT;
        }
    }

    public static abstract class Item<T> {
        public abstract T getInstance();

        public abstract Class<? extends T> getType();

        public abstract String getId();

        public abstract String getDisplayName();

        public String toString() {
            return this.getId();
        }
    }

    public static abstract class Result<T> {
        public abstract void addLookupListener(LookupListener var1);

        public abstract void removeLookupListener(LookupListener var1);

        public abstract Collection<? extends T> allInstances();

        public Set<Class<? extends T>> allClasses() {
            return Collections.emptySet();
        }

        public Collection<? extends Item<T>> allItems() {
            return Collections.emptyList();
        }
    }

    public static final class Template<T> {
        private int hashCode;
        private Class<T> type;
        private String id;
        private T instance;

        @Deprecated
        public Template() {
            this(null);
        }

        public Template(Class<T> type) {
            this(type, null, null);
        }

        public Template(Class<T> type, String id, T instance) {
            this.type = this.extractType(type);
            this.id = id;
            this.instance = instance;
        }

        private Class<T> extractType(Class<T> type) {
            return type == null ? Object.class : type;
        }

        public Class<T> getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public T getInstance() {
            return this.instance;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = (this.type == null ? 1 : this.type.hashCode()) + (this.id == null ? 2 : this.id.hashCode()) + (this.instance == null ? 3 : 0);
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Template)) {
                return false;
            }
            Template t = (Template)obj;
            if (this.hashCode() != t.hashCode()) {
                return false;
            }
            if (this.type != t.type) {
                return false;
            }
            if (this.id == null ? t.id != null : !this.id.equals(t.id)) {
                return false;
            }
            if (this.instance == null) {
                return t.instance == null;
            }
            return this.instance.equals(t.instance);
        }

        public String toString() {
            return "Lookup.Template[type=" + this.type + ",id=" + this.id + ",instance=" + this.instance + "]";
        }
    }

    public static interface Provider {
        public Lookup getLookup();
    }

    private static final class DefLookup
    extends ProxyLookup {
        public DefLookup() {
            super(new Lookup[0]);
        }

        public void init(ClassLoader loader, Lookup metaInfLookup) {
            Lookup clLookup = Lookups.singleton(loader);
            this.setLookups(metaInfLookup, clLookup);
        }
    }
}

