/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.MutexException;
import org.openide.util.Utilities;

public final class Mutex {
    private static int counter;
    private static Logger LOG;
    public static final Mutex EVENT;
    static boolean beStrict;
    private static final int NONE = 0;
    private static final int CHAIN = 1;
    private static final int X = 2;
    private static final int S = 3;
    private static final int MODE_COUNT = 4;
    private static final boolean[][] cmatrix;
    private int grantedMode = 0;
    private int origMode;
    private Object LOCK;
    private final Executor wrapper;
    private Map<Thread, ThreadInfo> registeredThreads;
    private int readersNo = 0;
    private List<QueueCell> waiters;
    private int cnt;

    public Mutex(Object lock) {
        this.init(lock);
        this.wrapper = null;
    }

    public Mutex() {
        this.init(new InternalLock());
        this.wrapper = null;
    }

    public Mutex(Privileged privileged) {
        if (privileged == null) {
            throw new IllegalArgumentException("privileged == null");
        }
        this.init(new InternalLock());
        privileged.setParent(this);
        this.wrapper = null;
    }

    public Mutex(Privileged privileged, Executor executor) {
        this.LOCK = new Mutex(privileged);
        this.wrapper = executor;
    }

    private void init(Object lock) {
        this.LOCK = lock;
        this.registeredThreads = new HashMap<Thread, ThreadInfo>(7);
        this.waiters = new LinkedList<QueueCell>();
        this.cnt = counter++;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "[" + this.cnt + "] created here", new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readAccess(Action<T> action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException e) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(e.getException());
            }
        }
        if (this.wrapper != null) {
            try {
                return this.doWrapperAccess(action, null, true);
            }
            catch (MutexException e) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(e.getException());
            }
        }
        Thread t = Thread.currentThread();
        this.readEnter(t);
        try {
            T t2 = action.run();
            return t2;
        }
        finally {
            this.leave(t);
        }
    }

    public <T> T readAccess(ExceptionAction<T> action) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(action);
        }
        if (this.wrapper != null) {
            return this.doWrapperAccess(action, null, true);
        }
        Thread t = Thread.currentThread();
        this.readEnter(t);
        try {
            T t2 = action.run();
            return t2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MutexException(e);
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAccess(Runnable action) {
        if (this == EVENT) {
            Mutex.doEvent(action);
            return;
        }
        if (this.wrapper != null) {
            try {
                this.doWrapperAccess(null, action, true);
                return;
            }
            catch (MutexException ex) {
                throw (IllegalStateException)new IllegalStateException().initCause(ex);
            }
        }
        Thread t = Thread.currentThread();
        this.readEnter(t);
        try {
            action.run();
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T writeAccess(Action<T> action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException e) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(e.getException());
            }
        }
        if (this.wrapper != null) {
            try {
                return this.doWrapperAccess(action, null, false);
            }
            catch (MutexException e) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(e.getException());
            }
        }
        Thread t = Thread.currentThread();
        this.writeEnter(t);
        try {
            T t2 = action.run();
            return t2;
        }
        finally {
            this.leave(t);
        }
    }

    public <T> T writeAccess(ExceptionAction<T> action) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(action);
        }
        if (this.wrapper != null) {
            return this.doWrapperAccess(action, null, false);
        }
        Thread t = Thread.currentThread();
        this.writeEnter(t);
        try {
            T t2 = action.run();
            return t2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MutexException(e);
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAccess(Runnable action) {
        if (this == EVENT) {
            Mutex.doEvent(action);
            return;
        }
        if (this.wrapper != null) {
            try {
                this.doWrapperAccess(null, action, false);
            }
            catch (MutexException ex) {
                throw (IllegalStateException)new IllegalStateException().initCause(ex);
            }
            return;
        }
        Thread t = Thread.currentThread();
        this.writeEnter(t);
        try {
            action.run();
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadAccess() {
        if (this == EVENT) {
            return SwingUtilities.isEventDispatchThread();
        }
        if (this.wrapper != null) {
            Mutex m = (Mutex)this.LOCK;
            return m.isReadAccess();
        }
        Thread t = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo info = this.getThreadInfo(t);
            if (info != null && info.counts[3] > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteAccess() {
        if (this == EVENT) {
            return SwingUtilities.isEventDispatchThread();
        }
        if (this.wrapper != null) {
            Mutex m = (Mutex)this.LOCK;
            return m.isWriteAccess();
        }
        Thread t = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo info = this.getThreadInfo(t);
            if (info != null && info.counts[2] > 0) {
                return true;
            }
        }
        return false;
    }

    public void postReadRequest(Runnable run) {
        this.postRequest(3, run, null);
    }

    public void postWriteRequest(Runnable run) {
        this.postRequest(2, run, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this == EVENT) {
            return "Mutex.EVENT";
        }
        String newline = System.getProperty("line.separator");
        StringBuffer sbuff = new StringBuffer(512);
        Object object = this.LOCK;
        synchronized (object) {
            sbuff.append("threads: ").append(this.registeredThreads).append(newline);
            sbuff.append("readersNo: ").append(this.readersNo).append(newline);
            sbuff.append("waiters: ").append(this.waiters).append(newline);
            sbuff.append("grantedMode: ").append(this.grantedMode).append(newline);
        }
        return sbuff.toString();
    }

    final void writeEnter(Thread t) {
        this.enter(2, t, true);
    }

    final void readEnter(Thread t) {
        this.enter(3, t, true);
    }

    private void doLog(String action, Object ... params) {
        String tid = Integer.toHexString(Thread.currentThread().hashCode());
        LOG.log(Level.FINE, "[#" + this.cnt + "@" + tid + "] " + action, params);
    }

    private boolean enter(int requested, Thread t, boolean block) {
        boolean log = LOG.isLoggable(Level.FINE);
        if (log) {
            this.doLog("Entering {0}, {1}", requested, block);
        }
        boolean ret = this.enterImpl(requested, t, block);
        if (log) {
            this.doLog("Entering exit: {0}", ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterImpl(int requested, Thread t, boolean block) {
        QueueCell cell = null;
        int loopc = 0;
        while (true) {
            ++loopc;
            Object object = this.LOCK;
            synchronized (object) {
                ThreadInfo info = this.getThreadInfo(t);
                if (info != null) {
                    IllegalStateException e;
                    if (this.grantedMode == 0) {
                        throw new IllegalStateException();
                    }
                    if (info.mode == 3 && this.grantedMode == 2 || info.mode == 2 && this.grantedMode == 3) {
                        throw new IllegalStateException();
                    }
                    if (info.mode == 2 || info.mode == requested) {
                        if (info.forced) {
                            info.forced = false;
                        } else {
                            if (requested == 2 && info.counts[3] > 0) {
                                e = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                                if (beStrict) {
                                    throw e;
                                }
                                Exceptions.printStackTrace(e);
                            }
                            int n = requested;
                            info.counts[n] = info.counts[n] + 1;
                            if (requested == 3 && info.counts[requested] == 1) {
                                ++this.readersNo;
                            }
                        }
                        return true;
                    }
                    if (this.canUpgrade(info.mode, requested)) {
                        e = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                        if (beStrict) {
                            throw e;
                        }
                        Exceptions.printStackTrace(e);
                        info.mode = 2;
                        int n = requested;
                        info.counts[n] = info.counts[n] + 1;
                        info.rsnapshot = info.counts[3];
                        if (this.grantedMode == 3) {
                            this.setGrantedMode(2);
                        } else if (this.grantedMode == 2) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    e = new IllegalStateException("WARNING: Going from readAccess to writeAccess through queue, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                    if (beStrict) {
                        throw e;
                    }
                    Exceptions.printStackTrace(e);
                } else if (this.isCompatible(requested)) {
                    this.setGrantedMode(requested);
                    info = new ThreadInfo(t, requested);
                    this.registeredThreads.put(t, info);
                    if (requested == 3) {
                        ++this.readersNo;
                    }
                    return true;
                }
                if (!block) {
                    return false;
                }
                this.setGrantedMode(1);
                cell = this.chain(requested, t, 0);
            }
            cell.sleep();
        }
    }

    private boolean reenter(Thread t, int mode) {
        boolean log = LOG.isLoggable(Level.FINE);
        if (log) {
            this.doLog("Re-Entering {0}", mode);
        }
        boolean ret = this.reenterImpl(t, mode);
        if (log) {
            this.doLog("Re-Entering exit: {0}", ret);
        }
        return ret;
    }

    private boolean reenterImpl(Thread t, int mode) {
        boolean chainFromLeaveX;
        if (mode == 3) {
            if (this.grantedMode != 0 && this.grantedMode != 3) {
                throw new IllegalStateException(this.toString());
            }
            this.enter(mode, t, true);
            return false;
        }
        ThreadInfo tinfo = this.getThreadInfo(t);
        boolean bl = chainFromLeaveX = this.grantedMode == 1 && tinfo != null && tinfo.counts[2] > 0;
        if (this.grantedMode == 2 || this.grantedMode == 0 || chainFromLeaveX) {
            this.enter(mode, t, true);
            return false;
        }
        if (this.readersNo == 0) {
            throw new IllegalStateException(this.toString());
        }
        ThreadInfo info = new ThreadInfo(t, mode);
        this.registeredThreads.put(t, info);
        this.readersNo += 2;
        this.setGrantedMode(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privilegedEnter(Thread t, int mode) {
        boolean decrease = true;
        Object object = this.LOCK;
        synchronized (object) {
            this.getThreadInfo(t);
        }
        while (true) {
            QueueCell cell;
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (decrease) {
                    decrease = false;
                    this.readersNo -= 2;
                }
                this.setGrantedMode(1);
                cell = this.chain(mode, t, Integer.MAX_VALUE);
                if (this.readersNo == 0) {
                    if (this.waiters.get(0) == cell) {
                        this.waiters.remove(0);
                        this.setGrantedMode(mode);
                        return;
                    }
                    this.setGrantedMode(0);
                    this.wakeUpOthers();
                }
            }
            cell.sleep();
        }
    }

    final void leave(Thread t) {
        boolean log = LOG.isLoggable(Level.FINE);
        if (log) {
            this.doLog("Leaving {0}", this.grantedMode);
        }
        this.leaveImpl(t);
        if (log) {
            this.doLog("Leaving exit: {0}", this.grantedMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveImpl(Thread t) {
        ThreadInfo info;
        int postedMode = 0;
        boolean needLock = false;
        Object object = this.LOCK;
        synchronized (object) {
            int runsize;
            info = this.getThreadInfo(t);
            switch (this.grantedMode) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    if (info.counts[2] > 0) {
                        postedMode = this.leaveX(info);
                        break;
                    }
                    if (info.counts[3] > 0) {
                        postedMode = this.leaveS(info);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    postedMode = this.leaveX(info);
                    break;
                }
                case 3: {
                    postedMode = this.leaveS(info);
                }
            }
            if (postedMode != 0 && (runsize = info.getRunnableCount(postedMode)) != 0) {
                needLock = this.reenter(t, postedMode);
            }
        }
        if (postedMode != 0 && info.getRunnableCount(postedMode) > 0) {
            this.doLog("Processing posted requests: {0}", postedMode);
            try {
                if (needLock) {
                    this.privilegedEnter(t, postedMode);
                }
                List runnables = info.dequeue(postedMode);
                int size = runnables.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        Runnable r = (Runnable)runnables.get(i);
                        r.run();
                        continue;
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace(e);
                        continue;
                    }
                    catch (StackOverflowError e) {
                        e.printStackTrace();
                        Exceptions.printStackTrace(e);
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Error e) {
                        Exceptions.printStackTrace(e);
                    }
                }
                runnables = null;
            }
            finally {
                this.leave(t);
            }
        }
    }

    private int leaveX(ThreadInfo info) {
        if (info.counts[2] <= 0 || info.rsnapshot > info.counts[3]) {
            throw new IllegalStateException();
        }
        if (info.rsnapshot == info.counts[3]) {
            info.counts[2] = info.counts[2] - 1;
            if (info.counts[2] == 0) {
                info.rsnapshot = 0;
                if (info.counts[3] > 0) {
                    info.mode = 3;
                    this.setGrantedMode(3);
                } else {
                    info.mode = 0;
                    this.setGrantedMode(0);
                    this.registeredThreads.remove(info.t);
                }
                if (info.getRunnableCount(3) > 0) {
                    this.wakeUpReaders();
                    return 3;
                }
                this.wakeUpOthers();
            }
        } else {
            if (info.counts[3] <= 0) {
                throw new IllegalStateException();
            }
            info.counts[3] = info.counts[3] - 1;
            if (info.counts[3] == 0) {
                if (this.readersNo <= 0) {
                    throw new IllegalStateException();
                }
                --this.readersNo;
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int leaveS(ThreadInfo info) {
        if (info.counts[3] <= 0 || info.counts[2] > 0) {
            throw new IllegalStateException();
        }
        info.counts[3] = info.counts[3] - 1;
        if (info.counts[3] == 0) {
            info.mode = 0;
            this.registeredThreads.remove(info.t);
            if (this.readersNo <= 0) {
                throw new IllegalStateException();
            }
            --this.readersNo;
            if (this.readersNo == 0) {
                this.setGrantedMode(0);
                if (info.getRunnableCount(2) > 0) {
                    return 2;
                }
                this.wakeUpOthers();
            } else {
                if (info.getRunnableCount(2) > 0) {
                    return 2;
                }
                if (this.grantedMode == 1 && this.readersNo == 1) {
                    for (int i = 0; i < this.waiters.size(); ++i) {
                        QueueCell qc;
                        QueueCell queueCell = qc = this.waiters.get(i);
                        synchronized (queueCell) {
                            if (qc.isGotOut()) {
                                this.waiters.remove(i--);
                                continue;
                            }
                            ThreadInfo tinfo = this.getThreadInfo(qc.t);
                            if (tinfo != null && tinfo.mode == 3) {
                                if (qc.mode != 2) {
                                    throw new IllegalStateException();
                                }
                                if (this.waiters.size() == 1) {
                                    this.setGrantedMode(2);
                                }
                                tinfo.mode = 2;
                                this.waiters.remove(i);
                                qc.wakeMeUp();
                            }
                            break;
                        }
                    }
                }
            }
        }
        return 0;
    }

    private QueueCell chain(int requested, Thread t, int priority) {
        QueueCell qc = new QueueCell(requested, t);
        qc.priority2 = priority;
        int size = this.waiters.size();
        if (size == 0) {
            this.waiters.add(qc);
        } else if (qc.getPriority() == Integer.MAX_VALUE) {
            this.waiters.add(0, qc);
        } else {
            int i = 0;
            do {
                QueueCell cursor;
                if ((cursor = this.waiters.get(i)).getPriority() >= qc.getPriority()) continue;
                this.waiters.add(i, qc);
                break;
            } while (++i < size);
            if (i == size) {
                this.waiters.add(qc);
            }
        }
        return qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpOthers() {
        if (this.grantedMode == 2 || this.grantedMode == 1) {
            throw new IllegalStateException();
        }
        if (this.waiters.size() == 0) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell qc;
            QueueCell queueCell = qc = this.waiters.get(i);
            synchronized (queueCell) {
                if (qc.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (this.isCompatible(qc.mode)) {
                    this.waiters.remove(i--);
                    qc.wakeMeUp();
                    this.setGrantedMode(qc.mode);
                    if (this.getThreadInfo(qc.t) == null) {
                        ThreadInfo ti = new ThreadInfo(qc.t, qc.mode);
                        ti.forced = true;
                        if (qc.mode == 3) {
                            ++this.readersNo;
                        }
                        this.registeredThreads.put(qc.t, ti);
                    }
                } else {
                    this.setGrantedMode(1);
                    break;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpReaders() {
        assert (this.grantedMode == 0 || this.grantedMode == 3);
        if (this.waiters.size() == 0) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell qc;
            QueueCell queueCell = qc = this.waiters.get(i);
            synchronized (queueCell) {
                if (qc.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (qc.mode == 3) {
                    this.waiters.remove(i--);
                    qc.wakeMeUp();
                    this.setGrantedMode(3);
                    if (this.getThreadInfo(qc.t) == null) {
                        ThreadInfo ti = new ThreadInfo(qc.t, qc.mode);
                        ti.forced = true;
                        ++this.readersNo;
                        this.registeredThreads.put(qc.t, ti);
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRequest(final int mutexMode, final Runnable run, Executor exec) {
        ThreadInfo info;
        if (this == EVENT) {
            Mutex.doEventRequest(run);
            return;
        }
        if (this.wrapper != null) {
            Mutex m = (Mutex)this.LOCK;
            m.postRequest(mutexMode, run, this.wrapper);
            return;
        }
        final Thread t = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            info = this.getThreadInfo(t);
            if (info != null) {
                if (mutexMode == info.mode && info.counts[5 - mutexMode] == 0) {
                    this.enter(mutexMode, t, true);
                } else {
                    info.enqueue(mutexMode, run);
                    return;
                }
            }
        }
        if (info == null) {
            if (exec != null) {
                class Exec
                implements Runnable {
                    Exec() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Mutex.this.enter(mutexMode, t, true);
                        try {
                            run.run();
                        }
                        finally {
                            Mutex.this.leave(t);
                        }
                    }
                }
                exec.execute(new Exec());
                return;
            }
            this.enter(mutexMode, t, true);
            try {
                run.run();
            }
            finally {
                this.leave(t);
            }
            return;
        }
        try {
            run.run();
        }
        finally {
            this.leave(t);
        }
    }

    private boolean isCompatible(int requested) {
        if (requested == 3 && this.grantedMode == 1 && this.origMode == 3) {
            return true;
        }
        return cmatrix[requested][this.grantedMode];
    }

    private ThreadInfo getThreadInfo(Thread t) {
        return this.registeredThreads.get(t);
    }

    private boolean canUpgrade(int threadGranted, int requested) {
        return threadGranted == 3 && requested == 2 && this.readersNo == 1;
    }

    private <T> T doWrapperAccess(final ExceptionAction<T> action, final Runnable runnable, final boolean readOnly) throws MutexException {
        class R
        implements Runnable {
            T ret;
            MutexException e;

            R() {
            }

            @Override
            public void run() {
                Mutex m = (Mutex)Mutex.this.LOCK;
                try {
                    if (readOnly) {
                        if (action != null) {
                            this.ret = m.readAccess(action);
                        } else {
                            m.readAccess(runnable);
                        }
                    } else if (action != null) {
                        this.ret = m.writeAccess(action);
                    } else {
                        m.writeAccess(runnable);
                    }
                }
                catch (MutexException ex) {
                    this.e = ex;
                }
            }
        }
        R run = new R();
        Mutex m = (Mutex)this.LOCK;
        if (m.isWriteAccess() || m.isReadAccess()) {
            run.run();
        } else {
            this.wrapper.execute(run);
        }
        if (run.e != null) {
            throw run.e;
        }
        return run.ret;
    }

    private static void doEvent(Runnable run) {
        if (EventQueue.isDispatchThread()) {
            run.run();
        } else {
            EventQueue.invokeLater(run);
        }
    }

    private static void doEventRequest(Runnable run) {
        EventQueue.invokeLater(run);
    }

    private static <T> T doEventAccess(final ExceptionAction<T> run) throws MutexException {
        if (Mutex.isDispatchThread()) {
            try {
                return run.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MutexException(e);
            }
        }
        final Throwable[] arr = new Throwable[1];
        try {
            final ArrayList res = new ArrayList(1);
            class AWTWorker
            implements Runnable {
                AWTWorker() {
                }

                @Override
                public void run() {
                    try {
                        res.add(run.run());
                    }
                    catch (Exception e) {
                        arr[0] = e;
                    }
                    catch (LinkageError e) {
                        arr[0] = e;
                    }
                    catch (StackOverflowError e) {
                        arr[0] = e;
                    }
                }
            }
            AWTWorker w = new AWTWorker();
            EventQueue.invokeAndWait(w);
            if (arr[0] == null) {
                return (T)res.get(0);
            }
        }
        catch (InterruptedException e) {
            arr[0] = e;
        }
        catch (InvocationTargetException e) {
            arr[0] = e;
        }
        if (arr[0] instanceof RuntimeException) {
            throw (RuntimeException)arr[0];
        }
        throw Mutex.notifyException(arr[0]);
    }

    static boolean isDispatchThread() {
        boolean dispatch = EventQueue.isDispatchThread();
        if (!dispatch && Utilities.getOperatingSystem() == 8) {
            dispatch = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
        }
        return dispatch;
    }

    private static final MutexException notifyException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = Mutex.unfoldInvocationTargetException((InvocationTargetException)t);
        }
        if (t instanceof Error) {
            Mutex.annotateEventStack(t);
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            Mutex.annotateEventStack(t);
            throw (RuntimeException)t;
        }
        MutexException exc = new MutexException((Exception)t);
        exc.initCause(t);
        return exc;
    }

    private static final void annotateEventStack(Throwable t) {
    }

    private static final Throwable unfoldInvocationTargetException(InvocationTargetException e) {
        Throwable ret;
        while ((e = (ret = e.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)ret : null) != null) {
        }
        return ret;
    }

    private void setGrantedMode(int mode) {
        if (this.grantedMode != 1 && mode == 1) {
            this.origMode = this.grantedMode;
        }
        this.grantedMode = mode;
    }

    static {
        LOG = Logger.getLogger(Mutex.class.getName());
        EVENT = new Mutex();
        cmatrix = new boolean[][]{null, null, {true, false, false, false}, {true, false, false, true}};
    }

    public static final class Privileged {
        private Mutex parent;

        final void setParent(Mutex parent) {
            this.parent = parent;
        }

        public void enterReadAccess() {
            this.parent.readEnter(Thread.currentThread());
        }

        public void enterWriteAccess() {
            this.parent.writeEnter(Thread.currentThread());
        }

        public void exitReadAccess() {
            this.parent.leave(Thread.currentThread());
        }

        public void exitWriteAccess() {
            this.parent.leave(Thread.currentThread());
        }
    }

    private static final class QueueCell {
        int mode;
        Thread t;
        boolean signal;
        boolean left;
        int priority2;

        public QueueCell(int mode, Thread t) {
            this.mode = mode;
            this.t = t;
            this.left = false;
            this.priority2 = 0;
        }

        public String toString() {
            return super.toString() + " mode: " + this.mode + " thread: " + this.t;
        }

        public long getPriority() {
            return this.priority2 == 0 ? this.t.getPriority() : this.priority2;
        }

        public boolean isGotOut() {
            return this.left;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void sleep() {
            block8: {
                boolean wasInterrupted = false;
                while (true) {
                    if (this.signal) break block8;
                    try {
                        this.wait();
                        return;
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                        Logger.getLogger(Mutex.class.getName()).log(Level.FINE, null, e);
                    }
                }
                finally {
                    this.left = true;
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void wakeMeUp() {
            this.signal = true;
            this.notifyAll();
        }
    }

    private static final class InternalLock {
        InternalLock() {
        }
    }

    private static final class ThreadInfo {
        boolean forced;
        final Thread t;
        int mode;
        int[] counts;
        List<Runnable>[] queues;
        int rsnapshot;

        public ThreadInfo(Thread t, int mode) {
            this.t = t;
            this.mode = mode;
            this.counts = new int[4];
            this.queues = new List[4];
            this.counts[mode] = 1;
        }

        public String toString() {
            return super.toString() + " thread: " + this.t + " mode: " + this.mode + " X: " + this.counts[2] + " S: " + this.counts[3];
        }

        public void enqueue(int mode, Runnable run) {
            if (this.queues[mode] == null) {
                this.queues[mode] = new ArrayList<Runnable>(13);
            }
            this.queues[mode].add(run);
        }

        public List dequeue(int mode) {
            List<Runnable> ret = this.queues[mode];
            this.queues[mode] = null;
            return ret;
        }

        public int getRunnableCount(int mode) {
            return this.queues[mode] == null ? 0 : this.queues[mode].size();
        }
    }

    public static interface ExceptionAction<T> {
        public T run() throws Exception;
    }

    public static interface Action<T>
    extends ExceptionAction<T> {
        @Override
        public T run();
    }
}

