/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.openide.util.AWTBridge;
import org.openide.util.AsyncGUIJob;
import org.openide.util.AsyncInitSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.ContextGlobalProvider;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RE13;
import org.openide.util.TopologicalSortException;
import org.openide.util.UtilitiesCompositeActionMap;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public final class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static ActiveQueue activeReferenceQueue;
    private static int operatingSystem;
    private static final String[] keywords;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static final int CTRL_WILDCARD_MASK = 32768;
    private static final int ALT_WILDCARD_MASK = 65536;
    private static final String TRANS_LOCK = "TRANS_LOCK";
    private static Object transLoader;
    private static RE transExp;
    private static Lookup global;
    private static Reference<NamesAndValues> namesAndValues;

    private Utilities() {
    }

    public static synchronized ReferenceQueue<Object> activeReferenceQueue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new ActiveQueue(false);
        }
        activeReferenceQueue.ping();
        return activeReferenceQueue;
    }

    public static final int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 8192 : ("Windows Vista".equals(osName) ? 262144 : (osName.startsWith("Windows ") ? 32768 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 2048 : ("OpenVMS".equals(osName) ? 16384 : (osName.equals("Mac OS X") ? 4096 : (osName.startsWith("Darwin") ? 4096 : (osName.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : ("OpenBSD".equals(osName) ? 0x100000 : (File.pathSeparatorChar == ':' ? 524288 : 65536))))))))))))))))))));
        }
        return operatingSystem;
    }

    public static final boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0x4A007) != 0;
    }

    public static final boolean isMac() {
        return (Utilities.getOperatingSystem() & 0x1000) != 0;
    }

    public static final boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0x1A13F8) != 0;
    }

    static final void resetOperatingSystem() {
        operatingSystem = -1;
    }

    public static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return Arrays.binarySearch(keywords, id) < 0;
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ie) {
            Exceptions.attachMessage(ie, "Encountered while introspecting " + clazz.getName());
            throw ie;
        }
        catch (Error e) {
            Exceptions.attachMessage(e, "Encountered while introspecting " + clazz.getName());
            throw e;
        }
        if (Component.class.isAssignableFrom(clazz)) {
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!pds[i].getName().equals("cursor")) continue;
                try {
                    Method getter = Component.class.getDeclaredMethod("getCursor", new Class[0]);
                    Method setter = Component.class.getDeclaredMethod("setCursor", Cursor.class);
                    pds[i] = new PropertyDescriptor("cursor", getter, setter);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (bi != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Introspector.flushCaches();
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return bi;
    }

    public static BeanInfo getBeanInfo(Class clazz, Class stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, stopClass);
    }

    @Deprecated
    public static String[] wrapStringToArray(String original, int width, boolean wrapWords, boolean removeNewLines) {
        BreakIterator bi = wrapWords ? BreakIterator.getWordInstance() : BreakIterator.getCharacterInstance();
        return Utilities.wrapStringToArray(original, width, bi, removeNewLines);
    }

    public static String[] wrapStringToArray(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        int i;
        String[] workingSet;
        block14: {
            if (original.length() == 0) {
                return new String[]{original};
            }
            if (removeNewLines) {
                original = Utilities.trimString(original);
                original = original.replace('\n', ' ');
                workingSet = new String[]{original};
            } else {
                StringTokenizer tokens = new StringTokenizer(original, "\n");
                int len = tokens.countTokens();
                workingSet = new String[len];
                for (i = 0; i < len; ++i) {
                    workingSet[i] = tokens.nextToken();
                }
            }
            if (width < 1) {
                width = 1;
            }
            if (original.length() <= width) {
                return workingSet;
            }
            boolean ok = true;
            for (int i2 = 0; i2 < workingSet.length; ++i2) {
                boolean bl = ok = ok && workingSet[i2].length() < width;
                if (ok) {
                    continue;
                }
                break block14;
            }
            return workingSet;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int lineStart = 0;
        for (i = 0; i < workingSet.length; ++i) {
            if (workingSet[i].length() < width) {
                lines.add(workingSet[i]);
                continue;
            }
            breakIterator.setText(workingSet[i]);
            int nextStart = breakIterator.next();
            int prevStart = 0;
            while (true) {
                if (nextStart - lineStart < width && nextStart != -1) {
                    prevStart = nextStart;
                    nextStart = breakIterator.next();
                    continue;
                }
                if (nextStart == -1) {
                    nextStart = prevStart = workingSet[i].length();
                }
                if (prevStart == 0) {
                    prevStart = nextStart;
                }
                lines.add(workingSet[i].substring(lineStart, prevStart));
                lineStart = prevStart;
                prevStart = 0;
                if (lineStart >= workingSet[i].length()) break;
            }
            lineStart = 0;
        }
        String[] s = new String[lines.size()];
        return lines.toArray(s);
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    public static String wrapString(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        String[] sarray = Utilities.wrapStringToArray(original, width, breakIterator, removeNewLines);
        StringBuffer retBuf = new StringBuffer();
        for (int i = 0; i < sarray.length; ++i) {
            retBuf.append(sarray[i]);
            retBuf.append('\n');
        }
        return retBuf.toString();
    }

    @Deprecated
    public static String wrapString(String original, int width, boolean wrapWords, boolean removeNewLines) {
        if (removeNewLines) {
            while (original.startsWith("\n")) {
                original = original.substring(1);
            }
            while (original.endsWith("\n")) {
                original = original.substring(0, original.length() - 1);
            }
            original = original.replace('\n', ' ');
        }
        if (width < 1) {
            width = 1;
        }
        if (original.length() <= width) {
            return original;
        }
        Vector<String> lines = new Vector<String>();
        int lineStart = 0;
        int lastSpacePos = -1;
        for (int i = 0; i < original.length() && lineStart < original.length() - 1; ++i) {
            if (original.charAt(i) == '\n') {
                lines.addElement(original.substring(lineStart, i));
                lineStart = i + 1;
                lastSpacePos = -1;
                continue;
            }
            if (Character.isSpaceChar(original.charAt(i))) {
                lastSpacePos = i;
            }
            if (i == original.length() - 1) {
                lines.addElement(original.substring(lineStart));
                break;
            }
            if (i - lineStart != width) continue;
            if (wrapWords && lastSpacePos != -1) {
                lines.addElement(original.substring(lineStart, lastSpacePos));
                lineStart = lastSpacePos + 1;
                lastSpacePos = -1;
                continue;
            }
            lines.addElement(original.substring(lineStart, i));
            lineStart = i;
            lastSpacePos = -1;
        }
        StringBuffer retBuf = new StringBuffer();
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            retBuf.append((String)e.nextElement());
            retBuf.append('\n');
        }
        return retBuf.toString();
    }

    public static String replaceString(String original, String replaceFrom, String replaceTo) {
        int pos;
        int index = 0;
        if ("".equals(replaceFrom)) {
            return original;
        }
        StringBuffer buf = new StringBuffer();
        do {
            if ((pos = original.indexOf(replaceFrom, index)) == -1) {
                buf.append(original.substring(index));
                return buf.toString();
            }
            buf.append(original.substring(index, pos));
            buf.append(replaceTo);
        } while ((index = pos + replaceFrom.length()) != original.length());
        return buf.toString();
    }

    public static final String pureClassName(String fullName) {
        int index = fullName.indexOf(36);
        if (index >= 0 && index < fullName.length()) {
            return fullName.substring(index + 1, fullName.length());
        }
        return fullName;
    }

    @Deprecated
    public static final boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    public static int arrayHashCode(Object[] arr) {
        int c = 0;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            Object o = arr[i];
            int v = o == null ? 1 : o.hashCode();
            c += v ^ i;
        }
        return c;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        return Utilities.compareObjectsImpl(o1, o2, 1);
    }

    public static boolean compareObjectsImpl(Object o1, Object o2, int checkArraysDepth) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (checkArraysDepth > 0) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                Object[] o1a = (Object[])o1;
                int l1 = o1a.length;
                Object[] o2a = (Object[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (Utilities.compareObjectsImpl(o1a[i], o2a[i], checkArraysDepth - 1)) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                byte[] o1a = (byte[])o1;
                int l1 = o1a.length;
                byte[] o2a = (byte[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                short[] o1a = (short[])o1;
                int l1 = o1a.length;
                short[] o2a = (short[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                int[] o1a = (int[])o1;
                int l1 = o1a.length;
                int[] o2a = (int[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                long[] o1a = (long[])o1;
                int l1 = o1a.length;
                long[] o2a = (long[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                float[] o1a = (float[])o1;
                int l1 = o1a.length;
                float[] o2a = (float[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                double[] o1a = (double[])o1;
                int l1 = o1a.length;
                double[] o2a = (double[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                char[] o1a = (char[])o1;
                int l1 = o1a.length;
                char[] o2a = (char[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                boolean[] o1a = (boolean[])o1;
                int l1 = o1a.length;
                boolean[] o2a = (boolean[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return o1.equals(o2);
    }

    public static String getClassName(Class clazz) {
        if (clazz.isArray()) {
            return Utilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class clazz) {
        if (clazz.isArray()) {
            return Utilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String name = clazz.getName().replace('$', '.');
        return name.substring(name.lastIndexOf(".") + 1, name.length());
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Integer[]) {
            int[] r = new int[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Integer)array[i] == null ? 0 : (Integer)array[i];
            }
            return r;
        }
        if (array instanceof Boolean[]) {
            boolean[] r = new boolean[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Boolean)array[i] == null ? false : (Boolean)array[i];
            }
            return r;
        }
        if (array instanceof Byte[]) {
            byte[] r = new byte[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Byte)array[i] == null ? (byte)0 : (Byte)array[i];
            }
            return r;
        }
        if (array instanceof Character[]) {
            char[] r = new char[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Character)array[i] == null ? (char)'\u0000' : ((Character)array[i]).charValue();
            }
            return r;
        }
        if (array instanceof Double[]) {
            double[] r = new double[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Double)array[i] == null ? 0.0 : (Double)array[i];
            }
            return r;
        }
        if (array instanceof Float[]) {
            float[] r = new float[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Float)array[i] == null ? 0.0f : ((Float)array[i]).floatValue();
            }
            return r;
        }
        if (array instanceof Long[]) {
            long[] r = new long[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Long)array[i] == null ? 0L : (Long)array[i];
            }
            return r;
        }
        if (array instanceof Short[]) {
            short[] r = new short[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Short)array[i] == null ? (short)0 : (Short)array[i];
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            int k = ((int[])array).length;
            Object[] r = new Integer[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Integer(((int[])array)[i]);
            }
            return r;
        }
        if (array instanceof boolean[]) {
            int k = ((boolean[])array).length;
            Object[] r = new Boolean[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((boolean[])array)[i] ? Boolean.TRUE : Boolean.FALSE;
            }
            return r;
        }
        if (array instanceof byte[]) {
            int k = ((byte[])array).length;
            Object[] r = new Byte[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Byte(((byte[])array)[i]);
            }
            return r;
        }
        if (array instanceof char[]) {
            int k = ((char[])array).length;
            Object[] r = new Character[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Character(((char[])array)[i]);
            }
            return r;
        }
        if (array instanceof double[]) {
            int k = ((double[])array).length;
            Object[] r = new Double[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Double(((double[])array)[i]);
            }
            return r;
        }
        if (array instanceof float[]) {
            int k = ((float[])array).length;
            Object[] r = new Float[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Float(((float[])array)[i]);
            }
            return r;
        }
        if (array instanceof long[]) {
            int k = ((long[])array).length;
            Object[] r = new Long[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Long(((long[])array)[i]);
            }
            return r;
        }
        if (array instanceof short[]) {
            int k = ((short[])array).length;
            Object[] r = new Short[k];
            for (int i = 0; i < k; ++i) {
                r[i] = new Short(((short[])array)[i]);
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Class getObjectType(Class c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static Class getPrimitiveType(Class c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static Component getFocusTraversableComponent(Component c) {
        if (c.isFocusable()) {
            return c;
        }
        if (!(c instanceof Container)) {
            return null;
        }
        int k = ((Container)c).getComponentCount();
        for (int i = 0; i < k; ++i) {
            Component v = ((Container)c).getComponent(i);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuffer buff = new StringBuffer(20);
        int slength = s.length();
        for (int i = 0; i < slength; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (state == NULL) {
                    if (buff.length() <= 0) continue;
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                if (state == STICK) {
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\\');
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    state = INPARAM;
                    buff.append('\\');
                    buff.append(c);
                    continue;
                }
                buff.append(c);
                continue;
            }
            if (c == '\\') {
                if (state == NULL) {
                    if (++i < slength) {
                        char cc = s.charAt(i);
                        if (cc == '\"' || cc == '\\') {
                            buff.append(cc);
                            continue;
                        }
                        if (Character.isWhitespace(cc)) {
                            buff.append(c);
                            --i;
                            continue;
                        }
                        buff.append(c);
                        buff.append(cc);
                        continue;
                    }
                    buff.append('\\');
                    break;
                }
                if (state == INPARAM) {
                    state = INPARAMPENDING;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                    continue;
                }
                if (state == STICK) {
                    state = STICKPENDING;
                    continue;
                }
                if (state != STICKPENDING) continue;
                buff.append('\\');
                state = STICK;
                continue;
            }
            if (c == '\"') {
                if (state == NULL) {
                    state = INPARAM;
                    continue;
                }
                if (state == INPARAM) {
                    state = STICK;
                    continue;
                }
                if (state == STICK) {
                    state = INPARAM;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\"');
                    state = STICK;
                    continue;
                }
                buff.append('\"');
                state = INPARAM;
                continue;
            }
            if (state == INPARAMPENDING) {
                buff.append('\\');
                state = INPARAM;
            } else if (state == STICKPENDING) {
                buff.append('\\');
                state = STICK;
            }
            buff.append(c);
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            Utilities.escapeString(params[i], sb);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    private static void escapeString(String s, StringBuffer sb) {
        if (s.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                hasSpace = true;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                sb.append('\\').append('\"');
                continue;
            }
            sb.append(c);
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    private static synchronized NamesAndValues initNameAndValues() {
        NamesAndValues nav;
        if (namesAndValues != null && (nav = namesAndValues.get()) != null) {
            return nav;
        }
        Field[] fields = KeyEvent.class.getDeclaredFields();
        HashMap<String, Integer> names = new HashMap<String, Integer>(fields.length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> values = new HashMap<Integer, String>(fields.length * 4 / 3 + 5, 0.75f);
        for (Field f : fields) {
            String name;
            if (!Modifier.isStatic(f.getModifiers()) || !(name = f.getName()).startsWith("VK_")) continue;
            name = name.substring(3);
            try {
                int numb = f.getInt(null);
                names.put(name, numb);
                values.put(numb, name);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        if (names.get("CONTEXT_MENU") == null) {
            names.put("CONTEXT_MENU", 524);
            values.put(524, "CONTEXT_MENU");
            names.put("WINDOWS", 525);
            values.put(525, "WINDOWS");
        }
        NamesAndValues nav2 = new NamesAndValues(values, names);
        namesAndValues = new SoftReference<NamesAndValues>(nav2);
        return nav2;
    }

    public static String keyToString(KeyStroke stroke) {
        String c;
        StringBuilder sb = new StringBuilder();
        if (Utilities.addModifiers(sb, stroke.getModifiers())) {
            sb.append('-');
        }
        if ((c = Utilities.initNameAndValues().keyToString.get(stroke.getKeyCode())) == null) {
            sb.append(stroke.getKeyChar());
        } else {
            sb.append(c);
        }
        return sb.toString();
    }

    public static KeyStroke stringToKey(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(Locale.ENGLISH), "-", true);
        int needed = 0;
        Map<String, Integer> names = Utilities.initNameAndValues().stringToKey;
        int lastModif = -1;
        try {
            String el;
            while (true) {
                if ((el = st.nextToken()).equals("-")) {
                    if (lastModif == -1) continue;
                    needed |= lastModif;
                    lastModif = -1;
                    continue;
                }
                if (!st.hasMoreElements()) break;
                lastModif = Utilities.readModifiers(el);
            }
            Integer i = names.get(el);
            boolean wildcard = (needed & 0x8000) != 0;
            boolean macAlt = ((needed &= 0xFFFF7FFF) & 0x10000) != 0;
            needed &= 0xFFFEFFFF;
            if (i != null) {
                if (wildcard && Utilities.isMac() && !Utilities.usableKeyOnMac(i, needed |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
                    needed &= ~Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                    needed |= 2;
                }
                if (macAlt) {
                    needed = Utilities.getOperatingSystem() == 4096 ? (needed |= 2) : (needed |= 8);
                }
                return KeyStroke.getKeyStroke(i, needed);
            }
            return null;
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    private static final boolean usableKeyOnMac(int key, int mask) {
        boolean isOnlyMeta;
        if (key == 81) {
            return false;
        }
        boolean isMeta = (mask & 4) != 0 || (mask & 0x80) != 0;
        boolean isAlt = (mask & 8) != 0 || (mask & 0x200) != 0;
        boolean bl = isOnlyMeta = isMeta && (mask & 0xFFFFFEFB) == 0;
        if (isOnlyMeta) {
            return key != 72 && key != 32 && key != 9;
        }
        return key != 68 || !isMeta || !isAlt;
    }

    public static KeyStroke[] stringToKeys(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(Locale.ENGLISH), " ");
        ArrayList<KeyStroke> arr = new ArrayList<KeyStroke>();
        while (st.hasMoreElements()) {
            s = st.nextToken();
            KeyStroke k = Utilities.stringToKey(s);
            if (k == null) {
                return null;
            }
            arr.add(k);
        }
        return arr.toArray(new KeyStroke[arr.size()]);
    }

    private static boolean addModifiers(StringBuilder buf, int modif) {
        boolean b = false;
        if ((modif & 2) != 0) {
            buf.append("C");
            b = true;
        }
        if ((modif & 8) != 0) {
            buf.append("A");
            b = true;
        }
        if ((modif & 1) != 0) {
            buf.append("S");
            b = true;
        }
        if ((modif & 4) != 0) {
            buf.append("M");
            b = true;
        }
        if ((modif & 0x8000) != 0) {
            buf.append("D");
            b = true;
        }
        if ((modif & 0x10000) != 0) {
            buf.append("O");
            b = true;
        }
        return b;
    }

    private static int readModifiers(String s) throws NoSuchElementException {
        int m = 0;
        block8: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'C': {
                    m |= 2;
                    continue block8;
                }
                case 'A': {
                    m |= 8;
                    continue block8;
                }
                case 'M': {
                    m |= 4;
                    continue block8;
                }
                case 'S': {
                    m |= 1;
                    continue block8;
                }
                case 'D': {
                    m |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    m |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(s);
                }
            }
        }
        return m;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window w;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && (w = SwingUtilities.getWindowAncestor(focusOwner)) != null) {
            return w.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = new Rectangle(gconf.getBounds());
        String str = System.getProperty("netbeans.screen.insets");
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ", ");
            if (st.countTokens() == 4) {
                try {
                    bounds.y = Integer.parseInt(st.nextToken());
                    bounds.x = Integer.parseInt(st.nextToken());
                    bounds.height -= bounds.y + Integer.parseInt(st.nextToken());
                    bounds.width -= bounds.x + Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            return bounds;
        }
        str = System.getProperty("netbeans.taskbar.height");
        if (str != null) {
            bounds.height -= Integer.getInteger(str, 0).intValue();
            return bounds;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        return bounds;
    }

    public static Rectangle findCenterBounds(Dimension componentSize) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), componentSize);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration gconf, Dimension componentSize) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = gconf.getBounds();
        return new Rectangle(bounds.x + (bounds.width - componentSize.width) / 2, bounds.y + (bounds.height - componentSize.height) / 2, componentSize.width, componentSize.height);
    }

    @Deprecated
    public static final Dimension getScreenSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (Utilities.isWindows() && !Boolean.getBoolean("netbeans.no.taskbar")) {
            screenSize.height -= 27;
        } else if (Utilities.isMac()) {
            screenSize.height -= 24;
        }
        return screenSize;
    }

    @Deprecated
    public static final int showJFileChooser(JFileChooser chooser, Component parent, String approveButtonText) {
        if (approveButtonText != null) {
            chooser.setApproveButtonText(approveButtonText);
            chooser.setDialogType(2);
        }
        Frame frame = null;
        Dialog parentDlg = null;
        if (parent instanceof Dialog) {
            parentDlg = (Dialog)parent;
        } else {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        String title = chooser.getDialogTitle();
        if (title == null) {
            title = chooser.getUI().getDialogTitle(chooser);
        }
        final JDialog dialog = parentDlg != null ? new JDialog(parentDlg, title, true) : new JDialog(frame, title, true);
        dialog.setDefaultCloseOperation(2);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser, "Center");
        dialog.pack();
        dialog.setBounds(Utilities.findCenterBounds(parent.getGraphicsConfiguration(), dialog.getSize()));
        chooser.rescanCurrentDirectory();
        final int[] retValue = new int[]{1};
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if ("ApproveSelection".equals(ev.getActionCommand())) {
                    retValue[0] = 0;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        chooser.addActionListener(l);
        dialog.show();
        return retValue[0];
    }

    @Deprecated
    public static List partialSort(List l, Comparator c, boolean stable) throws UnorderableException {
        HashSet s;
        HashMap deps = new HashMap();
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                int cmp = c.compare(l.get(i), l.get(j));
                if (cmp == 0) continue;
                Object earlier = l.get(cmp < 0 ? i : j);
                Object later = l.get(cmp > 0 ? i : j);
                s = (HashSet)deps.get(later);
                if (s == null) {
                    s = new HashSet();
                    deps.put(later, s);
                }
                s.add(earlier);
            }
        }
        LinkedList left = new LinkedList(l);
        ArrayList sorted = new ArrayList(size);
        while (left.size() > 0) {
            boolean stillGoing = false;
            Iterator<Object> it = left.iterator();
            while (it.hasNext()) {
                Object elt = it.next();
                Set eltDeps = (Set)deps.get(elt);
                if (eltDeps != null && eltDeps.size() != 0) continue;
                it.remove();
                stillGoing = true;
                sorted.add(elt);
                for (Object elt2 : left) {
                    Set eltDeps2 = (Set)deps.get(elt2);
                    if (eltDeps2 == null) continue;
                    eltDeps2.remove(elt);
                }
                if (!stable) continue;
                break;
            }
            if (stillGoing) continue;
            it = deps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = (Map.Entry)it.next();
                if (!left.contains(me.getKey())) {
                    it.remove();
                    continue;
                }
                s = (Set)me.getValue();
                Iterator it2 = s.iterator();
                while (it2.hasNext()) {
                    if (left.contains(it2.next())) continue;
                    it2.remove();
                }
                if (!s.isEmpty()) continue;
                it.remove();
            }
            throw new UnorderableException(left, deps);
        }
        return sorted;
    }

    public static <T> List<T> topologicalSort(Collection<T> c, Map<? super T, ? extends Collection<? extends T>> edges) throws TopologicalSortException {
        HashMap finished = new HashMap();
        ArrayList r = new ArrayList(Math.max(c.size(), 1));
        ArrayList<T> cRev = new ArrayList<T>(c);
        Collections.reverse(cRev);
        Iterator it = cRev.iterator();
        while (it.hasNext()) {
            List<? super T> cycle = Utilities.visit(it.next(), edges, finished, r);
            if (cycle == null) continue;
            throw new TopologicalSortException(cRev, edges);
        }
        Collections.reverse(r);
        if (r.size() != c.size()) {
            r.retainAll(c);
        }
        return r;
    }

    static <T> List<T> visit(T node, Map<? super T, ? extends Collection<? extends T>> edges, Map<T, Boolean> finished, List<T> r) {
        Boolean b = finished.get(node);
        if (b != null) {
            if (b.booleanValue()) {
                return null;
            }
            ArrayList<T> cycle = new ArrayList<T>();
            cycle.add(node);
            finished.put(node, null);
            return cycle;
        }
        Collection<T> e = edges.get(node);
        if (e != null) {
            finished.put(node, Boolean.FALSE);
            Iterator<T> it = e.iterator();
            while (it.hasNext()) {
                List<T> cycle = Utilities.visit(it.next(), edges, finished, r);
                if (cycle == null) continue;
                if (cycle instanceof ArrayList) {
                    if (Boolean.FALSE == finished.get(node)) {
                        cycle.add(node);
                    } else {
                        Collections.reverse(cycle);
                        cycle = Collections.unmodifiableList(cycle);
                    }
                }
                finished.put(node, Boolean.TRUE);
                return cycle;
            }
        }
        finished.put(node, Boolean.TRUE);
        r.add(node);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String className) {
        Utilities.checkMapping();
        Object object = TRANS_LOCK;
        synchronized (TRANS_LOCK) {
            RE exp = transExp;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (exp == null) {
                return className;
            }
            object = exp;
            synchronized (object) {
                return exp.convert(className);
            }
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader current = Lookup.getDefault().lookup(ClassLoader.class);
        if (current == null) {
            current = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == current) {
            return;
        }
        Utilities.initForLoader(current, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initForLoader(ClassLoader current, Object set) {
        Enumeration<URL> en;
        if (set == null) {
            set = TRANS_LOCK;
        }
        try {
            en = current.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
            en = null;
        }
        if (en == null || !en.hasMoreElements()) {
            String ex = TRANS_LOCK;
            synchronized (TRANS_LOCK) {
                transLoader = set;
                transExp = null;
                // ** MonitorExit[ex] (shouldn't be in output)
                return;
            }
        }
        RE13 re = null;
        re = new RE13();
        TreeSet<String[]> list = new TreeSet<String[]>(new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                int i2;
                String s1 = o1[0];
                String s2 = o2[0];
                int i1 = s1.length();
                if (i1 != (i2 = s2.length())) {
                    return i2 - i1;
                }
                return s2.compareTo(s1);
            }
        });
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream(), "UTF8"));
                Utilities.loadTranslationFile(re, reader, list);
                reader.close();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Problematic file: " + u);
                LOG.log(Level.WARNING, null, ex);
            }
        }
        String[] arr = new String[list.size()];
        String[] pattern = new String[arr.length];
        int i = 0;
        for (String[] pair : list) {
            arr[i] = pair[1].intern();
            pattern[i] = pair[0];
            ++i;
        }
        String string = TRANS_LOCK;
        synchronized (TRANS_LOCK) {
            if (arr.length == 0) {
                transExp = null;
            } else {
                transExp = re;
                transExp.init(pattern, arr);
            }
            transLoader = set;
            // ** MonitorExit[var9_13] (shouldn't be in output)
            return;
        }
    }

    private static void loadTranslationFile(RE re, BufferedReader reader, Set<String[]> results) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] pair = re.readPair(line);
            if (pair == null) {
                throw new InvalidObjectException("Line is invalid: " + line);
            }
            results.add(pair);
        }
    }

    @Deprecated
    public static final Image mergeImages(Image image1, Image image2, int x, int y) {
        return ImageUtilities.mergeImages(image1, image2, x, y);
    }

    @Deprecated
    public static final Image loadImage(String resourceID) {
        return ImageUtilities.loadImage(resourceID);
    }

    @Deprecated
    public static final Image icon2Image(Icon icon) {
        return ImageUtilities.icon2Image(icon);
    }

    public static JPopupMenu actionsToPopup(Action[] actions, Lookup context) {
        HashSet<Action> counted = new HashSet<Action>();
        ArrayList<Component> components = new ArrayList<Component>();
        for (Action action : actions) {
            if (action != null && counted.add(action)) {
                JMenuItem item;
                if (action instanceof ContextAwareAction) {
                    Action contextAwareAction = ((ContextAwareAction)action).createContextAwareInstance(context);
                    if (contextAwareAction == null) {
                        Logger.getLogger(Utilities.class.getName()).warning("ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action=" + action + ", context=" + context);
                    } else {
                        action = contextAwareAction;
                    }
                }
                if (action instanceof Presenter.Popup) {
                    item = ((Presenter.Popup)((Object)action)).getPopupPresenter();
                    if (item == null) {
                        Logger.getLogger(Utilities.class.getName()).warning("findContextMenuImpl, getPopupPresenter returning null for " + action);
                        continue;
                    }
                } else {
                    item = AWTBridge.getDefault().createPopupPresenter(action);
                }
                for (Component c : AWTBridge.getDefault().convertComponents(item)) {
                    if (c instanceof JSeparator) {
                        components.add(null);
                        continue;
                    }
                    components.add(c);
                }
                continue;
            }
            components.add(null);
        }
        JPopupMenu menu = AWTBridge.getDefault().createEmptyPopup();
        boolean nonempty = false;
        boolean pendingSep = false;
        for (Component c : components) {
            if (c == null) {
                pendingSep = nonempty;
                continue;
            }
            nonempty = true;
            if (pendingSep) {
                pendingSep = false;
                menu.addSeparator();
            }
            menu.add(c);
        }
        return menu;
    }

    public static JPopupMenu actionsToPopup(Action[] actions, Component component) {
        Lookup lookup = null;
        for (Component c = component; !(c == null || c instanceof Lookup.Provider && (lookup = ((Lookup.Provider)((Object)c)).getLookup()) != null); c = c.getParent()) {
        }
        if (lookup == null) {
            UtilitiesCompositeActionMap map = new UtilitiesCompositeActionMap(component);
            lookup = Lookups.singleton(map);
        }
        return Utilities.actionsToPopup(actions, lookup);
    }

    public static List<? extends Action> actionsForPath(String path) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Object item : Lookups.forPath(path).lookupAll(Object.class)) {
            if (item instanceof Action) {
                actions.add((Action)item);
                continue;
            }
            if (item instanceof JSeparator) {
                actions.add(null);
                continue;
            }
            Logger.getLogger(Utilities.class.getName()).warning("Unrecognized object of " + item.getClass() + " found in actions path " + path);
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lookup actionsGlobalContext() {
        Class<ContextGlobalProvider> clazz = ContextGlobalProvider.class;
        synchronized (ContextGlobalProvider.class) {
            if (global != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return global;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            ContextGlobalProvider p = Lookup.getDefault().lookup(ContextGlobalProvider.class);
            Lookup l = p == null ? Lookup.EMPTY : p.createGlobalContext();
            Class<ContextGlobalProvider> clazz2 = ContextGlobalProvider.class;
            synchronized (ContextGlobalProvider.class) {
                if (global == null) {
                    global = l;
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return global;
            }
        }
    }

    @Deprecated
    public static final Image loadImage(String resource, boolean localized) {
        return ImageUtilities.loadImage(resource, localized);
    }

    public static final Cursor createProgressCursor(Component component) {
        if (component == null) {
            throw new NullPointerException("Given component is null");
        }
        Image image = null;
        image = Utilities.isMac() ? Utilities.loadImage("org/openide/util/progress-cursor-mac.gif") : (Utilities.isUnix() ? Utilities.loadImage("org/openide/util/progress-cursor-motif.gif") : Utilities.loadImage("org/openide/util/progress-cursor-win.gif"));
        return Utilities.createCustomCursor(component, image, "PROGRESS_CURSOR");
    }

    public static Cursor createCustomCursor(Component component, Image icon, String name) {
        Toolkit t = component.getToolkit();
        Dimension d = t.getBestCursorSize(16, 16);
        Image i = icon;
        if (d.width != icon.getWidth(null)) {
            if (d.width == 0 && d.height == 0) {
                return Cursor.getPredefinedCursor(3);
            }
            BufferedImage empty = ImageUtilities.createBufferedImage(d.width, d.height);
            i = Utilities.mergeImages(icon, empty, 0, 0);
        }
        return t.createCustomCursor(i, new Point(1, 1), name);
    }

    public static final void attachInitJob(Component comp4Init, AsyncGUIJob initJob) {
        new AsyncInitSupport(comp4Init, initJob);
    }

    @Deprecated
    public static URL toURL(File f) throws MalformedURLException {
        if (f == null) {
            throw new NullPointerException();
        }
        if (!f.isAbsolute()) {
            throw new IllegalArgumentException("Relative path: " + f);
        }
        URI uri = f.toURI();
        return uri.toURL();
    }

    @Deprecated
    public static File toFile(URL u) {
        if (u == null) {
            throw new NullPointerException();
        }
        try {
            URI uri = new URI(u.toExternalForm());
            return new File(uri);
        }
        catch (URISyntaxException use) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    static {
        operatingSystem = -1;
        keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    }

    private static final class ActiveQueue
    extends ReferenceQueue<Object>
    implements Runnable {
        private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName().replace('$', '.'));
        private int count;
        private boolean deprecated;

        public ActiveQueue(boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Reference ref;
                    while (true) {
                        ref = super.remove(0L);
                        LOGGER.finer("dequeued reference");
                        if (ref instanceof Runnable) break;
                        LOGGER.warning("A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): " + ref.getClass());
                    }
                    if (this.deprecated) {
                        LOGGER.warning("Utilities.ACTIVE_REFERENCE_QUEUE has been deprecated for " + ref.getClass() + " use Utilities.activeReferenceQueue");
                    }
                    try {
                        ((Runnable)((Object)ref)).run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                    finally {
                        ref = null;
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                ActiveQueue activeQueue = this;
                synchronized (activeQueue) {
                    assert (this.count > 0);
                    --this.count;
                    if (this.count == 0) {
                        LOGGER.fine("stopping thread");
                        break;
                    }
                }
            }
        }

        synchronized void ping() {
            if (this.count == 0) {
                Thread t = new Thread((Runnable)this, "Active Reference Queue Daemon");
                t.setPriority(1);
                t.setDaemon(true);
                t.start();
                LOGGER.fine("starting thread");
            } else {
                LOGGER.finer("enqueuing reference");
            }
            ++this.count;
        }
    }

    @Deprecated
    public static class UnorderableException
    extends RuntimeException {
        static final long serialVersionUID = 6749951134051806661L;
        private Collection unorderable;
        private Map deps;

        public UnorderableException(Collection unorderable, Map deps) {
            this.unorderable = unorderable;
            this.deps = deps;
        }

        public UnorderableException(String message, Collection unorderable, Map deps) {
            super(message);
            this.unorderable = unorderable;
            this.deps = deps;
        }

        public Collection getUnorderable() {
            return this.unorderable;
        }

        public Map getDeps() {
            return this.deps;
        }
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }

    private static final class NamesAndValues {
        final Map<Integer, String> keyToString;
        final Map<String, Integer> stringToKey;

        NamesAndValues(Map<Integer, String> keyToString, Map<String, Integer> stringToKey) {
            this.keyToString = keyToString;
            this.stringToKey = stringToKey;
        }
    }
}

