/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaPlayFrameworkServerCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    public static final String TITLE = "title";
    public static final String SKIP_STUBS = "skipStubs";
    public static final String SUPPORT_ASYNC = "supportAsync";
    public static final String GENERATE_CUSTOM_EXCEPTIONS = "generateCustomExceptions";
    public static final String USE_SWAGGER_UI = "useSwaggerUI";
    public static final String ROUTES_FILE_NAME = "routesFileName";
    public static final String BASE_PACKAGE = "basePackage";
    static Logger LOGGER = LoggerFactory.getLogger(ScalaPlayFrameworkServerCodegen.class);
    protected boolean skipStubs = false;
    protected boolean supportAsync = false;
    protected boolean generateCustomExceptions = true;
    protected boolean useSwaggerUI = true;
    protected String routesFileName = "routes";
    protected String basePackage = "org.openapitools";

    public ScalaPlayFrameworkServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code" + File.separator + "scala-play-server";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scala-play-server";
        this.embeddedTemplateDir = "scala-play-server";
        this.hideGenerationTimestamp = false;
        this.sourceFolder = "app";
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.instantiationTypes.put("map", "Map");
        this.instantiationTypes.put("array", "List");
        this.typeMapping.put("DateTime", "OffsetDateTime");
        this.typeMapping.put("Date", "LocalDate");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("binary", "Array[Byte]");
        this.typeMapping.put("ByteArray", "Array[Byte]");
        this.typeMapping.put("object", "JsObject");
        this.typeMapping.put("file", "TemporaryFile");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.remove("BigDecimal");
        this.importMapping.put("TemporaryFile", "play.api.libs.Files.TemporaryFile");
        this.cliOptions.removeIf(opt -> "dateLibrary".equals(opt.getOpt()));
        this.cliOptions.add(new CliOption(ROUTES_FILE_NAME, "Name of the routes file to generate.").defaultValue(this.routesFileName));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "Base package in which supporting classes are generated.").defaultValue(this.basePackage));
        this.addCliOptionWithDefault(SKIP_STUBS, "If set, skips generation of stub classes.", this.skipStubs);
        this.addCliOptionWithDefault(SUPPORT_ASYNC, "If set, wraps API return types with Futures and generates async actions.", this.supportAsync);
        this.addCliOptionWithDefault(GENERATE_CUSTOM_EXCEPTIONS, "If set, generates custom exception types.", this.generateCustomExceptions);
        this.addCliOptionWithDefault(USE_SWAGGER_UI, "Add a route to /api which show your documentation in swagger-ui. Will also import needed dependencies", this.useSwaggerUI);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scala-play-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala server application (beta) with Play Framework.";
    }

    public void setSupportAsync(boolean supportAsync) {
        this.supportAsync = supportAsync;
    }

    public void setSkipStubs(boolean skipStubs) {
        this.skipStubs = skipStubs;
    }

    public void setGenerateCustomExceptions(boolean generateCustomExceptions) {
        this.generateCustomExceptions = generateCustomExceptions;
    }

    public void setRoutesFileName(String routesFileName) {
        this.routesFileName = routesFileName;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setUseSwaggerUI(boolean useSwaggerUI) {
        this.useSwaggerUI = useSwaggerUI;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(SKIP_STUBS)) {
            this.setSkipStubs(this.convertPropertyToBoolean(SKIP_STUBS));
        }
        this.writePropertyBack(SKIP_STUBS, this.skipStubs);
        if (this.additionalProperties.containsKey(SUPPORT_ASYNC)) {
            this.setSupportAsync(this.convertPropertyToBoolean(SUPPORT_ASYNC));
        }
        this.writePropertyBack(SUPPORT_ASYNC, this.supportAsync);
        if (this.additionalProperties.containsKey(GENERATE_CUSTOM_EXCEPTIONS)) {
            this.setGenerateCustomExceptions(this.convertPropertyToBoolean(GENERATE_CUSTOM_EXCEPTIONS));
        }
        this.writePropertyBack(GENERATE_CUSTOM_EXCEPTIONS, this.generateCustomExceptions);
        if (this.additionalProperties.containsKey(USE_SWAGGER_UI)) {
            this.setUseSwaggerUI(this.convertPropertyToBoolean(USE_SWAGGER_UI));
        }
        this.writePropertyBack(USE_SWAGGER_UI, this.useSwaggerUI);
        if (this.additionalProperties.containsKey(ROUTES_FILE_NAME)) {
            this.setRoutesFileName((String)this.additionalProperties.get(ROUTES_FILE_NAME));
        } else {
            this.additionalProperties.put(ROUTES_FILE_NAME, this.routesFileName);
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        this.apiTemplateFiles.remove("api.mustache");
        if (!this.skipStubs) {
            this.apiTemplateFiles.put("app/apiImplStubs.scala.mustache", "Impl.scala");
        }
        this.apiTemplateFiles.put("app/apiTrait.scala.mustache", ".scala");
        this.apiTemplateFiles.put("app/apiController.scala.mustache", "Controller.scala");
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("conf/application.conf.mustache", "conf", "application.conf"));
        this.supportingFiles.add(new SupportingFile("conf/logback.xml.mustache", "conf", "logback.xml"));
        this.supportingFiles.add(new SupportingFile("project/build.properties.mustache", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt.mustache", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("conf/routes.mustache", "conf", this.routesFileName));
        this.supportingFiles.add(new SupportingFile("app/module.scala.mustache", this.getBasePackagePath(), "Module.scala"));
        this.supportingFiles.add(new SupportingFile("app/errorHandler.scala.mustache", this.getBasePackagePath(), "ErrorHandler.scala"));
        if (this.generateCustomExceptions) {
            this.supportingFiles.add(new SupportingFile("app/exceptions.scala.mustache", this.getBasePackagePath(), "OpenApiExceptions.scala"));
        }
        if (this.useSwaggerUI) {
            this.supportingFiles.add(new SupportingFile("public/openapi.json.mustache", "public", "openapi.json"));
            this.supportingFiles.add(new SupportingFile("app/apiDocController.scala.mustache", String.format(Locale.ROOT, "app/%s", this.apiPackage.replace(".", File.separator)), "ApiDocController.scala"));
        }
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"indented_4", (Object)new IndentedLambda(4, " "));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        HashMap<String, CodegenModel> models = new HashMap<String, CodegenModel>();
        for (Object _mo : allModels) {
            CodegenModel model = (CodegenModel)((Map)_mo).get("model");
            models.put(model.classname, model);
        }
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                Pattern pathVariableMatcher = Pattern.compile("\\{([^}]+)}");
                Matcher match = pathVariableMatcher.matcher(operation.path);
                while (match.find()) {
                    String completeMatch = match.group();
                    String replacement = ":" + StringUtils.camelize(match.group(1), true);
                    operation.path = operation.path.replace(completeMatch, replacement);
                }
                if (!"null".equals(operation.defaultResponse) || !models.containsKey(operation.returnType)) continue;
                operation.defaultResponse = ((CodegenModel)models.get((Object)operation.returnType)).defaultValue;
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        objs = super.postProcessAllModels(objs);
        HashMap<String, CodegenModel> modelsByClassName = new HashMap<String, CodegenModel>();
        OnceLogger.once(LOGGER).warn("4.3.0 has deprecated the use of vendor extensions which don't follow lower-kebab casing standards with x- prefix.");
        for (Object _outer : objs.values()) {
            Map outer = (Map)_outer;
            List models = (List)outer.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                this.postProcessModelsEnum(outer);
                cm.classVarName = StringUtils.camelize(cm.classVarName, true);
                modelsByClassName.put(cm.classname, cm);
                boolean hasFiles = cm.vars.stream().anyMatch(var -> var.isFile);
                cm.vendorExtensions.put("hasFiles", hasFiles);
                cm.vendorExtensions.put("x-has-files", hasFiles);
            }
        }
        for (CodegenModel model : modelsByClassName.values()) {
            model.defaultValue = this.generateModelDefaultValue(model, modelsByClassName);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs = super.postProcessSupportingFileData(objs);
        this.generateJSONSpecFile(objs);
        OnceLogger.once(LOGGER).warn("4.3.0 has deprecated the use of vendor extensions which don't follow lower-kebab casing standards with x- prefix.");
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        List<CodegenOperation> ops = apis.stream().map(api -> (Map)api.get("operations")).flatMap(operations -> ((List)operations.get("operation")).stream()).collect(Collectors.toList());
        int maxPathLength = ops.stream().mapToInt(op -> op.httpMethod.length() + op.path.length()).reduce(0, Integer::max);
        ops.forEach(op -> {
            String paddedPath = org.apache.commons.lang3.StringUtils.rightPad((String)op.path, (int)(maxPathLength - op.httpMethod.length()));
            op.vendorExtensions.put("paddedPath", paddedPath);
            op.vendorExtensions.put("x-padded-path", paddedPath);
        });
        ops.forEach(op -> {
            op.vendorExtensions.put("hasPathParams", op.getHasPathParams());
            op.vendorExtensions.put("x-has-path-params", op.getHasPathParams());
        });
        return objs;
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType = this.getAlias(openAPIType))) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (null == openAPIType) {
            LOGGER.error("No Type defined for Schema " + p);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getRequired() != null && p.getRequired().contains(p.getName())) {
            return "None";
        }
        if (p.getDefault() != null) {
            return p.getDefault().toString();
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "LocalDate.now";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "OffsetDateTime.now";
        }
        if (ModelUtils.isDoubleSchema(p)) {
            return "0.0";
        }
        if (ModelUtils.isFloatSchema(p)) {
            return "0.0F";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return "0";
        }
        if (ModelUtils.isLongSchema(p)) {
            return "0L";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "\"\"";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema ap = ModelUtils.getAdditionalProperties(p);
            String inner = this.getSchemaType(ap);
            return "Map.empty[String, " + inner + "]";
        }
        if (ModelUtils.isArraySchema(p)) {
            Schema items = ((ArraySchema)p).getItems();
            String inner = this.getSchemaType(items);
            if (ModelUtils.isSet(p)) {
                return "Set.empty[" + inner + "]";
            }
            return "List.empty[" + inner + "]";
        }
        return "null";
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.camelizeStripReservedEscape(property.name);
    }

    public String camelizeStripReservedEscape(String str) {
        if (str.startsWith("`") && str.endsWith("`")) {
            str = str.substring(1, str.length() - 1);
        }
        return StringUtils.camelize(str);
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = StringUtils.camelize(value.replaceAll("\\W+", "_"));
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    private void addCliOptionWithDefault(String name, String description, boolean defaultValue) {
        this.cliOptions.add(CliOption.newBoolean(name, description).defaultValue(Boolean.toString(defaultValue)));
    }

    private String getBasePackagePath() {
        return String.format(Locale.ROOT, "%s/%s", this.sourceFolder, this.basePackage.replace(".", File.separator));
    }

    private String generateModelDefaultValue(CodegenModel cm, Map<String, CodegenModel> models) {
        StringBuilder defaultValue = new StringBuilder();
        defaultValue.append(cm.classname).append('(');
        for (CodegenProperty var : cm.vars) {
            if (!var.required) {
                defaultValue.append("None");
            } else if (models.containsKey(var.dataType)) {
                defaultValue.append(this.generateModelDefaultValue(models.get(var.dataType), models));
            } else if (var.defaultValue != null) {
                defaultValue.append(var.defaultValue);
            } else if (var.isEnum) {
                defaultValue.append(cm.classname).append('.').append(var.enumName).append(".values.head");
            } else {
                LOGGER.warn("Unknown default value for var {0} in class {1}", (Object)var.name, (Object)cm.classname);
                defaultValue.append("null");
            }
            if (!var.hasMore) continue;
            defaultValue.append(", ");
        }
        if (cm.isMapModel) {
            defaultValue.append(", Map.empty");
        }
        defaultValue.append(')');
        return defaultValue.toString();
    }
}

