/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLibcurlClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLibcurlClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    protected String moduleName;
    protected String projectName;
    protected static final String defaultProjectName = "openapi_client";
    protected String specFolder = "spec";
    protected String libFolder = "lib";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected static int emptyMethodNameCounter = 0;

    public CLibcurlClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.ApiKey)).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.JSON, WireFormatFeature.XML}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism, SchemaSupportFeature.Union}));
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separator + "C-libcurl";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".c");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".c");
        this.templateDir = "C-libcurl";
        this.embeddedTemplateDir = "C-libcurl";
        this.modelTestTemplateFiles.put("model_test.mustache", ".c");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "inline", "int", "long", "register", "remove", "restrict", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatile", "while", "_Alignas", "_Alignof", "_Atomic", "_Bool", "_Complex", "_Generic", "_Imaginary", "_Noreturn", "_Static_assert", "_Thread_local"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.importMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("short");
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("long");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("double");
        this.languageSpecificPrimitives.add("char");
        this.languageSpecificPrimitives.add("binary_t*");
        this.languageSpecificPrimitives.add("Object");
        this.languageSpecificPrimitives.add("list_t*");
        this.languageSpecificPrimitives.add("list");
        this.typeMapping.put("string", "char");
        this.typeMapping.put("char", "char");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("date", "char");
        this.typeMapping.put("DateTime", "char");
        this.typeMapping.put("boolean", "int");
        this.typeMapping.put("file", "binary_t*");
        this.typeMapping.put("binary", "binary_t*");
        this.typeMapping.put("ByteArray", "char");
        this.typeMapping.put("UUID", "char");
        this.typeMapping.put("URI", "char");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "list_t*");
        this.typeMapping.put("date-time", "char");
        Iterator itr = this.cliOptions.iterator();
        while (itr.hasNext()) {
            CliOption opt = (CliOption)itr.next();
            if (!"modelPackage".equals(opt.getOpt()) && !"apiPackage".equals(opt.getOpt())) continue;
            itr.remove();
        }
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("C_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable C_POST_PROCESS_FILE not defined so the C code may not be properly formatted by uncrustify (0.66 or later) or other code formatter. To define it, try `export C_POST_PROCESS_FILE=\"/usr/local/bin/uncrustify --no-backup\" && export UNCRUSTIFY_CONFIG=/path/to/uncrustify-rules.cfg` (Linux/Mac). Note: replace /path/to with the location of uncrustify-rules.cfg");
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.setModelPackage("models");
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("libcurl.licence.mustache", "", "libcurl.licence"));
        this.supportingFiles.add(new SupportingFile("uncrustify-rules.cfg.mustache", "", "uncrustify-rules.cfg"));
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("apiClient.c.mustache", "src", "apiClient.c"));
        this.supportingFiles.add(new SupportingFile("apiKey.c.mustache", "src", "apiKey.c"));
        this.supportingFiles.add(new SupportingFile("list.c.mustache", "src", "list.c"));
        this.supportingFiles.add(new SupportingFile("binary.c.mustache", "src", "binary.c"));
        this.supportingFiles.add(new SupportingFile("apiClient.h.mustache", "include", "apiClient.h"));
        this.supportingFiles.add(new SupportingFile("keyValuePair.h.mustache", "include", "keyValuePair.h"));
        this.supportingFiles.add(new SupportingFile("list.h.mustache", "include", "list.h"));
        this.supportingFiles.add(new SupportingFile("binary.h.mustache", "include", "binary.h"));
        this.supportingFiles.add(new SupportingFile("cJSON.licence.mustache", "external", "cJSON.licence"));
        this.supportingFiles.add(new SupportingFile("cJSON.c.mustache", "external", "cJSON.c"));
        this.supportingFiles.add(new SupportingFile("cJSON.h.mustache", "external", "cJSON.h"));
        this.supportingFiles.add(new SupportingFile("object-body.mustache", "model", "object.c"));
        this.supportingFiles.add(new SupportingFile("object-header.mustache", "model", "object.h"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "c";
    }

    @Override
    public String getHelp() {
        return "Generates a C (libcurl) client library (beta).";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "api";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "model";
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + "unit-test";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + "unit-test";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            return "'" + this.escapeText((String)p.getDefault()) + "'";
        }
        return null;
    }

    @Override
    public String toExampleValue(Schema schema) {
        String example = super.toExampleValue(schema);
        if (ModelUtils.isNullType(schema) && null != example) {
            return "NULL";
        }
        if (ModelUtils.isStringSchema(schema) && schema.getDefault() != null) {
            example = (String)schema.getDefault();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)example) && !"null".equals(example)) {
            if (ModelUtils.isStringSchema(schema)) {
                example = "\"" + example + "\"";
            }
            return example;
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            example = schema.getEnum().get(0).toString();
            if (null == example) {
                LOGGER.warn("Empty enum. Cannot built an example!");
            }
            return example;
        }
        if (null != schema.get$ref()) {
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            String ref = ModelUtils.getSimpleRef(schema.get$ref());
            if (allDefinitions != null) {
                Schema refSchema = allDefinitions.get(ref);
                if (null == refSchema) {
                    return "None";
                }
                String refTitle = refSchema.getTitle();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                    refSchema.setTitle(ref);
                }
                return this.toExampleValue(refSchema);
            }
            LOGGER.warn("allDefinitions not defined in toExampleValue!\n");
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = "\"2013-10-20\"";
            return example;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = "\"2013-10-20T19:20:30+01:00\"";
            return example;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            example = "instantiate_binary_t(\"blah\", 5)";
            return example;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            example = "YQ==";
        } else if (ModelUtils.isStringSchema(schema)) {
            if ("number".equalsIgnoreCase(schema.getFormat())) {
                return "1";
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                return "\"a\"";
            }
            int len = 0;
            if (null != schema.getMinLength()) {
                len = schema.getMinLength();
            }
            if (len < 1) {
                len = 1;
            }
            example = "";
            for (int i = 0; i < len; ++i) {
                example = example + i;
            }
        } else if (ModelUtils.isIntegerSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "56";
        } else if (ModelUtils.isNumberSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1.337";
        } else if (ModelUtils.isBooleanSchema(schema)) {
            example = "1";
        } else if (ModelUtils.isArraySchema(schema)) {
            example = "list_create()";
        } else if (ModelUtils.isMapSchema(schema)) {
            example = "list_create()";
        } else {
            if (ModelUtils.isObjectSchema(schema)) {
                return null;
            }
            LOGGER.warn("Type " + schema.getType() + " not handled properly in toExampleValue");
        }
        if (ModelUtils.isStringSchema(schema)) {
            example = "\"" + this.escapeText(example) + "\"";
        }
        return example;
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if (this.isReservedWord(name = StringUtils.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        name = name.replaceAll("-", "_");
        return name;
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name)) {
            String modelName = StringUtils.camelize("Model" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.camelize(name) + "API";
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return ("test_" + this.toApiFilename(name)).replaceAll("_", "-");
    }

    @Override
    public String toModelTestFilename(String name) {
        return "test_" + this.toModelFilename(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(name) + "API";
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (this.isReservedWord(value = value.replaceAll("-", "_"))) {
            value = this.escapeReservedWord(value);
        }
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            return value;
        }
        if (value.matches("\\d.*")) {
            return this.escapeReservedWord(this.escapeText(value));
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(StringUtils.camelize(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.camelize(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = StringUtils.camelize("empty_method_name_" + emptyMethodNameCounter++);
            LOGGER.warn("Empty method name (operationId) found. Renamed to " + operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize(this.sanitizeName("call_" + operationId), true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            String newOperationId = StringUtils.camelize(this.sanitizeName("call_" + operationId), true);
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return StringUtils.camelize(this.sanitizeName(operationId), true);
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return "#include \"../model/" + (String)this.importMapping.get(name) + ".h\"";
        }
        return "#include \"../model/" + name + ".h\"";
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "File.new('" + this.escapeText(example) + "')";
        } else if ("Date".equals(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "Date.parse('" + this.escapeText(example) + "')";
        } else if ("DateTime".equals(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "DateTime.parse('" + this.escapeText(example) + "')";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.moduleName + "::" + type + ".new";
        }
        if (example == null) {
            example = "nil";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "{'key' => " + example + "}";
        }
        p.example = example;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            this.setProjectName(this.escapeText(info.getTitle()));
        } else {
            this.setProjectName(defaultProjectName);
        }
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
    }

    public void setProjectName(String projectName) {
        this.projectName = StringUtils.underscore(this.sanitizeName(projectName.toLowerCase(Locale.ROOT)));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin");
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty cm = super.fromProperty(name, p);
        Schema ref = ModelUtils.getReferencedSchema(this.openAPI, p);
        if (ref != null && ref.getEnum() != null) {
            cm.isEnum = true;
        }
        return cm;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String cPostProcessFile = System.getenv("C_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cPostProcessFile)) {
            return;
        }
        HashSet<String> supportedFileType = new HashSet<String>(Arrays.asList("supporting-mustache", "model-test", "model", "api-test", "api"));
        if (!supportedFileType.contains(fileType)) {
            return;
        }
        if ("c".equals(FilenameUtils.getExtension((String)file.toString())) || "h".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = cPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

