/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenServer;
import org.openapitools.codegen.CodegenServerVariable;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCppCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractCppCodegen.class);
    protected static final String RESERVED_WORD_PREFIX_OPTION = "reservedWordPrefix";
    protected static final String RESERVED_WORD_PREFIX_DESC = "Prefix to prepend to reserved words in order to avoid conflicts";
    protected String reservedWordPrefix = "r_";
    protected static final String VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_OPTION = "variableNameFirstCharacterUppercase";
    protected static final String VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_DESC = "Make first character of variable name uppercase (eg. value -> Value)";
    protected boolean variableNameFirstCharacterUppercase = true;

    public AbstractCppCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "concept", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "linux", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"));
        this.addOption(RESERVED_WORD_PREFIX_OPTION, RESERVED_WORD_PREFIX_DESC, this.reservedWordPrefix);
        this.addOption(VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_OPTION, VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_DESC, Boolean.toString(this.variableNameFirstCharacterUppercase));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toApiName(String type) {
        return this.sanitizeName(this.modelNamePrefix + super.toApiName(type));
    }

    @Override
    public String toModelName(String type) {
        if (type == null) {
            this.LOGGER.warn("Model name can't be null. Default to 'UnknownModel'.");
            type = "UnknownModel";
        }
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return this.sanitizeName(this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1));
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return this.escapeText(value);
    }

    @Override
    public String toVarName(String name) {
        if (this.typeMapping.keySet().contains(name) || this.typeMapping.values().contains(name) || this.importMapping.values().contains(name) || this.defaultIncludes.contains(name) || this.languageSpecificPrimitives.contains(name)) {
            return this.sanitizeName(name);
        }
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            return this.escapeReservedWord(name);
        }
        if (this.variableNameFirstCharacterUppercase && name.length() > 1) {
            return this.sanitizeName(Character.toUpperCase(name.charAt(0)) + name.substring(1));
        }
        return this.sanitizeName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return this.sanitizeName(this.reservedWordPrefix + name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + this.escapeReservedWord(operationId));
            return this.escapeReservedWord(operationId);
        }
        return this.sanitizeName(super.toOperationId(operationId));
    }

    @Override
    public String toParamName(String name) {
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            return this.escapeReservedWord(name);
        }
        return this.sanitizeName(super.toParamName(name));
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty property = super.fromProperty(name, p);
        String nameInCamelCase = property.nameInCamelCase;
        nameInCamelCase = nameInCamelCase.length() > 1 ? this.sanitizeName(Character.toLowerCase(nameInCamelCase.charAt(0)) + nameInCamelCase.substring(1)) : this.sanitizeName(nameInCamelCase);
        if (this.isReservedWord(nameInCamelCase) || nameInCamelCase.matches("^\\d.*")) {
            nameInCamelCase = this.escapeReservedWord(nameInCamelCase);
        }
        property.nameInCamelCase = nameInCamelCase;
        return property;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return "std::shared_ptr<" + this.toModelName(str) + ">";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isEmpty((CharSequence)System.getenv("CPP_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable CPP_POST_PROCESS_FILE not defined so the C++ code may not be properly formatted. To define it, try 'export CPP_POST_PROCESS_FILE=\"/usr/local/bin/clang-format -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(RESERVED_WORD_PREFIX_OPTION)) {
            this.reservedWordPrefix = (String)this.additionalProperties.get(RESERVED_WORD_PREFIX_OPTION);
        }
        this.additionalProperties.put(RESERVED_WORD_PREFIX_OPTION, this.reservedWordPrefix);
        if (this.additionalProperties.containsKey(VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_OPTION)) {
            this.variableNameFirstCharacterUppercase = this.convertPropertyToBooleanAndWriteBack(VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_OPTION);
        }
        this.additionalProperties.put(VARIABLE_NAME_FIRST_CHARACTER_UPPERCASE_OPTION, this.variableNameFirstCharacterUppercase);
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"multiline_comment_4", (Object)new IndentedLambda(4, " ", "///"));
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String cppPostProcessFile = System.getenv("CPP_POST_PROCESS_FILE");
        if (StringUtils.isEmpty((CharSequence)cppPostProcessFile)) {
            return;
        }
        if ("cpp".equals(FilenameUtils.getExtension((String)file.toString())) || "h".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = cppPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        List serverList = openAPI.getServers();
        ArrayList<CodegenServer> CodegenServerList = new ArrayList<CodegenServer>();
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        String port = URLPathUtils.getPort(url, "");
        String host = url.getHost();
        String scheme = url.getProtocol();
        if (!port.isEmpty()) {
            this.additionalProperties.put("serverPort", port);
        }
        if (!host.isEmpty()) {
            this.additionalProperties.put("serverHost", host);
        }
        if (!scheme.isEmpty()) {
            this.additionalProperties.put("scheme", scheme);
        }
        if (!serverList.isEmpty()) {
            for (Server server : serverList) {
                CodegenServer s = new CodegenServer();
                s.description = server.getDescription();
                s.url = server.getUrl();
                s.variables = new ArrayList<CodegenServerVariable>();
                ServerVariables serverVars = server.getVariables();
                if (serverVars != null) {
                    serverVars.forEach((key, value) -> {
                        CodegenServerVariable codegenServerVar = new CodegenServerVariable();
                        ServerVariable ServerVar = value;
                        codegenServerVar.name = key;
                        codegenServerVar.description = ServerVar.getDescription();
                        codegenServerVar.defaultValue = ServerVar.getDefault();
                        codegenServerVar.enumValues = ServerVar.getEnum();
                        s.variables.add(codegenServerVar);
                    });
                }
                CodegenServerList.add(s);
            }
            this.vendorExtensions.put("x-cpp-global-server-list", CodegenServerList);
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (!cm.isArray && !cm.isMap || cm.parentModel != null) continue;
            cm.parent = null;
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> models = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> model : models.entrySet()) {
            CodegenModel mo = ModelUtils.getModelByName(model.getKey(), models);
            this.addForwardDeclarations(mo, models);
        }
        return models;
    }

    private void addForwardDeclarations(CodegenModel parentModel, Map<String, Object> objs) {
        ArrayList<String> forwardDeclarations = new ArrayList<String>();
        if (!parentModel.hasVars) {
            return;
        }
        for (CodegenProperty property : parentModel.vars) {
            if ((!property.isContainer || !property.mostInnerItems.isModel) && !property.isModel) continue;
            String childPropertyType = property.isContainer ? property.mostInnerItems.baseType : property.baseType;
            for (Map.Entry<String, Object> mo : objs.entrySet()) {
                CodegenModel childModel = ModelUtils.getModelByName(mo.getKey(), objs);
                if (!childPropertyType.equals(childModel.classname) || childPropertyType.equals(parentModel.classname) || !childModel.hasVars) continue;
                for (CodegenProperty p : childModel.vars) {
                    String forwardDecl;
                    if ((!p.isModel || !p.dataType.equals(parentModel.classname)) && (!p.isContainer || !p.mostInnerItems.baseType.equals(parentModel.classname)) || forwardDeclarations.contains(forwardDecl = "class " + childModel.classname + ";")) continue;
                    forwardDeclarations.add(forwardDecl);
                }
            }
        }
        if (!forwardDeclarations.isEmpty()) {
            parentModel.vendorExtensions.put("x-has-forward-declarations", true);
            parentModel.vendorExtensions.put("x-forward-declarations", forwardDeclarations);
        }
    }
}

