/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractRubyCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubyClientCodegen
extends AbstractRubyCodegen {
    public static final String GEM_VERSION = "gemVersion";
    public static final String GEM_LICENSE = "gemLicense";
    public static final String GEM_REQUIRED_RUBY_VERSION = "gemRequiredRubyVersion";
    public static final String GEM_HOMEPAGE = "gemHomepage";
    public static final String GEM_SUMMARY = "gemSummary";
    public static final String GEM_DESCRIPTION = "gemDescription";
    public static final String GEM_AUTHOR = "gemAuthor";
    public static final String GEM_AUTHOR_EMAIL = "gemAuthorEmail";
    public static final String FARADAY = "faraday";
    public static final String TYPHOEUS = "typhoeus";
    private final Logger LOGGER = LoggerFactory.getLogger(RubyClientCodegen.class);
    private static final String NUMERIC_ENUM_PREFIX = "N";
    protected static int emptyMethodNameCounter = 0;
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String specFolder = "spec";
    protected String libFolder = "lib";
    protected String gemLicense = "unlicense";
    protected String gemRequiredRubyVersion = ">= 1.9";
    protected String gemHomepage = "https://openapitools.org";
    protected String gemSummary = "A Ruby SDK for the REST API";
    protected String gemDescription = "This gem maps to a REST API";
    protected String gemAuthor = "";
    protected String gemAuthorEmail = "";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public RubyClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.ParameterizedServer, GlobalFeature.MultiServer}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separator + "ruby";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "ruby-client";
        this.embeddedTemplateDir = "ruby-client";
        this.modelTestTemplateFiles.put("model_test.mustache", ".rb");
        this.apiTestTemplateFiles.put("api_test.mustache", ".rb");
        this.hideGenerationTimestamp = Boolean.TRUE;
        for (String word : Arrays.asList("local_var_path", "query_params", "header_params", "_header_accept", "_header_accept_result", "_header_content_type", "form_params", "post_body", "auth_names", "send")) {
            this.reservedWords.add(word.toLowerCase(Locale.ROOT));
        }
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.cliOptions.removeIf(opt -> "modelPackage".equals(opt.getOpt()) || "apiPackage".equals(opt.getOpt()));
        this.cliOptions.add(new CliOption("gemName", "gem name (convention: underscore_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("moduleName", "top module name (convention: CamelCase, usually corresponding to gem name).").defaultValue("OpenAPIClient"));
        this.cliOptions.add(new CliOption(GEM_VERSION, "gem version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(GEM_LICENSE, "gem license. ").defaultValue("unlicense"));
        this.cliOptions.add(new CliOption(GEM_REQUIRED_RUBY_VERSION, "gem required Ruby version. ").defaultValue(">= 1.9"));
        this.cliOptions.add(new CliOption(GEM_HOMEPAGE, "gem homepage. ").defaultValue("http://org.openapitools"));
        this.cliOptions.add(new CliOption(GEM_SUMMARY, "gem summary. ").defaultValue("A ruby wrapper for the REST APIs"));
        this.cliOptions.add(new CliOption(GEM_DESCRIPTION, "gem description. ").defaultValue("This gem maps to a REST API"));
        this.cliOptions.add(new CliOption(GEM_AUTHOR, "gem author (only one is supported)."));
        this.cliOptions.add(new CliOption(GEM_AUTHOR_EMAIL, "gem author email (only one is supported)."));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.supportedLibraries.put(FARADAY, "Faraday (https://github.com/lostisland/faraday) (Beta support)");
        this.supportedLibraries.put(TYPHOEUS, "Typhoeus >= 1.0.1 (https://github.com/typhoeus/typhoeus)");
        CliOption libraryOption = new CliOption("library", "HTTP library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(TYPHOEUS);
        this.cliOptions.add(libraryOption);
        this.setLibrary(TYPHOEUS);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("gemName")) {
            this.setGemName((String)this.additionalProperties.get("gemName"));
        }
        if (this.additionalProperties.containsKey("moduleName")) {
            this.setModuleName((String)this.additionalProperties.get("moduleName"));
        }
        if (this.gemName == null && this.moduleName == null) {
            this.setGemName("openapi_client");
            this.setModuleName(this.generateModuleName(this.gemName));
        } else if (this.gemName == null) {
            this.setGemName(this.generateGemName(this.moduleName));
        } else if (this.moduleName == null) {
            this.setModuleName(this.generateModuleName(this.gemName));
        }
        this.additionalProperties.put("gemName", this.gemName);
        this.additionalProperties.put("moduleName", this.moduleName);
        if (this.additionalProperties.containsKey(GEM_VERSION)) {
            this.setGemVersion((String)this.additionalProperties.get(GEM_VERSION));
        } else {
            this.additionalProperties.put(GEM_VERSION, this.gemVersion);
        }
        if (this.additionalProperties.containsKey(GEM_LICENSE)) {
            this.setGemLicense((String)this.additionalProperties.get(GEM_LICENSE));
        }
        if (this.additionalProperties.containsKey(GEM_REQUIRED_RUBY_VERSION)) {
            this.setGemRequiredRubyVersion((String)this.additionalProperties.get(GEM_REQUIRED_RUBY_VERSION));
        }
        if (this.additionalProperties.containsKey(GEM_HOMEPAGE)) {
            this.setGemHomepage((String)this.additionalProperties.get(GEM_HOMEPAGE));
        }
        if (this.additionalProperties.containsKey(GEM_SUMMARY)) {
            this.setGemSummary((String)this.additionalProperties.get(GEM_SUMMARY));
        }
        if (this.additionalProperties.containsKey(GEM_DESCRIPTION)) {
            this.setGemDescription((String)this.additionalProperties.get(GEM_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(GEM_AUTHOR)) {
            this.setGemAuthor((String)this.additionalProperties.get(GEM_AUTHOR));
        }
        if (this.additionalProperties.containsKey(GEM_AUTHOR_EMAIL)) {
            this.setGemAuthorEmail((String)this.additionalProperties.get(GEM_AUTHOR_EMAIL));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.setModelPackage("models");
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("gem.mustache", this.libFolder, this.gemName + ".rb"));
        String gemFolder = this.libFolder + File.separator + this.gemName;
        this.supportingFiles.add(new SupportingFile("api_error.mustache", gemFolder, "api_error.rb"));
        this.supportingFiles.add(new SupportingFile("version.mustache", gemFolder, "version.rb"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("Rakefile.mustache", "", "Rakefile"));
        this.supportingFiles.add(new SupportingFile("Gemfile.mustache", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("rubocop.mustache", "", ".rubocop.yml"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("gemspec.mustache", "", this.gemName + ".gemspec"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", gemFolder, "configuration.rb"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", gemFolder, "api_client.rb"));
        if (!TYPHOEUS.equals(this.getLibrary())) {
            if (FARADAY.equals(this.getLibrary())) {
                this.additionalProperties.put("isFaraday", Boolean.TRUE);
            } else {
                throw new RuntimeException("Invalid HTTP library " + this.getLibrary() + ". Only faraday, typhoeus are supported.");
            }
        }
        this.supportingFiles.add(new SupportingFile("rspec.mustache", "", ".rspec").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("spec_helper.mustache", this.specFolder, "spec_helper.rb").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("configuration_spec.mustache", this.specFolder, "configuration_spec.rb").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("api_client_spec.mustache", this.specFolder, "api_client_spec.rb").doNotOverwrite());
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ruby";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby client library.";
    }

    public String generateModuleName(String gemName) {
        return StringUtils.camelize(gemName.replaceAll("[^\\w]+", "_"));
    }

    public String generateGemName(String moduleName) {
        return StringUtils.underscore(moduleName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String name) {
        String modelName = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            modelName = this.modelNamePrefix + "_" + modelName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            modelName = modelName + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(modelName)) {
            modelName = StringUtils.camelize("Model" + modelName);
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        if (modelName.matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)modelName, (Object)StringUtils.camelize("model_" + modelName));
            modelName = "model_" + modelName;
        }
        return StringUtils.camelize(modelName);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        String filename = name;
        if (this.apiNameSuffix != null && this.apiNameSuffix.length() > 0) {
            filename = filename + "_" + this.apiNameSuffix;
        }
        filename = filename.replaceAll("-", "_");
        return StringUtils.underscore(filename);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(name);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return NUMERIC_ENUM_PREFIX + varName;
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return NUMERIC_ENUM_PREFIX + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return NUMERIC_ENUM_PREFIX + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = StringUtils.underscore("empty_method_name_" + emptyMethodNameCounter++);
            this.LOGGER.warn("Empty method name (operationId) found. Renamed to {}", (Object)operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.underscore("call_" + operationId);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String toApiImport(String name) {
        return this.gemName + "/" + this.apiPackage() + "/" + this.toApiFilename(name);
    }

    public void setGemName(String gemName) {
        this.gemName = gemName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setGemVersion(String gemVersion) {
        this.gemVersion = gemVersion;
    }

    public void setGemDescription(String gemDescription) {
        this.gemDescription = gemDescription;
    }

    public void setGemSummary(String gemSummary) {
        this.gemSummary = gemSummary;
    }

    public void setGemLicense(String gemLicense) {
        this.gemLicense = gemLicense;
    }

    public void setGemRequiredRubyVersion(String gemRequiredRubyVersion) {
        this.gemRequiredRubyVersion = gemRequiredRubyVersion;
    }

    public void setGemHomepage(String gemHomepage) {
        this.gemHomepage = gemHomepage;
    }

    public void setGemAuthor(String gemAuthor) {
        this.gemAuthor = gemAuthor;
    }

    public void setGemAuthorEmail(String gemAuthorEmail) {
        this.gemAuthorEmail = gemAuthorEmail;
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = this.getAdditionalProperties(schema);
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        HashMap<String, Integer> processedModelMaps = new HashMap<String, Integer>();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            modelMaps.put(m.classname, m);
        }
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-ruby-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.requiredParams) {
                p.vendorExtensions.put("x-ruby-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.optionalParams) {
                p.vendorExtensions.put("x-ruby-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.bodyParams) {
                p.vendorExtensions.put("x-ruby-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
            for (CodegenParameter p : op.pathParams) {
                p.vendorExtensions.put("x-ruby-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
        }
        return objs;
    }

    private String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenParameter.isArray) {
            return "[" + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + "]";
        }
        if (codegenParameter.isMap) {
            return "{ key: " + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + "}";
        }
        if (codegenParameter.isPrimitiveType) {
            if (codegenParameter.isEnum) {
                List values = (List)codegenParameter.allowableValues.get("values");
                codegenParameter.example = String.valueOf(values.get(0));
            }
            if (codegenParameter.isString || "String".equalsIgnoreCase(codegenParameter.baseType)) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "'" + codegenParameter.example + "'";
                }
                return "'" + codegenParameter.paramName + "_example'";
            }
            if (codegenParameter.isBoolean) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenParameter.isUri) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "'" + codegenParameter.example + "'";
                }
                return "'https://example.com'";
            }
            if (codegenParameter.isDateTime) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "Time.parse('" + codegenParameter.example + "')";
                }
                return "Time.now";
            }
            if (codegenParameter.isDate) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "Date.parse('" + codegenParameter.example + "')";
                }
                return "Date.today";
            }
            if (codegenParameter.isFile) {
                return "File.new('/path/to/some/file')";
            }
            if (codegenParameter.isInteger) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return codegenParameter.example;
                }
                return "37";
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                return codegenParameter.example;
            }
            return "3.56";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    private String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenProperty.isArray) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                String value = codegenProperty.example;
                value = value.replaceAll(",", ", ");
                value = value.replaceAll(":", ": ");
                return value;
            }
            return "[" + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + "]";
        }
        if (codegenProperty.isMap) {
            return "{ key: " + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + "}";
        }
        if (codegenProperty.isPrimitiveType) {
            if (codegenProperty.isEnum) {
                List values = (List)codegenProperty.allowableValues.get("values");
                codegenProperty.example = String.valueOf(values.get(0));
            }
            if (codegenProperty.isString || "String".equalsIgnoreCase(codegenProperty.baseType)) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "'" + codegenProperty.example + "'";
                }
                return "'" + codegenProperty.name + "_example'";
            }
            if (codegenProperty.isBoolean) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenProperty.isUri) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "'" + codegenProperty.example + "'";
                }
                return "'https://example.com'";
            }
            if (codegenProperty.isDateTime) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "Time.parse('" + codegenProperty.example + "')";
                }
                return "Time.now";
            }
            if (codegenProperty.isDate) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "Date.parse('" + codegenProperty.example + "')";
                }
                return "Date.today";
            }
            if (codegenProperty.isFile) {
                return "File.new('/path/to/some/file')";
            }
            if (codegenProperty.isInteger) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return codegenProperty.example;
                }
                return "37";
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                return codegenProperty.example;
            }
            return "3.56";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        String model;
        block7: {
            model = codegenModel.name;
            if (processedModelMap.containsKey(model)) {
                int count = processedModelMap.get(model);
                if (count == 1) {
                    processedModelMap.put(model, 2);
                    break block7;
                } else {
                    if (count != 2) throw new RuntimeException("Invalid count when constructing example: " + count);
                    return "";
                }
            }
            if (codegenModel.isEnum) {
                List enumVars = (List)codegenModel.allowableValues.get("enumVars");
                return this.moduleName + "::" + codegenModel.classname + "::" + (String)((Map)enumVars.get(0)).get("name");
            }
            if (codegenModel.oneOf != null && !codegenModel.oneOf.isEmpty()) {
                String subModel = (String)codegenModel.oneOf.toArray()[0];
                if (modelMaps.containsKey(subModel)) {
                    return this.constructExampleCode(modelMaps.get(subModel), modelMaps, processedModelMap);
                }
                this.LOGGER.warn("oneOf example value not supported at the moment.");
                return "nil";
            }
            processedModelMap.put(model, 1);
        }
        ArrayList<String> propertyExamples = new ArrayList<String>();
        for (CodegenProperty codegenProperty : codegenModel.requiredVars) {
            propertyExamples.add(codegenProperty.name + ": " + this.constructExampleCode(codegenProperty, modelMaps, processedModelMap));
        }
        String example = this.moduleName + "::" + this.toModelName(model) + ".new";
        if (propertyExamples.isEmpty()) return example;
        return example + "({" + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)", ") + "})";
    }
}

