/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.google.common.collect.Sets;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(TypeScriptClientCodegen.class);
    private static final String X_DISCRIMINATOR_TYPE = "x-discriminator-value";
    private static final String UNDEFINED_VALUE = "undefined";
    private static final String FRAMEWORK_SWITCH = "framework";
    private static final String FRAMEWORK_SWITCH_DESC = "Specify the framework which should be used in the client code.";
    private static final String[] FRAMEWORKS = new String[]{"fetch-api", "jquery"};
    private static final String PLATFORM_SWITCH = "platform";
    private static final String PLATFORM_SWITCH_DESC = "Specifies the platform the code should run on. The default is 'node' for the 'request' framework and 'browser' otherwise.";
    private static final String[] PLATFORMS = new String[]{"browser", "node", "deno"};
    private static final String FILE_CONTENT_DATA_TYPE = "fileContentDataType";
    private static final String FILE_CONTENT_DATA_TYPE_DESC = "Specifies the type to use for the content of a file - i.e. Blob (Browser, Deno) / Buffer (node)";
    private static final String USE_RXJS_SWITCH = "useRxJS";
    private static final String USE_RXJS_SWITCH_DESC = "Enable this to internally use rxjs observables. If disabled, a stub is used instead. This is required for the 'angular' framework.";
    private static final String USE_INVERSIFY_SWITCH = "useInversify";
    private static final String USE_INVERSIFY_SWITCH_DESC = "Enable this to generate decorators and service identifiers for the InversifyJS inversion of control container. If you set 'deno' as 'platform', the generator will process this value as 'disable'.";
    private static final String USE_OBJECT_PARAMS_SWITCH = "useObjectParameters";
    private static final String USE_OBJECT_PARAMS_DESC = "Use aggregate parameter objects as function arguments for api operations instead of passing each parameter as a separate function argument.";
    private final Map<String, String> frameworkToHttpLibMap;
    private static final String SNAPSHOT = "snapshot";
    protected static final ThreadLocal<SimpleDateFormat> SNAPSHOT_SUFFIX_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT));
    private static final String NPM_REPOSITORY = "npmRepository";
    private static final String NPM_NAME = "npmName";
    private static final String NPM_VERSION = "npmVersion";
    protected String npmRepository = null;
    protected String snapshot = null;
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String modelPropertyNaming = "camelCase";
    protected HashSet<String> languageGenericTypes;
    private DateTimeFormatter iso8601Date = DateTimeFormatter.ISO_DATE;
    private DateTimeFormatter iso8601DateTime = DateTimeFormatter.ISO_DATE_TIME;

    public TypeScriptClientCodegen() {
        this.frameworkToHttpLibMap = new HashMap<String, String>();
        this.frameworkToHttpLibMap.put("fetch-api", "isomorphic-fetch");
        this.frameworkToHttpLibMap.put("jquery", "jquery");
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + "typescript";
        this.templateDir = "typescript";
        this.embeddedTemplateDir = "typescript";
        this.supportsInheritance = true;
        this.reservedWords.addAll(Arrays.asList("varLocalPath", "queryParameters", "headerParams", "formParams", "useFormData", "varLocalDeferred", "requestOptions", "from", "abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "Array", "Date", "number", "any", "File", "Error", "Map"));
        this.languageGenericTypes = new HashSet<String>(Arrays.asList("Array"));
        this.instantiationTypes.put("array", "Array");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "any");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("Map", "any");
        this.typeMapping.put("map", "any");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("binary", "any");
        this.typeMapping.put("File", "any");
        this.typeMapping.put("file", "any");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("Error", "Error");
        this.typeMapping.put("AnyType", "any");
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package. Required to generate a full package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package. If not provided, using the version from the OpenAPI specification file.").defaultValue(this.getNpmVersion()));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(CliOption.newBoolean(SNAPSHOT, "When setting this property to true, the version will be suffixed with -SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.get().toPattern(), false));
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue("camelCase"));
        this.cliOptions.add(new CliOption("supportsES6", "Generate code that conforms to ES6.").defaultValue("false"));
        this.cliOptions.add(new CliOption(FILE_CONTENT_DATA_TYPE, FILE_CONTENT_DATA_TYPE_DESC).defaultValue("Buffer"));
        this.cliOptions.add(new CliOption(USE_RXJS_SWITCH, USE_RXJS_SWITCH_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(USE_OBJECT_PARAMS_SWITCH, USE_OBJECT_PARAMS_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(USE_INVERSIFY_SWITCH, USE_INVERSIFY_SWITCH_DESC).defaultValue("false"));
        CliOption frameworkOption = new CliOption(FRAMEWORK_SWITCH, FRAMEWORK_SWITCH_DESC);
        for (String option : FRAMEWORKS) {
            frameworkOption.addEnum(option, option);
        }
        frameworkOption.defaultValue(FRAMEWORKS[0]);
        this.cliOptions.add(frameworkOption);
        CliOption platformOption = new CliOption(PLATFORM_SWITCH, PLATFORM_SWITCH_DESC);
        for (String option : PLATFORMS) {
            platformOption.addEnum(option, option);
        }
        platformOption.defaultValue(PLATFORMS[0]);
        this.cliOptions.add(platformOption);
        this.supportingFiles.add(new SupportingFile(".gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("util.mustache", "", "util.ts"));
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "exception.mustache", "apis", "exception.ts"));
        this.supportingFiles.add(new SupportingFile("http" + File.separator + "http.mustache", "http", "http.ts"));
        this.supportingFiles.add(new SupportingFile("http" + File.separator + "servers.mustache", "servers.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("auth" + File.separator + "auth.mustache", "auth", "auth.ts"));
        this.supportingFiles.add(new SupportingFile("model" + File.separator + "models_all.mustache", "models", "all.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "PromiseAPI.mustache", "types", "PromiseAPI.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "ObservableAPI.mustache", "types", "ObservableAPI.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "ObjectParamAPI.mustache", "types", "ObjectParamAPI.ts"));
        this.setModelPackage("");
        this.supportingFiles.add(new SupportingFile("model" + File.separator + "ObjectSerializer.mustache", "models", "ObjectSerializer.ts"));
        this.modelTemplateFiles.put("model" + File.separator + "model.mustache", ".ts");
        this.setApiPackage("");
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "middleware.mustache", "", "middleware.ts"));
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "baseapi.mustache", "apis", "baseapi.ts"));
        this.apiTemplateFiles.put("api" + File.separator + "api.mustache", ".ts");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            if (this.additionalProperties.containsKey(NPM_VERSION)) {
                this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
            } else if (openAPI.getInfo() != null && openAPI.getInfo().getVersion() != null) {
                this.setNpmVersion(openAPI.getInfo().getVersion());
            }
            if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.parseBoolean(this.additionalProperties.get(SNAPSHOT).toString())) {
                if (this.npmVersion.toUpperCase(Locale.ROOT).matches("^.*-SNAPSHOT$")) {
                    this.setNpmVersion(this.npmVersion + "." + SNAPSHOT_SUFFIX_FORMAT.get().format(new Date()));
                } else {
                    this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.get().format(new Date()));
                }
            }
            this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Object propFramework = this.additionalProperties.get(FRAMEWORK_SWITCH);
        HashMap<String, Boolean> frameworks = new HashMap<String, Boolean>();
        for (String framework : FRAMEWORKS) {
            frameworks.put(framework, framework.equals(propFramework));
        }
        objs.put(FRAMEWORK_SWITCH, propFramework);
        objs.put("frameworks", frameworks);
        objs.put(FILE_CONTENT_DATA_TYPE, this.additionalProperties.get(FILE_CONTENT_DATA_TYPE));
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> models) {
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", ((String)im.get("import")).replace(".", "/"));
            im.put("classname", this.getModelnameFromModelFilename(im.get("import").toString()));
        }
        Map operationsMap = (Map)operations.get("operations");
        List operationList = (List)operationsMap.get("operation");
        for (CodegenOperation operation : operationList) {
            List<CodegenResponse> responses = operation.responses;
            operation.returnType = this.getReturnType(responses);
        }
        return operations;
    }

    private String getReturnType(List<CodegenResponse> responses) {
        HashSet<String> returnTypes = new HashSet<String>();
        for (CodegenResponse response : responses) {
            if (!response.is2xx) continue;
            if (response.dataType != null) {
                returnTypes.add(response.dataType);
                continue;
            }
            returnTypes.add("void");
        }
        if (returnTypes.size() == 0) {
            return null;
        }
        return String.join((CharSequence)" | ", returnTypes);
    }

    private String getModelnameFromModelFilename(String filename) {
        String name = filename.substring((this.modelPackage() + File.separator).length());
        return StringUtils.camelize(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        String fullModelName = name;
        fullModelName = this.addPrefix(fullModelName, this.modelNamePrefix);
        fullModelName = this.addSuffix(fullModelName, this.modelNameSuffix);
        return this.toTypescriptTypeName(fullModelName, "Model");
    }

    protected String addPrefix(String name, String prefix) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix)) {
            name = prefix + "_" + name;
        }
        return name;
    }

    protected String addSuffix(String name, String suffix) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)suffix)) {
            name = name + "_" + suffix;
        }
        return name;
    }

    protected String toTypescriptTypeName(String name, String safePrefix) {
        ArrayList<String> exceptions = new ArrayList<String>(Arrays.asList("\\|", " "));
        String sanName = this.sanitizeName(name, "(?![| ])\\W", exceptions);
        if (this.isReservedWord(sanName = StringUtils.camelize(sanName))) {
            String modelName = safePrefix + sanName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)sanName, (Object)modelName);
            return modelName;
        }
        if (sanName.matches("^\\d.*")) {
            String modelName = safePrefix + sanName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)sanName, (Object)modelName);
            return modelName;
        }
        if (this.languageSpecificPrimitives.contains(sanName)) {
            String modelName = safePrefix + sanName;
            this.LOGGER.warn("{} (model name matches existing language type) cannot be used as a model name. Renamed to {}", (Object)sanName, (Object)modelName);
            return modelName;
        }
        return sanName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    protected String getParameterDataType(Parameter parameter, Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema mp1 = (ArraySchema)p;
            Schema inner = mp1.getItems();
            return this.getSchemaType(p) + "<" + this.getParameterDataType(parameter, inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "{ [key: string]: " + this.getParameterDataType(parameter, inner) + "; }";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getEnum() != null) {
                return this.enumValuesToEnumTypeUnion(p.getEnum(), "string");
            }
        } else if (ModelUtils.isIntegerSchema(p) ? p.getEnum() != null : ModelUtils.isNumberSchema(p) && p.getEnum() != null) {
            return this.numericEnumValuesToEnumTypeUnion(new ArrayList<Number>(p.getEnum()));
        }
        return this.getTypeDeclaration(p);
    }

    protected String enumValuesToEnumTypeUnion(List<String> values, String dataType) {
        StringBuilder b = new StringBuilder();
        boolean isFirst = true;
        for (String value : values) {
            if (!isFirst) {
                b.append(" | ");
            }
            b.append(this.toEnumValue(value.toString(), dataType));
            isFirst = false;
        }
        return b.toString();
    }

    protected String numericEnumValuesToEnumTypeUnion(List<Number> values) {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Number value : values) {
            stringValues.add(value.toString());
        }
        return this.enumValuesToEnumTypeUnion(stringValues, "number");
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isDateSchema(p)) {
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "'" + (String)p.getDefault() + "'";
            }
            return UNDEFINED_VALUE;
        }
        return UNDEFINED_VALUE;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (ModelUtils.isComposedSchema(p)) {
            return openAPIType;
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            return this.escapeReservedWord(StringUtils.camelize(this.sanitizeName(operationId), true));
        }
        return StringUtils.camelize(this.sanitizeName(operationId), true);
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(this.getSymbolName(name));
        }
        if ("number".equals(datatype)) {
            String varName = "NUMBER_" + name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = StringUtils.camelize(enumName)).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name) + "Enum";
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        for (Map mo : models) {
            CodegenModel cm = (CodegenModel)mo.get("model");
            mo.put("tsImports", this.toTsImports(cm, cm.imports));
        }
        return objs;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(im));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (cm.discriminator == null || cm.children == null) continue;
                for (CodegenModel child : cm.children) {
                    this.setDiscriminatorValue(child, cm.discriminator.getPropertyName(), this.getDiscriminatorValue(child));
                }
            }
        }
        return result;
    }

    private void setDiscriminatorValue(CodegenModel model, String baseName, String value) {
        for (CodegenProperty prop : model.allVars) {
            if (!prop.baseName.equals(baseName)) continue;
            prop.discriminatorValue = value;
        }
        if (model.children != null) {
            boolean newDiscriminator = model.discriminator != null;
            for (CodegenModel child : model.children) {
                this.setDiscriminatorValue(child, baseName, newDiscriminator ? value : this.getDiscriminatorValue(child));
            }
        }
    }

    private String getDiscriminatorValue(CodegenModel model) {
        return model.vendorExtensions.containsKey(X_DISCRIMINATOR_TYPE) ? (String)model.vendorExtensions.get(X_DISCRIMINATOR_TYPE) : model.classname;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String getName() {
        return "typescript";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using Fetch API (beta).";
    }

    @Override
    public void processOpts() {
        boolean useInversify;
        boolean useRxJS;
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        this.convertPropertyToBooleanAndWriteBack("supportsES6");
        this.apiPackage = this.apiPackage + ".apis";
        this.modelPackage = this.modelPackage + ".models";
        this.testPackage = this.testPackage + ".tests";
        this.additionalProperties.putIfAbsent(FRAMEWORK_SWITCH, FRAMEWORKS[0]);
        this.supportingFiles.add(new SupportingFile("index.mustache", "index.ts"));
        String httpLibName = this.getHttpLibForFramework(this.additionalProperties.get(FRAMEWORK_SWITCH).toString());
        this.supportingFiles.add(new SupportingFile("http" + File.separator + httpLibName + ".mustache", "http", httpLibName + ".ts"));
        Object propPlatform = this.additionalProperties.get(PLATFORM_SWITCH);
        if (propPlatform == null) {
            propPlatform = "browser";
            this.additionalProperties.put(PLATFORM_SWITCH, propPlatform);
        }
        HashMap<String, Boolean> platforms = new HashMap<String, Boolean>();
        for (String platform : PLATFORMS) {
            platforms.put(platform, platform.equals(propPlatform));
        }
        this.additionalProperties.put("platforms", platforms);
        this.additionalProperties.putIfAbsent(FILE_CONTENT_DATA_TYPE, "node".equals(propPlatform) ? "Buffer" : "Blob");
        if (!"deno".equals(propPlatform)) {
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
            this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        }
        if ("deno".equals(propPlatform)) {
            this.additionalProperties.put("extensionForDeno", ".ts");
        }
        if (!(useRxJS = this.convertPropertyToBooleanAndWriteBack(USE_RXJS_SWITCH))) {
            this.supportingFiles.add(new SupportingFile("rxjsStub.mustache", "rxjsStub.ts"));
        }
        if (useInversify = this.convertPropertyToBooleanAndWriteBack(USE_INVERSIFY_SWITCH)) {
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "index.mustache", "services", "index.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "configuration.mustache", "services", "configuration.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "PromiseAPI.mustache", "services", "PromiseAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "ObservableAPI.mustache", "services", "ObservableAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "ObjectParamAPI.mustache", "services", "ObjectParamAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "http.mustache", "services", "http.ts"));
            this.apiTemplateFiles.put("services" + File.separator + "api.mustache", ".service.ts");
        }
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
    }

    private String getHttpLibForFramework(String object) {
        return this.frameworkToHttpLibMap.get(object);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema inner = ((ArraySchema)p).getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(ModelUtils.unaliasSchema(this.openAPI, inner)) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "{ [key: string]: " + this.getTypeDeclaration(ModelUtils.unaliasSchema(this.openAPI, inner)) + "; }";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "HttpFile";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "any";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)schema.getAdditionalProperties());
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    public String typescriptDate(Object dateValue) {
        String strValue = null;
        if (dateValue instanceof OffsetDateTime) {
            OffsetDateTime date = null;
            try {
                date = (OffsetDateTime)dateValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date` format for value {}", dateValue);
                date = ((Date)dateValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = date.format(this.iso8601Date);
        } else {
            strValue = dateValue.toString();
        }
        return "new Date('" + strValue + "').toISOString().split('T')[0];";
    }

    public String typescriptDateTime(Object dateTimeValue) {
        String strValue = null;
        if (dateTimeValue instanceof OffsetDateTime) {
            OffsetDateTime dateTime = null;
            try {
                dateTime = (OffsetDateTime)dateTimeValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date-time` format for value {}", dateTimeValue);
                dateTime = ((Date)dateTimeValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = dateTime.format(this.iso8601DateTime);
        } else {
            strValue = dateTimeValue.toString();
        }
        return "new Date('" + strValue + "')";
    }

    public String getModelName(Schema sc) {
        Schema unaliasedSchema;
        if (sc.get$ref() != null && (unaliasedSchema = this.unaliasSchema(sc, this.importMapping)).get$ref() != null) {
            return this.toModelName(ModelUtils.getSimpleRef(sc.get$ref()));
        }
        return null;
    }

    protected Object getObjectExample(Schema sc) {
        Boolean objectModel;
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((objectModel = Boolean.valueOf(ModelUtils.isObjectSchema(schema) || ModelUtils.isMapSchema(schema) || ModelUtils.isComposedSchema(schema))).booleanValue()) {
            return null;
        }
        if (schema.getExample() != null) {
            return schema.getExample();
        }
        if (schema.getDefault() != null) {
            return schema.getDefault();
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return schema.getEnum().get(0);
        }
        return null;
    }

    private String ensureQuotes(String in) {
        Pattern pattern = Pattern.compile("\r\n|\r|\n");
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            return "`" + in + "`";
        }
        String strPattern = "^['\"].*?['\"]$";
        if (in.matches(strPattern)) {
            return in;
        }
        return "\"" + in + "\"";
    }

    @Override
    public String toExampleValue(Schema schema) {
        Object objExample = this.getObjectExample(schema);
        return this.toExampleValue(schema, objExample);
    }

    public String toExampleValue(Schema schema, Object objExample) {
        String modelName = this.getModelName(schema);
        return this.toExampleValueRecursive(modelName, schema, objExample, 1, "", 0, Sets.newHashSet());
    }

    private Boolean simpleStringSchema(Schema schema) {
        Schema sc = schema;
        String ref = schema.get$ref();
        if (ref != null) {
            sc = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        return ModelUtils.isStringSchema(sc) && !ModelUtils.isDateSchema(sc) && !ModelUtils.isDateTimeSchema(sc) && !"Number".equalsIgnoreCase(sc.getFormat()) && !ModelUtils.isByteArraySchema(sc) && !ModelUtils.isBinarySchema(sc) && schema.getPattern() == null;
    }

    private CodegenDiscriminator.MappedModel getDiscriminatorMappedModel(CodegenDiscriminator disc) {
        for (CodegenDiscriminator.MappedModel mm : disc.getMappedModels()) {
            String modelName = mm.getModelName();
            Schema modelSchema = this.getModelNameToSchemaCache().get(modelName);
            if (!ModelUtils.isObjectSchema(modelSchema)) continue;
            return mm;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toExampleValueRecursive(String modelName, Schema schema, Object objExample, int indentationLevel, String prefix, Integer exampleLine, Set<Schema> seenSchemas) {
        String indentionConst = "  ";
        String currentIndentation = "";
        String closingIndentation = "";
        for (int i = 0; i < indentationLevel; ++i) {
            currentIndentation = currentIndentation + "  ";
        }
        if (exampleLine.equals(0)) {
            closingIndentation = currentIndentation;
            currentIndentation = "";
        } else {
            closingIndentation = currentIndentation;
        }
        String openChars = "";
        String closeChars = "";
        String fullPrefix = currentIndentation + prefix + openChars;
        String example = null;
        if (objExample != null) {
            example = objExample.toString();
        }
        if (seenSchemas.contains(schema)) {
            if (modelName != null) {
                return fullPrefix + closeChars;
            }
            if (ModelUtils.isNullable(schema)) {
                return fullPrefix + "null" + closeChars;
            }
            if (!ModelUtils.isArraySchema(schema)) return fullPrefix + "{}" + closeChars;
            return fullPrefix + "[]" + closeChars;
        }
        if (null != schema.get$ref()) {
            String ref;
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            Schema refSchema = allDefinitions.get(ref = ModelUtils.getSimpleRef(schema.get$ref()));
            if (null == refSchema) {
                this.LOGGER.warn("Unable to find referenced schema " + schema.get$ref() + "\n");
                return fullPrefix + "null" + closeChars;
            }
            String refModelName = this.getModelName(schema);
            return this.toExampleValueRecursive(refModelName, refSchema, objExample, indentationLevel, prefix, exampleLine, seenSchemas);
        }
        if (ModelUtils.isNullType(schema)) return fullPrefix + "null" + closeChars;
        if (ModelUtils.isAnyType(schema)) {
            return fullPrefix + "null" + closeChars;
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            example = objExample == null ? "true" : ("false".equalsIgnoreCase(objExample.toString()) ? "false" : "true");
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = objExample == null ? this.typescriptDate("1970-01-01") : this.typescriptDate(objExample);
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = objExample == null ? this.typescriptDateTime("1970-01-01T00:00:00.00Z") : this.typescriptDateTime(objExample);
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            if (objExample == null) {
                example = "/path/to/file";
            }
            example = "{ data: Buffer.from(fs.readFileSync('" + example + "', 'utf-8')), name: '" + example + "' }";
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            if (objExample != null) return fullPrefix + example + closeChars;
            example = "'YQ=='";
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (objExample != null) return fullPrefix + this.ensureQuotes(example) + closeChars;
            if ("Number".equalsIgnoreCase(schema.getFormat())) {
                example = "2";
                return fullPrefix + example + closeChars;
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                String pattern = schema.getPattern();
                Pattern valueExtractor = Pattern.compile("^/?(.+?)/?(.?)$");
                Matcher m = valueExtractor.matcher(pattern);
                RgxGen rgxGen = null;
                if (m.find()) {
                    int groupCount = m.groupCount();
                    if (groupCount == 1) {
                        String isolatedPattern = m.group(1);
                        rgxGen = new RgxGen((CharSequence)isolatedPattern);
                    } else if (groupCount == 2) {
                        String isolatedPattern = m.group(1);
                        String flags = m.group(2);
                        if (flags.contains("i")) {
                            rgxGen = new RgxGen((CharSequence)isolatedPattern);
                            RgxGenProperties properties = new RgxGenProperties();
                            RgxGenOption.CASE_INSENSITIVE.setInProperties(properties, (Object)true);
                            rgxGen.setProperties(properties);
                        } else {
                            rgxGen = new RgxGen((CharSequence)isolatedPattern);
                        }
                    }
                } else {
                    rgxGen = new RgxGen((CharSequence)pattern);
                }
                Random random = new Random(18L);
                if (rgxGen == null) throw new RuntimeException("rgxGen cannot be null. Please open an issue in the openapi-generator github repo.");
                example = rgxGen.generate(random);
                return fullPrefix + this.ensureQuotes(example) + closeChars;
            } else {
                if (schema.getMinLength() != null) {
                    example = "";
                    int len = schema.getMinLength();
                    int i = 0;
                    while (i < len) {
                        example = example + "a";
                        ++i;
                    }
                    return fullPrefix + this.ensureQuotes(example) + closeChars;
                }
                example = ModelUtils.isUUIDSchema(schema) ? "046b6c7f-0b8a-43b9-b35d-6489e6daee91" : "string_example";
            }
            return fullPrefix + this.ensureQuotes(example) + closeChars;
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (objExample != null) return fullPrefix + example + closeChars;
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1";
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (objExample != null) return fullPrefix + example + closeChars;
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "3.14";
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arrayschema = (ArraySchema)schema;
            Schema itemSchema = arrayschema.getItems();
            String itemModelName = this.getModelName(itemSchema);
            if (objExample instanceof Iterable && itemModelName == null) {
                return fullPrefix + objExample.toString() + closeChars;
            }
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            return fullPrefix + "[\n" + this.toExampleValueRecursive(itemModelName, itemSchema, objExample, indentationLevel + 1, "", exampleLine + 1, newSeenSchemas) + ",\n" + closingIndentation + "]" + closeChars;
        }
        if (ModelUtils.isMapSchema(schema)) {
            Object addPropsObj;
            if (modelName == null) {
                fullPrefix = fullPrefix + "{";
                closeChars = "}";
            }
            if (!((addPropsObj = schema.getAdditionalProperties()) instanceof Schema)) return fullPrefix + closeChars;
            Schema addPropsSchema = (Schema)addPropsObj;
            String key = "key";
            Object addPropsExample = this.getObjectExample(addPropsSchema);
            if (addPropsSchema.getEnum() != null && !addPropsSchema.getEnum().isEmpty()) {
                key = addPropsSchema.getEnum().get(0).toString();
            }
            addPropsExample = this.exampleFromStringOrArraySchema(addPropsSchema, addPropsExample, key);
            String addPropPrefix = key + ": ";
            if (modelName == null) {
                addPropPrefix = this.ensureQuotes(key) + ": ";
            }
            String addPropsModelName = "\"" + this.getModelName(addPropsSchema) + "\"";
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            return fullPrefix + "\n" + this.toExampleValueRecursive(addPropsModelName, addPropsSchema, addPropsExample, indentationLevel + 1, addPropPrefix, exampleLine + 1, newSeenSchemas) + ",\n" + closingIndentation + closeChars;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            ComposedSchema cm = (ComposedSchema)schema;
            List ls = cm.getOneOf();
            if (ls == null) return fullPrefix + closeChars;
            if (ls.isEmpty()) return fullPrefix + closeChars;
            return fullPrefix + this.toExampleValue((Schema)ls.get(0)) + closeChars;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            fullPrefix = fullPrefix + "{";
            closeChars = "}";
            CodegenDiscriminator disc = this.createDiscriminator(modelName, schema, this.openAPI);
            if (disc != null) {
                CodegenDiscriminator.MappedModel mm = this.getDiscriminatorMappedModel(disc);
                if (mm == null) return fullPrefix + closeChars;
                String discPropNameValue = mm.getMappingName();
                String string = mm.getModelName();
            }
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            return this.exampleForObjectModel(schema, fullPrefix, closeChars, null, indentationLevel, exampleLine, closingIndentation, newSeenSchemas);
        }
        this.LOGGER.warn("Type " + schema.getType() + " not handled properly in toExampleValue");
        return example;
    }

    private String exampleForObjectModel(Schema schema, String fullPrefix, String closeChars, CodegenProperty discProp, int indentationLevel, int exampleLine, String closingIndentation, Set<Schema> seenSchemas) {
        Map requiredAndOptionalProps = schema.getProperties();
        if (requiredAndOptionalProps == null || requiredAndOptionalProps.isEmpty()) {
            return fullPrefix + closeChars;
        }
        String example = fullPrefix + "\n";
        for (Map.Entry entry : requiredAndOptionalProps.entrySet()) {
            String propName = (String)entry.getKey();
            Schema propSchema = (Schema)entry.getValue();
            boolean readOnly = false;
            if (propSchema.getReadOnly() != null) {
                readOnly = propSchema.getReadOnly();
            }
            if (readOnly) continue;
            String ref = propSchema.get$ref();
            if (ref != null) {
                Schema refSchema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
                if (refSchema.getReadOnly() != null) {
                    readOnly = refSchema.getReadOnly();
                }
                if (readOnly) continue;
            }
            propName = this.toVarName(propName);
            String propModelName = null;
            Object propExample = null;
            if (discProp != null && propName.equals(discProp.name)) {
                propModelName = null;
                propExample = discProp.example;
            } else {
                propModelName = this.getModelName(propSchema);
                propExample = this.exampleFromStringOrArraySchema(propSchema, null, propName);
            }
            example = example + this.toExampleValueRecursive(propModelName, propSchema, propExample, indentationLevel + 1, propName + ": ", exampleLine + 1, seenSchemas) + ",\n";
        }
        example = example + closingIndentation + closeChars;
        return example;
    }

    private Object exampleFromStringOrArraySchema(Schema sc, Object currentExample, String propName) {
        Object example;
        if (currentExample != null) {
            return currentExample;
        }
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((example = this.getObjectExample(schema)) != null) {
            return example;
        }
        if (this.simpleStringSchema(schema).booleanValue()) {
            return propName + "_example";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema itemSchema = arraySchema.getItems();
            example = this.getObjectExample(itemSchema);
            if (example != null) {
                return example;
            }
            if (this.simpleStringSchema(itemSchema).booleanValue()) {
                return propName + "_example";
            }
        }
        return null;
    }

    protected String setPropertyExampleValue(CodegenProperty p) {
        if (p == null) {
            return "null";
        }
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (Boolean.TRUE.equals(p.isInteger)) {
            if (example == null) {
                example = "56";
            }
        } else if (Boolean.TRUE.equals(p.isLong)) {
            if (example == null) {
                example = "789";
            }
        } else if (Boolean.TRUE.equals(p.isDouble) || Boolean.TRUE.equals(p.isFloat) || Boolean.TRUE.equals(p.isNumber)) {
            if (example == null) {
                example = "3.4";
            }
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            if (example == null) {
                example = "true";
            }
        } else if (Boolean.TRUE.equals(p.isFile) || Boolean.TRUE.equals(p.isBinary)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new Date(\"" + this.escapeText(example) + "\")";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new Date(\"" + this.escapeText(example) + "\")";
        } else if (Boolean.TRUE.equals(p.isString)) {
            if (example == null) {
                example = p.name + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new {{moduleName}}." + type + "()";
        }
        return example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        String finalExample;
        Schema schema = parameter.getSchema();
        if (schema == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because parameter lacks a schema");
            return;
        }
        Object example = null;
        example = codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example") ? codegenParameter.vendorExtensions.get("x-example") : (parameter.getExample() != null ? parameter.getExample() : (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && ((Example)parameter.getExamples().values().iterator().next()).getValue() != null ? ((Example)parameter.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema)));
        example = this.exampleFromStringOrArraySchema(schema, example, parameter.getName());
        codegenParameter.example = finalExample = this.toExampleValue(schema, example);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        MediaType mediaType;
        Schema schema;
        Content content;
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        }
        if ((content = requestBody.getContent()).size() > 1) {
            OnceLogger.once(this.LOGGER).warn("Multiple MediaTypes found, using only the first one");
        }
        if ((schema = (mediaType = (MediaType)content.values().iterator().next()).getSchema()) == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because requestBody content lacks a schema");
            return;
        }
        Object example = null;
        example = mediaType.getExample() != null ? mediaType.getExample() : (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && ((Example)mediaType.getExamples().values().iterator().next()).getValue() != null ? ((Example)mediaType.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema));
        example = this.exampleFromStringOrArraySchema(schema, example, codegenParameter.paramName);
        codegenParameter.example = this.toExampleValue(schema, example);
    }

    @Override
    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter cp = super.fromFormProperty(name, propertySchema, imports);
        Parameter p = new Parameter();
        p.setSchema(propertySchema);
        p.setName(cp.paramName);
        this.setParameterExampleValue(cp, p);
        return cp;
    }

    @Override
    public String toAnyOfName(List<String> names, ComposedSchema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getAnyOf());
        return String.join((CharSequence)" | ", types);
    }

    @Override
    public String toOneOfName(List<String> names, ComposedSchema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getOneOf());
        return String.join((CharSequence)" | ", types);
    }

    @Override
    public String toAllOfName(List<String> names, ComposedSchema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getAllOf());
        return String.join((CharSequence)" & ", types);
    }

    protected List<String> getTypesFromSchemas(List<Schema> schemas) {
        List<Schema> filteredSchemas = schemas.size() > 1 ? schemas.stream().filter(schema -> !"AnyType".equals(super.getSchemaType((Schema)schema))).collect(Collectors.toList()) : schemas;
        return filteredSchemas.stream().map(schema -> {
            String schemaType = this.getSchemaType((Schema)schema);
            if (ModelUtils.isArraySchema(schema)) {
                ArraySchema ap = (ArraySchema)schema;
                Schema inner = ap.getItems();
                schemaType = schemaType + "<" + this.getSchemaType(inner) + ">";
            }
            return schemaType;
        }).distinct().collect(Collectors.toList());
    }

    @Override
    protected void addImport(CodegenModel m, String type) {
        String[] parts;
        if (type == null) {
            return;
        }
        for (String s : parts = type.split("( [|&] )|[<>]")) {
            if (!this.needToImport(s)) continue;
            m.imports.add(s);
        }
    }
}

