/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;

public class JavascriptFlowtypedClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_REPOSITORY = "npmRepository";
    protected String npmRepository = null;

    public JavascriptFlowtypedClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.importMapping.clear();
        this.setReservedWordsLowerCase(Arrays.asList("varLocalPath", "queryParameters", "headerParams", "formParams", "useFormData", "varLocalDeferred", "requestOptions", "abstract", "arguments", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "eval", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield", "Array", "Date", "eval", "function", "hasOwnProperty", "Infinity", "isFinite", "isNaN", "isPrototypeOf", "Math", "NaN", "Number", "Object", "prototype", "String", "toString", "undefined", "valueOf"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "boolean", "number", "Array", "Object", "Date", "File", "Blob"));
        this.instantiationTypes.put("array", "Array");
        this.instantiationTypes.put("list", "Array");
        this.instantiationTypes.put("map", "Object");
        this.typeMapping.clear();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("map", "Object");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.defaultIncludes = new HashSet(this.languageSpecificPrimitives);
        this.outputFolder = "generated-code/javascript-flowtyped";
        this.templateDir = "Javascript-Flowtyped";
        this.embeddedTemplateDir = "Javascript-Flowtyped";
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(this.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("index.mustache", "src", "index.js"));
        this.supportingFiles.add(new SupportingFile("api.mustache", "src", "api.js"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "src", "configuration.js"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.addNpmPackageGeneration();
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("flowconfig.mustache", "", ".flowconfig"));
        this.supportingFiles.add(new SupportingFile("babelrc", "", ".babelrc"));
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (StringUtils.isBlank((CharSequence)this.npmName) && info.getTitle() != null) {
                this.npmName = this.sanitizeName(org.openapitools.codegen.utils.StringUtils.dashize(info.getTitle()));
            }
            if (StringUtils.isBlank((CharSequence)this.npmVersion)) {
                this.npmVersion = this.escapeUnsafeCharacters(this.escapeQuotationMark(info.getVersion()));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.npmName)) {
            this.npmName = "openapi-js-client";
        }
        if (StringUtils.isBlank((CharSequence)this.npmVersion)) {
            this.npmVersion = "1.0.0";
        }
        this.additionalProperties.put("npmName", this.npmName);
        this.additionalProperties.put("npmVersion", this.npmVersion);
        this.additionalProperties.put("apiPackage", this.apiPackage);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        return objs;
    }

    @Override
    public String getName() {
        return "javascript-flowtyped";
    }

    @Override
    public String getHelp() {
        return "Generates a Javascript client library (beta) using Flow types and Fetch API.";
    }

    @Override
    public String getNpmName() {
        return this.npmName;
    }

    @Override
    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    @Override
    public String getNpmVersion() {
        return this.npmVersion;
    }

    @Override
    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.JAVASCRIPT;
    }
}

