/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;

public class PhpLumenServerCodegen
extends AbstractPhpCodegen {
    protected String apiVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-lumen";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Lumen server library.";
    }

    public PhpLumenServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.templateDir = "php-lumen";
        this.embeddedTemplateDir = "php-lumen";
        this.invokerPackage = "lumen";
        this.apiPackage = "app.Http.Controllers";
        this.modelPackage = "models";
        this.modelTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.additionalProperties.put("apiVersion", this.apiVersion);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("gitignore", this.srcBasePath, ".gitignore"));
        this.supportingFiles.add(new SupportingFile(".env.example", this.srcBasePath, ".env.example"));
        this.supportingFiles.add(new SupportingFile("storage_logs_gitignore", this.srcBasePath + File.separator + "storage" + File.separator + "logs", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage_logs_gitignore", this.srcBasePath + File.separator + "storage" + File.separator + "app", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage_logs_gitignore", this.srcBasePath + File.separator + "storage" + File.separator + "framework" + File.separator + "views", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage_framework_cache_gitignore", this.srcBasePath + File.separator + "storage" + File.separator + "framework" + File.separator + "cache", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage_logs_gitignore", this.srcBasePath + File.separator + "storage" + File.separator + "framework" + File.separator + "cache" + File.separator + "data", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("artisan.mustache", this.srcBasePath, "artisan"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.srcBasePath, "composer.json"));
        this.supportingFiles.add(new SupportingFile("readme.md", this.srcBasePath, "readme.md"));
        this.supportingFiles.add(new SupportingFile("User.php.mustache", this.srcBasePath + File.separator + "app", "User.php"));
        this.supportingFiles.add(new SupportingFile("Kernel.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Console", "Kernel.php"));
        this.supportingFiles.add(new SupportingFile(".gitkeep", this.srcBasePath + File.separator + "app" + File.separator + "Console" + File.separator + "Commands", ".gitkeep"));
        this.supportingFiles.add(new SupportingFile("Event.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Events", "Event.php"));
        this.supportingFiles.add(new SupportingFile("ExampleEvent.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Events", "ExampleEvent.php"));
        this.supportingFiles.add(new SupportingFile("Handler.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Exceptions", "Handler.php"));
        this.supportingFiles.add(new SupportingFile("Controller.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Controllers" + File.separator, "Controller.php"));
        this.supportingFiles.add(new SupportingFile("ExampleController.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Controllers" + File.separator, "ExampleController.php"));
        this.supportingFiles.add(new SupportingFile("Authenticate.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware" + File.separator, "Authenticate.php"));
        this.supportingFiles.add(new SupportingFile("ExampleMiddleware.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware" + File.separator, "ExampleMiddleware.php"));
        this.supportingFiles.add(new SupportingFile("ExampleJob.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Jobs", "ExampleJob.php"));
        this.supportingFiles.add(new SupportingFile("Job.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Jobs", "Job.php"));
        this.supportingFiles.add(new SupportingFile("ExampleListener.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Listeners", "ExampleListener.php"));
        this.supportingFiles.add(new SupportingFile("AppServiceProvider.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Providers", "AppServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("AuthServiceProvider.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Providers", "AuthServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("EventServiceProvider.php.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Providers", "EventServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("app.php.mustache", this.srcBasePath + File.separator + "bootstrap", "app.php"));
        this.supportingFiles.add(new SupportingFile("ModelFactory.php.mustache", this.srcBasePath + File.separator + "database" + File.separator + "factories", "ModelFactory.php"));
        this.supportingFiles.add(new SupportingFile(".gitkeep", this.srcBasePath + File.separator + "database" + File.separator + "migrations", ".gitkeep"));
        this.supportingFiles.add(new SupportingFile("DatabaseSeeder.php.mustache", this.srcBasePath + File.separator + "database" + File.separator + "seeds", "DatabaseSeeder.php"));
        this.supportingFiles.add(new SupportingFile(".htaccess", this.srcBasePath + File.separator + "public", ".htaccess"));
        this.supportingFiles.add(new SupportingFile("index.php.mustache", this.srcBasePath + File.separator + "public", "index.php"));
        this.supportingFiles.add(new SupportingFile(".gitkeep", this.srcBasePath + File.separator + "resources" + File.separator + "views", ".gitkeep"));
        this.supportingFiles.add(new SupportingFile("routes.mustache", this.srcBasePath + File.separator + "routes", "web.php"));
        this.supportingFiles.add(new SupportingFile("ExampleTest.php.mustache", this.srcBasePath + File.separator + "tests", "ExampleTest.php"));
        this.supportingFiles.add(new SupportingFile("TestCase.php.mustache", this.srcBasePath + File.separator + "tests", "TestCase.php"));
        this.supportingFiles.add(new SupportingFile("editorconfig", this.srcBasePath, ".editorconfig"));
        this.supportingFiles.add(new SupportingFile("styleci", this.srcBasePath, ".styleci.yml"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml", this.srcBasePath, "phpunit.xml"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation op : operations) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
        }
        Collections.sort(operations, new Comparator<CodegenOperation>(){

            @Override
            public int compare(CodegenOperation lhs, CodegenOperation rhs) {
                return lhs.path.compareTo(rhs.path);
            }
        });
        this.escapeMediaType(operations);
        return objs;
    }
}

