/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import joptsimple.internal.Strings;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractRustCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustClientCodegen
extends AbstractRustCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(RustClientCodegen.class);
    private boolean useSingleRequestParameter = false;
    private boolean supportAsync = true;
    private boolean supportMiddleware = false;
    private boolean supportMultipleResponses = false;
    private boolean withAWSV4Signature = false;
    private boolean preferUnsignedInt = false;
    private boolean bestFitInt = false;
    public static final String PACKAGE_NAME = "packageName";
    public static final String PACKAGE_VERSION = "packageVersion";
    public static final String HYPER_LIBRARY = "hyper";
    public static final String REQWEST_LIBRARY = "reqwest";
    public static final String SUPPORT_ASYNC = "supportAsync";
    public static final String SUPPORT_MIDDLEWARE = "supportMiddleware";
    public static final String SUPPORT_MULTIPLE_RESPONSES = "supportMultipleResponses";
    public static final String PREFER_UNSIGNED_INT = "preferUnsignedInt";
    public static final String BEST_FIT_INT = "bestFitInt";
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String apiFolder = "src/apis";
    protected String modelFolder = "src/models";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "rust";
    }

    @Override
    public String getHelp() {
        return "Generates a Rust client library (beta).";
    }

    public RustClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.outputFolder = "generated-code/rust";
        this.modelTemplateFiles.put("model.mustache", ".rs");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.templateDir = "rust";
        this.embeddedTemplateDir = "rust";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("i8", "i16", "i32", "i64", "u8", "u16", "u32", "u64", "f32", "f64", "isize", "usize", "char", "bool", "str", "String"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "i32");
        this.typeMapping.put("long", "i64");
        this.typeMapping.put("number", "f32");
        this.typeMapping.put("float", "f32");
        this.typeMapping.put("double", "f64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("UUID", "uuid::Uuid");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "String");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("file", "std::path::PathBuf");
        this.typeMapping.put("binary", "crate::models::File");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("object", "serde_json::Value");
        this.typeMapping.put("AnyType", "serde_json::Value");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(PACKAGE_NAME, "Rust package name (convention: lowercase).").defaultValue("openapi"));
        this.cliOptions.add(new CliOption(PACKAGE_VERSION, "Rust package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("useSingleRequestParameter", "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(SUPPORT_ASYNC, "If set, generate async function call instead. This option is for 'reqwest' library only", "boolean").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(SUPPORT_MIDDLEWARE, "If set, add support for reqwest-middleware. This option is for 'reqwest' library only", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(SUPPORT_MULTIPLE_RESPONSES, "If set, return type wraps an enum of all possible 2xx schemas. This option is for 'reqwest' library only", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption("enumNameSuffix", "Suffix that will be appended to all enum names.").defaultValue(this.enumSuffix));
        this.cliOptions.add(new CliOption("withAWSV4Signature", "whether to include AWS v4 signature support", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(PREFER_UNSIGNED_INT, "Prefer unsigned integers where minimum value is >= 0", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(BEST_FIT_INT, "Use best fitting integer type where minimum or maximum is set", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.supportedLibraries.put(HYPER_LIBRARY, "HTTP client: Hyper.");
        this.supportedLibraries.put(REQWEST_LIBRARY, "HTTP client: Reqwest.");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use.");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(REQWEST_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(REQWEST_LIBRARY);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            List<ModelMap> models = entry.getValue().getModels();
            for (ModelMap mo : models) {
                CodegenModel cm = mo.getModel();
                allModels.put(modelName, cm);
            }
        }
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            List<ModelMap> models = entry.getValue().getModels();
            for (ModelMap mo : models) {
                CodegenModel cm = mo.getModel();
                if (cm.discriminator == null) continue;
                ArrayList discriminatorVars = new ArrayList();
                for (CodegenDiscriminator.MappedModel mappedModel : cm.discriminator.getMappedModels()) {
                    CodegenModel model = (CodegenModel)allModels.get(mappedModel.getModelName());
                    HashMap<String, Object> mas = new HashMap<String, Object>();
                    mas.put("modelName", StringUtils.camelize(mappedModel.getModelName()));
                    mas.put("mappingName", mappedModel.getMappingName());
                    ArrayList<CodegenProperty> vars = new ArrayList<CodegenProperty>(model.getVars());
                    vars.removeIf(p -> p.name.equals(cm.discriminator.getPropertyName()));
                    mas.put("vars", vars);
                    discriminatorVars.add(mas);
                }
                String vendorExtensionTagName = cm.discriminator.getPropertyName();
                cm.vendorExtensions.put("x-tag-name", vendorExtensionTagName);
                cm.vendorExtensions.put("x-mapped-models", discriminatorVars);
            }
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("withAWSV4Signature")) {
            this.withAWSV4Signature = Boolean.parseBoolean(this.additionalProperties.get("withAWSV4Signature").toString());
        }
        if (this.additionalProperties.containsKey("enumNameSuffix")) {
            this.enumSuffix = this.additionalProperties.get("enumNameSuffix").toString();
        }
        if (this.additionalProperties.containsKey(PACKAGE_NAME)) {
            this.setPackageName((String)this.additionalProperties.get(PACKAGE_NAME));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey(PACKAGE_VERSION)) {
            this.setPackageVersion((String)this.additionalProperties.get(PACKAGE_VERSION));
        } else if (this.openAPI != null && this.openAPI.getInfo() != null && this.openAPI.getInfo().getVersion() != null) {
            this.setPackageVersion(this.openAPI.getInfo().getVersion());
        }
        if (this.additionalProperties.containsKey("useSingleRequestParameter")) {
            this.setUseSingleRequestParameter(this.convertPropertyToBoolean("useSingleRequestParameter"));
        }
        this.writePropertyBack("useSingleRequestParameter", this.getUseSingleRequestParameter());
        if (this.additionalProperties.containsKey(SUPPORT_ASYNC)) {
            this.setSupportAsync(this.convertPropertyToBoolean(SUPPORT_ASYNC));
        }
        this.writePropertyBack(SUPPORT_ASYNC, this.getSupportAsync());
        if (this.additionalProperties.containsKey(SUPPORT_MIDDLEWARE)) {
            this.setSupportMiddleware(this.convertPropertyToBoolean(SUPPORT_MIDDLEWARE));
        }
        this.writePropertyBack(SUPPORT_MIDDLEWARE, this.getSupportMiddleware());
        if (this.additionalProperties.containsKey(SUPPORT_MULTIPLE_RESPONSES)) {
            this.setSupportMultipleReturns(this.convertPropertyToBoolean(SUPPORT_MULTIPLE_RESPONSES));
        }
        this.writePropertyBack(SUPPORT_MULTIPLE_RESPONSES, this.getSupportMultipleReturns());
        if (this.additionalProperties.containsKey(PREFER_UNSIGNED_INT)) {
            this.setPreferUnsignedInt(this.convertPropertyToBoolean(PREFER_UNSIGNED_INT));
        }
        this.writePropertyBack(PREFER_UNSIGNED_INT, this.getPreferUnsignedInt());
        if (this.additionalProperties.containsKey(BEST_FIT_INT)) {
            this.setBestFitInt(this.convertPropertyToBoolean(BEST_FIT_INT));
        }
        this.writePropertyBack(BEST_FIT_INT, this.getBestFitInt());
        this.additionalProperties.put(PACKAGE_NAME, this.packageName);
        this.additionalProperties.put(PACKAGE_VERSION, this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (HYPER_LIBRARY.equals(this.getLibrary())) {
            this.additionalProperties.put(HYPER_LIBRARY, "true");
        } else if (REQWEST_LIBRARY.equals(this.getLibrary())) {
            this.additionalProperties.put(REQWEST_LIBRARY, "true");
        } else {
            this.LOGGER.error("Unknown library option (-l/--library): {}", (Object)this.getLibrary());
        }
        this.apiTemplateFiles.put(this.getLibrary() + "/api.mustache", ".rs");
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("model_mod.mustache", this.modelFolder, "mod.rs"));
        this.supportingFiles.add(new SupportingFile("lib.mustache", "src", "lib.rs"));
        this.supportingFiles.add(new SupportingFile("Cargo.mustache", "", "Cargo.toml"));
        this.supportingFiles.add(new SupportingFile(this.getLibrary() + "/api_mod.mustache", this.apiFolder, "mod.rs"));
        this.supportingFiles.add(new SupportingFile(this.getLibrary() + "/configuration.mustache", this.apiFolder, "configuration.rs"));
        if (HYPER_LIBRARY.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("request.rs", this.apiFolder, "request.rs"));
            this.supportingFiles.add(new SupportingFile(this.getLibrary() + "/client.mustache", this.apiFolder, "client.rs"));
        }
        this.additionalProperties.put("lambdaVersion", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                String content = fragment.execute();
                content = content.trim().replace("v", "");
                content = content.replace("V", "");
                writer.write(content);
            }
        });
    }

    private boolean getSupportAsync() {
        return this.supportAsync;
    }

    private void setSupportAsync(boolean supportAsync) {
        this.supportAsync = supportAsync;
    }

    private boolean getSupportMiddleware() {
        return this.supportMiddleware;
    }

    private void setSupportMiddleware(boolean supportMiddleware) {
        this.supportMiddleware = supportMiddleware;
    }

    public boolean getSupportMultipleReturns() {
        return this.supportMultipleResponses;
    }

    public void setSupportMultipleReturns(boolean supportMultipleResponses) {
        this.supportMultipleResponses = supportMultipleResponses;
    }

    public boolean getPreferUnsignedInt() {
        return this.preferUnsignedInt;
    }

    public void setPreferUnsignedInt(boolean preferUnsignedInt) {
        this.preferUnsignedInt = preferUnsignedInt;
    }

    public boolean getBestFitInt() {
        return this.bestFitInt;
    }

    public void setBestFitInt(boolean bestFitInt) {
        this.bestFitInt = bestFitInt;
    }

    private boolean getUseSingleRequestParameter() {
        return this.useSingleRequestParameter;
    }

    private void setUseSingleRequestParameter(boolean useSingleRequestParameter) {
        this.useSingleRequestParameter = useSingleRequestParameter;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.apiFolder).replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.modelFolder).replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema unaliasSchema = this.unaliasSchema(p);
        if (ModelUtils.isArraySchema(unaliasSchema)) {
            ArraySchema ap = (ArraySchema)unaliasSchema;
            Schema inner = ap.getItems();
            if (inner == null) {
                this.LOGGER.warn("{}(array property) does not have a proper inner type defined.Default to string", (Object)ap.getName());
                inner = new StringSchema().description("TODO default missing array inner type to string");
            }
            return "Vec<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(unaliasSchema)) {
            Schema inner = this.getAdditionalProperties(unaliasSchema);
            if (inner == null) {
                this.LOGGER.warn("{}(map property) does not have a proper inner type defined. Default to string", (Object)unaliasSchema.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
            }
            return "::std::collections::HashMap<String, " + this.getTypeDeclaration(inner) + ">";
        }
        String schemaType = this.getSchemaType(unaliasSchema);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return "crate::models::" + this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = this.typeMapping.getOrDefault(schemaType, schemaType);
        if (Objects.equals(p.getType(), "integer")) {
            boolean unsigned;
            boolean bestFit = this.convertPropertyToBoolean(BEST_FIT_INT);
            boolean preferUnsigned = this.convertPropertyToBoolean(PREFER_UNSIGNED_INT);
            BigInteger minimum = Optional.ofNullable(p.getMinimum()).map(BigDecimal::toBigInteger).orElse(null);
            boolean exclusiveMinimum = Optional.ofNullable(p.getExclusiveMinimum()).orElse(false);
            boolean bl = unsigned = preferUnsigned && this.canFitIntoUnsigned(minimum, exclusiveMinimum);
            if (Strings.isNullOrEmpty((String)p.getFormat())) {
                if (bestFit) {
                    return this.bestFittingIntegerType(minimum, exclusiveMinimum, Optional.ofNullable(p.getMaximum()).map(BigDecimal::toBigInteger).orElse(null), Optional.ofNullable(p.getExclusiveMaximum()).orElse(false), preferUnsigned);
                }
                return unsigned ? "u32" : "i32";
            }
            switch (p.getFormat()) {
                case "int32": {
                    return unsigned ? "u32" : "i32";
                }
                case "int64": {
                    return unsigned ? "u64" : "i64";
                }
            }
        }
        return type;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (property.isNullable && !property.required) {
            this.additionalProperties.put("serdeWith", true);
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            if (HYPER_LIBRARY.equals(this.getLibrary())) {
                operation.httpMethod = StringUtils.camelize(operation.httpMethod.toLowerCase(Locale.ROOT));
            } else if (REQWEST_LIBRARY.equals(this.getLibrary())) {
                operation.httpMethod = operation.httpMethod.toUpperCase(Locale.ROOT);
            }
            if (operation.vendorExtensions.containsKey("x-group-parameters") || !this.useSingleRequestParameter) continue;
            operation.vendorExtensions.put("x-group-parameters", Boolean.TRUE);
        }
        return objs;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            return p.getDefault().toString();
        }
        return null;
    }
}

