/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.JbossFeature;
import org.openapitools.codegen.languages.features.SwaggerFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;

public class JavaResteasyEapServerCodegen
extends AbstractJavaJAXRSServerCodegen
implements JbossFeature,
BeanValidationFeatures,
SwaggerFeatures {
    protected boolean generateJbossDeploymentDescriptor = true;
    protected boolean useSwaggerFeature = false;

    public JavaResteasyEapServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.artifactId = "openapi-jaxrs-resteasy-eap-server";
        this.useBeanValidation = true;
        this.outputFolder = "generated-code/JavaJaxRS-Resteasy-eap";
        this.updateOption("artifactId", this.getArtifactId());
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "resteasy" + File.separator + "eap";
        this.cliOptions.add(CliOption.newBoolean("generateJbossDeploymentDescriptor", "Generate Jboss Deployment Descriptor", this.generateJbossDeploymentDescriptor));
        this.cliOptions.add(CliOption.newBoolean("useSwaggerFeature", "Use dynamic Swagger generator", this.useSwaggerFeature));
    }

    @Override
    public String getName() {
        return "jaxrs-resteasy-eap";
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS-Resteasy Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("generateJbossDeploymentDescriptor")) {
            boolean generateJbossDeploymentDescriptorProp = this.convertPropertyToBooleanAndWriteBack("generateJbossDeploymentDescriptor");
            this.setGenerateJbossDeploymentDescriptor(generateJbossDeploymentDescriptorProp);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey("useSwaggerFeature")) {
            this.setUseSwaggerFeature(this.convertPropertyToBoolean("useSwaggerFeature"));
        }
        this.writePropertyBack("useSwaggerFeature", this.useSwaggerFeature);
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("gradle.mustache", "", "build.gradle").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("settingsGradle.mustache", "", "settings.gradle").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("JacksonConfig.mustache", (this.projectFolder + File.separator + "java/" + this.invokerPackage).replace(".", "/"), "JacksonConfig.java"));
        if (this.generateJbossDeploymentDescriptor) {
            this.supportingFiles.add(new SupportingFile("jboss-web.mustache", "src/main/webapp/WEB-INF", "jboss-web.xml").doNotOverwrite());
        }
        this.supportingFiles.add(new SupportingFile("RestApplication.mustache", (this.projectFolder + File.separator + "java/" + this.invokerPackage).replace(".", "/"), "RestApplication.java").doNotOverwrite());
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", (String)this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        this.removeImport(objs, "java.util.List");
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setGenerateJbossDeploymentDescriptor(boolean generateJbossDeploymentDescriptor) {
        this.generateJbossDeploymentDescriptor = generateJbossDeploymentDescriptor;
    }

    @Override
    public void setUseSwaggerFeature(boolean useSwaggerFeature) {
        this.useSwaggerFeature = useSwaggerFeature;
    }
}

