/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.commons.io.FileUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.serializer.SerializerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIGenerator
extends DefaultCodegen
implements CodegenConfig {
    public static final String OUTPUT_NAME = "outputFileName";
    private final Logger LOGGER = LoggerFactory.getLogger(OpenAPIGenerator.class);
    protected String outputFileName = "openapi.json";

    public OpenAPIGenerator() {
        this.modifyFeatureSet(features -> features.documentationFeatures(EnumSet.allOf(DocumentationFeature.class)).dataTypeFeatures(EnumSet.allOf(DataTypeFeature.class)).wireFormatFeatures(EnumSet.allOf(WireFormatFeature.class)).securityFeatures(EnumSet.allOf(SecurityFeature.class)).globalFeatures(EnumSet.allOf(GlobalFeature.class)).parameterFeatures(EnumSet.allOf(ParameterFeature.class)).schemaSupportFeatures(EnumSet.allOf(SchemaSupportFeature.class)));
        this.templateDir = "openapi";
        this.embeddedTemplateDir = "openapi";
        this.outputFolder = "generated-code/openapi";
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.cliOptions.add(CliOption.newString(OUTPUT_NAME, "Output file name").defaultValue(this.outputFileName));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "openapi";
    }

    @Override
    public String getHelp() {
        return "Creates a static openapi.json file (OpenAPI spec v3.0).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OUTPUT_NAME)) {
            this.outputFileName = this.additionalProperties.get(OUTPUT_NAME).toString();
        }
        this.LOGGER.info("Output file name [outputFileName={}]", (Object)this.outputFileName);
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
        String jsonOpenAPI = SerializerUtils.toJsonString(openAPI);
        try {
            String outputFile = this.outputFolder + File.separator + this.outputFileName;
            FileUtils.writeStringToFile((File)new File(outputFile), (String)jsonOpenAPI, (Charset)StandardCharsets.UTF_8);
            this.LOGGER.info("wrote file to {}", (Object)outputFile);
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return null;
    }
}

