/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N4jsClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String CHECK_REQUIRED_PARAMS_NOT_NULL = "checkRequiredParamsNotNull";
    public static final String CHECK_SUPERFLUOUS_BODY_PROPS = "checkSuperfluousBodyProps";
    public static final String GENERATE_DEFAULT_API_EXECUTER = "generateDefaultApiExecuter";
    final Logger LOGGER = LoggerFactory.getLogger(N4jsClientCodegen.class);
    final Set<String> forbiddenChars = new HashSet<String>();
    private boolean checkRequiredBodyPropsNotNull = true;
    private boolean checkSuperfluousBodyProps = true;
    private boolean generateDefaultApiExecuter = true;

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "n4js";
    }

    @Override
    public String getHelp() {
        return "Generates a n4js client.";
    }

    public N4jsClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.specialCharReplacements.clear();
        this.outputFolder = "generated-code" + File.separator + "n4js";
        this.modelTemplateFiles.put("model.mustache", ".n4jsd");
        this.apiTemplateFiles.put("api.mustache", ".n4js");
        this.templateDir = "n4js";
        this.embeddedTemplateDir = "n4js";
        this.apiPackage = "";
        this.modelPackage = "";
        this.typeMapping = new HashMap();
        this.typeMapping.put("Set", "Set");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("Map", "any");
        this.typeMapping.put("map", "any");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("binary", "any");
        this.typeMapping.put("File", "any");
        this.typeMapping.put("file", "any");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("Error", "Error");
        this.typeMapping.put("AnyType", "any");
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.supportsMultipleInheritance = false;
        this.reservedWords.addAll(Arrays.asList("varLocalPath", "queryParameters", "headerParams", "formParams", "useFormData", "varLocalDeferred", "requestOptions", "abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "String", "boolean", "number", "int", "Object", "object", "Array", "any", "any+", "Error"));
        this.defaultIncludes.add("~Object+");
        this.defaultIncludes.add("Object+");
        this.forbiddenChars.add("@");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiNamePrefix", "Prefix that will be appended to all API names ('tags'). Default: empty string. e.g. Pet => Pet."));
        this.cliOptions.add(new CliOption(CHECK_REQUIRED_PARAMS_NOT_NULL, "Iff true null-checks are performed for required parameters."));
        this.cliOptions.add(new CliOption(CHECK_SUPERFLUOUS_BODY_PROPS, "Iff true a new copy of the given body object is transmitted. This copy only contains those properties defined in its model specification."));
        this.cliOptions.add(new CliOption(GENERATE_DEFAULT_API_EXECUTER, "Iff true a default implementation of the api executer interface is generated."));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        GlobalSettings.setProperty("skipFormModel", "false");
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("ApiHelper.mustache", this.apiPackage, "ApiHelper.n4js"));
        this.checkRequiredBodyPropsNotNull = this.processBooleanOpt(CHECK_REQUIRED_PARAMS_NOT_NULL, this.checkRequiredBodyPropsNotNull);
        this.checkSuperfluousBodyProps = this.processBooleanOpt(CHECK_SUPERFLUOUS_BODY_PROPS, this.checkSuperfluousBodyProps);
        this.generateDefaultApiExecuter = this.processBooleanOpt(GENERATE_DEFAULT_API_EXECUTER, this.generateDefaultApiExecuter);
        if (this.additionalProperties.get("apiPackage") instanceof String) {
            this.apiPackage = this.additionalProperties.get("apiPackage").toString();
        } else {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.get("modelPackage") instanceof String) {
            this.modelPackage = this.additionalProperties.get("modelPackage").toString();
        } else {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (this.additionalProperties.get("apiNamePrefix") instanceof String) {
            this.apiNamePrefix = this.additionalProperties.get("apiNamePrefix").toString();
        } else {
            this.additionalProperties.put("apiNamePrefix", this.apiNamePrefix);
        }
    }

    private boolean processBooleanOpt(String OPT, boolean defaultValue) {
        boolean passedValue = defaultValue;
        if (this.additionalProperties.containsKey(OPT)) {
            Object value = this.additionalProperties.get(OPT);
            if (value instanceof Boolean) {
                passedValue = (Boolean)value;
            } else {
                try {
                    passedValue = Boolean.parseBoolean(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.additionalProperties.put(OPT, passedValue);
        return defaultValue;
    }

    @Override
    public String toModelFilename(String name) {
        if (this.typeMapping.containsKey(name) || this.defaultIncludes.contains(name)) {
            return name;
        }
        return super.toModelFilename(name);
    }

    public boolean checkRequiredBodyPropsNotNull() {
        return this.checkRequiredBodyPropsNotNull;
    }

    public boolean checkSuperfluousBodyProps() {
        return this.checkSuperfluousBodyProps;
    }

    public boolean generateDefaultApiExecuter() {
        return this.generateDefaultApiExecuter;
    }

    @Override
    public boolean getUseInlineModelResolver() {
        return false;
    }

    @Override
    public void setOpenAPI(OpenAPI openAPI) {
        super.setOpenAPI(openAPI);
        this.typeAliases.put("object", "~Object+");
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    public String toAnyOfName(List<String> names, Schema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getAnyOf());
        return String.join((CharSequence)" | ", types);
    }

    @Override
    public String toOneOfName(List<String> names, Schema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getOneOf());
        return String.join((CharSequence)" | ", types);
    }

    @Override
    public String toAllOfName(List<String> names, Schema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getAllOf());
        return String.join((CharSequence)" & ", types);
    }

    protected List<String> getTypesFromSchemas(List<Schema> schemas) {
        List<Schema> filteredSchemas = schemas.size() > 1 ? schemas.stream().filter(schema -> !"AnyType".equals(super.getSchemaType((Schema)schema))).collect(Collectors.toList()) : schemas;
        return filteredSchemas.stream().map(schema -> this.getTypeDeclaration((Schema)schema)).distinct().collect(Collectors.toList());
    }

    @Override
    protected void addImports(Set<String> importsToBeAddedTo, IJsonSchemaValidationProperties type) {
        Set<String> imports = type.getImports(this.importContainerType, this.importBaseType, this.generatorMetadata.getFeatureSet());
        HashSet<String> mappedImports = new HashSet<String>();
        Iterator<String> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String imp;
            String mappedImp = imp = iterator.next();
            mappedImp = this.typeMapping.containsKey(imp) ? (String)this.typeMapping.get(imp) : imp;
            mappedImports.add(mappedImp);
        }
        this.addImports(importsToBeAddedTo, mappedImports);
    }

    @Override
    protected void addImport(Set<String> importsToBeAddedTo, String type) {
        String[] parts;
        for (String s : parts = this.splitComposedType(type)) {
            super.addImport(importsToBeAddedTo, s);
        }
    }

    private String[] splitComposedType(String name) {
        return name.replace(" ", "").split("[|&<>]");
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        for (ModelMap modelMap : objs.getModels()) {
            CodegenModel cgModel = modelMap.getModel();
            if (cgModel.unescapedDescription == null || cgModel.unescapedDescription.contains("\n * ")) continue;
            cgModel.description = this.escapeTextWhileAllowingNewLines(cgModel.unescapedDescription.trim()).replace("\n", "\n * ");
        }
        this.postProcessModelsEnum(objs);
        return objs;
    }

    @Override
    protected void addImportsForPropertyType(CodegenModel model, CodegenProperty property) {
        if (model.getIsAnyType()) {
            return;
        }
        super.addImportsForPropertyType(model, property);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        for (String modelName : objs.keySet()) {
            ModelsMap modelsMap = objs.get(modelName);
            List<Map<String, String>> imports = modelsMap.getImports();
            ArrayList<Map<String, String>> n4jsImports = new ArrayList<Map<String, String>>();
            modelsMap.put("n4jsimports", n4jsImports);
            String className = modelsMap.get("classname").toString();
            for (Map<String, String> imp : imports) {
                Map<String, String> n4jsImport = this.toN4jsImports(className, objs, imp);
                if (n4jsImport == null) continue;
                n4jsImports.add(n4jsImport);
            }
            this.adjustDescriptionWithNewLines(modelsMap);
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operations, List<ModelMap> allModels) {
        OperationMap objs = operations.getOperations();
        boolean needImportCleanCopyBody = false;
        HashMap<String, CodegenSecurity> authMethodsMap = new HashMap<String, CodegenSecurity>();
        for (CodegenOperation op : objs.getOperation()) {
            if (op.hasAuthMethods) {
                for (CodegenSecurity sec : op.authMethods) {
                    authMethodsMap.put(sec.name, sec);
                }
            }
            if (op.bodyParam != null && !op.bodyParam.vars.isEmpty()) {
                needImportCleanCopyBody = true;
            }
            if (op.responses == null || op.responses.size() <= 0) continue;
            LinkedHashMap<String, CodegenResponse> responses2xx = new LinkedHashMap<String, CodegenResponse>();
            LinkedHashMap<String, CodegenResponse> responses4xx = new LinkedHashMap<String, CodegenResponse>();
            for (CodegenResponse response : op.responses) {
                if (response.is2xx) {
                    responses2xx.put(response.baseType, response);
                }
                if (!response.is4xx) continue;
                responses4xx.put(response.baseType, response);
            }
            op.vendorExtensions.put("responses2xx", new ArrayList(responses2xx.values()));
            op.vendorExtensions.put("responses4xx", new ArrayList(responses4xx.values()));
        }
        operations.put("needImportCleanCopyBody", needImportCleanCopyBody);
        if (!authMethodsMap.isEmpty()) {
            operations.put("authMethods", authMethodsMap.values());
            operations.put("hasAuthMethods", true);
        }
        Iterator<Map<String, String>> iter = operations.getImports().iterator();
        while (iter.hasNext()) {
            Map<String, String> im = iter.next();
            String className = im.get("classname");
            String adjClassName = this.typeMapping.getOrDefault(className = this.convertToModelName(className), className);
            if (this.needToImport(adjClassName)) {
                im.put("classname", className);
                im.put("filename", this.toModelImport(className));
                continue;
            }
            iter.remove();
        }
        this.adjustDescriptionWithNewLines(this.additionalProperties);
        return operations;
    }

    private String convertToModelName(String modelName) {
        if (modelName == null) {
            return modelName;
        }
        Schema schema = ModelUtils.getSchema(this.openAPI, modelName);
        if (schema == null) {
            return modelName;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            return this.toModelFilename(modelName);
        }
        return modelName;
    }

    private void adjustDescriptionWithNewLines(Map<String, Object> map) {
        if (map.containsKey("appDescriptionWithNewLines") && !map.get("appDescriptionWithNewLines").toString().contains("\n * ")) {
            String appDescriptionWithNewLines = map.get("appDescriptionWithNewLines").toString();
            appDescriptionWithNewLines = appDescriptionWithNewLines.trim().replace("\n", "\n * ");
            map.put("appDescriptionWithNewLines", appDescriptionWithNewLines);
        }
    }

    private Map<String, String> toN4jsImports(String className, Map<String, ModelsMap> objs, Map<String, String> imp) {
        String modelImpName = imp.get("import");
        if (modelImpName == null) {
            return null;
        }
        String modelName = this.fromModelImport(modelImpName);
        if (!objs.containsKey(modelName)) {
            return null;
        }
        ModelsMap modelsMap = objs.get(modelName);
        String impClassName = modelsMap.get("classname").toString();
        if (impClassName == null || Objects.equals(impClassName, className)) {
            return null;
        }
        HashMap<String, String> n4jsImport = new HashMap<String, String>();
        n4jsImport.put("elementname", impClassName);
        n4jsImport.put("modulename", modelImpName);
        return n4jsImport;
    }

    @Override
    public String toModelImport(String name) {
        String modelImportName = this.toModelFilename(name);
        if ("".equals(this.modelPackage())) {
            return modelImportName;
        }
        return this.modelPackage() + "/" + modelImportName;
    }

    protected String fromModelImport(String modelImportName) {
        if ("".equals(this.modelPackage())) {
            return modelImportName;
        }
        if (modelImportName == null) {
            return modelImportName;
        }
        if (modelImportName.startsWith(this.modelPackage() + "/")) {
            String nameWithoutModelPackage = modelImportName.substring(1 + this.modelPackage().length());
            if (this.modelNamePrefix != null && nameWithoutModelPackage.startsWith(this.modelNamePrefix)) {
                return nameWithoutModelPackage.substring(this.modelNamePrefix.length());
            }
            return nameWithoutModelPackage;
        }
        return modelImportName;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> items = this.getSchemaItems((ArraySchema)p);
            return this.getTypeDeclaration(this.unaliasSchema(items)) + "[]";
        }
        if (ModelUtils.isMapSchema(p)) {
            return "~Object+";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getEnum() != null) {
                return this.enumValuesToEnumTypeUnion(p.getEnum(), "string");
            }
        } else if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p)) {
            if (p.getEnum() != null) {
                return this.numericEnumValuesToEnumTypeUnion(new ArrayList<Number>(p.getEnum()));
            }
        } else {
            if (ModelUtils.isFileSchema(p)) {
                return "File";
            }
            if (ModelUtils.isObjectSchema(p) || ModelUtils.isObjectSchema(ModelUtils.getReferencedSchema(this.openAPI, p))) {
                String result = super.getTypeDeclaration(p);
                return this.toModelFilename(result);
            }
            if (ModelUtils.isBinarySchema(p)) {
                return "ArrayBuffer";
            }
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected String getParameterDataType(Parameter parameter, Schema p) {
        String result;
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema mp1 = (ArraySchema)p;
            Schema inner = mp1.getItems();
            return this.getParameterDataType(parameter, inner) + "[]";
        }
        if (ModelUtils.isMapSchema(p)) {
            return "~Object+";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getEnum() != null) {
                return this.enumValuesToEnumTypeUnion(p.getEnum(), "string");
            }
        } else {
            if (ModelUtils.isObjectSchema(p) || ModelUtils.isObjectSchema(ModelUtils.getReferencedSchema(this.openAPI, p))) {
                String result2 = super.getTypeDeclaration(p);
                return this.toModelFilename(result2);
            }
            if ((ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p)) && p.getEnum() != null) {
                return this.numericEnumValuesToEnumTypeUnion(new ArrayList<Number>(p.getEnum()));
            }
        }
        if ((result = this.getTypeDeclaration(p)) != null) {
            result = this.toModelFilename(result);
        }
        return result;
    }

    @Override
    protected String getSingleSchemaType(Schema schema) {
        String schemaName;
        Schema unaliasSchema = this.unaliasSchema(schema);
        if (StringUtils.isNotBlank((CharSequence)unaliasSchema.get$ref()) && StringUtils.isNotEmpty((CharSequence)(schemaName = ModelUtils.getSimpleRef(unaliasSchema.get$ref()))) && this.schemaMapping.containsKey(schemaName)) {
            return schemaName;
        }
        String result = super.getSingleSchemaType(unaliasSchema);
        if (result != null) {
            result = this.toModelFilename(result);
        }
        return result;
    }

    private String enumValuesToEnumTypeUnion(List<String> values, String dataType) {
        StringBuilder b = new StringBuilder();
        boolean isFirst = true;
        for (String value : values) {
            if (!isFirst) {
                b.append(" | ");
            }
            b.append(this.toEnumValue(value, dataType));
            isFirst = false;
        }
        return b.toString();
    }

    private String numericEnumValuesToEnumTypeUnion(List<Number> values) {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Number value : values) {
            stringValues.add(value.toString());
        }
        return this.enumValuesToEnumTypeUnion(stringValues, "number");
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (property.unescapedDescription != null && property.unescapedDescription.contains("\n")) {
            property.description = this.escapeTextWhileAllowingNewLines(property.unescapedDescription.trim()).replace("\n", "\n     * ");
        }
    }

    @Override
    public String escapeText(String input) {
        if ((input = this.escapeTextWhileAllowingNewLines(input)) == null) {
            return input;
        }
        return input.replaceAll("[\\n\\r]", " ");
    }

    @Override
    public String escapeTextWhileAllowingNewLines(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeEcmaScript((String)StringEscapeUtils.escapeEcmaScript((String)input).replace("\\/", "/")).replaceAll("[\\t]", " "));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toVarName(String name) {
        String name2 = super.toVarName(name);
        for (String forbiddenChar : this.forbiddenChars) {
            if (!name2.contains(forbiddenChar)) continue;
            return "[\"" + name2 + "\"]";
        }
        return name2;
    }

    @Override
    public String toParamName(String name) {
        String name2 = super.toParamName(name);
        for (String forbiddenChar : this.forbiddenChars) {
            if (!name2.contains(forbiddenChar)) continue;
            return "[\"" + name2 + "\"]";
        }
        return name2;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

