/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.NumberAssert;
import org.fest.assertions.PrimitiveAssert;
import org.fest.util.Strings;

public class DoubleAssert
extends PrimitiveAssert
implements NumberAssert {
    private static final double ZERO = 0.0;
    private final double actual;

    protected DoubleAssert(double actual) {
        this.actual = actual;
    }

    public DoubleAssert as(String description) {
        this.description(description);
        return this;
    }

    public DoubleAssert describedAs(String description) {
        return this.as(description);
    }

    public DoubleAssert as(Description description) {
        this.description(description);
        return this;
    }

    public DoubleAssert describedAs(Description description) {
        return this.as(description);
    }

    public DoubleAssert isEqualTo(double expected) {
        if (this.compareTo(expected) == 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public DoubleAssert isNotEqualTo(double other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    public DoubleAssert isGreaterThan(double other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public DoubleAssert isLessThan(double other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public DoubleAssert isGreaterThanOrEqualTo(double other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public DoubleAssert isLessThanOrEqualTo(double other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    public DoubleAssert isZero() {
        return this.isEqualTo(0.0);
    }

    public DoubleAssert isPositive() {
        return this.isGreaterThan(0.0);
    }

    public DoubleAssert isNegative() {
        return this.isLessThan(0.0);
    }

    public DoubleAssert isNaN() {
        return this.isEqualTo(Double.NaN);
    }

    @Deprecated
    public DoubleAssert isEqualTo(double expected, Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    public DoubleAssert isEqualTo(double expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.doubleValue());
    }

    private DoubleAssert isEqualTo(double expected, double deltaValue) {
        if (this.compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected - this.actual) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat(ErrorMessages.unexpectedNotEqual(this.actual, expected), " using delta:", Formatting.inBrackets(deltaValue)));
    }

    private int compareTo(double other) {
        return Double.compare(this.actual, other);
    }

    @Deprecated
    public static Delta delta(double d) {
        return new Delta(d);
    }

    public DoubleAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    @Deprecated
    public static class Delta {
        final double value;

        private Delta(double value) {
            this.value = value;
        }
    }
}

