/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.innerclass;

import org.fest.reflect.exception.ReflectionError;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    private final Class<?> declaringClass;
    private final String innerClassName;

    static Invoker newInvoker(Class<?> declaringClass, String innerClassName) {
        if (declaringClass == null) {
            throw new NullPointerException("The declaring class should not be null");
        }
        return new Invoker(declaringClass, innerClassName);
    }

    private Invoker(Class<?> declaringClass, String innerClassName) {
        this.declaringClass = declaringClass;
        this.innerClassName = innerClassName;
    }

    public Class<?> get() {
        String namespace = this.declaringClass.getName();
        for (Class<?> innerClass : this.declaringClass.getDeclaredClasses()) {
            if (!innerClass.getName().equals(this.expectedInnerClassName(namespace))) continue;
            return innerClass;
        }
        throw new ReflectionError(Strings.concat("The static inner class <", this.innerClassName, "> cannot be found in ", this.declaringClass.getName()));
    }

    private String expectedInnerClassName(String namespace) {
        return Strings.concat(namespace, "$", this.innerClassName);
    }
}

