/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import org.fest.assertions.Description;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.timing.Condition;
import org.fest.util.Strings;

class ComponentEnabledCondition
extends Condition {
    private Component c;

    static ComponentEnabledCondition untilIsEnabled(Component c) {
        return new ComponentEnabledCondition(c);
    }

    private ComponentEnabledCondition(Component c) {
        super(ComponentEnabledCondition.description(c));
        this.c = c;
    }

    private static Description description(final Component c) {
        return new GuiLazyLoadingDescription(){

            protected String loadDescription() {
                return Strings.concat(Formatting.format(c), " to be enabled");
            }
        };
    }

    public boolean test() {
        return ComponentEnabledQuery.isEnabled(this.c);
    }

    protected void done() {
        this.c = null;
    }
}

