/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.ComponentMovableQuery;
import org.fest.swing.driver.ComponentMoveTask;
import org.fest.swing.driver.ComponentSetSizeTask;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.ContainerStateValidator;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerDriver
extends ComponentDriver {
    public ContainerDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    protected final void resizeWidth(Container c, int width) {
        Pair<Dimension, Insets> resizeInfo = ContainerDriver.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.i;
        this.resizeBy(c, resizeInfo, width - size.width, 0);
    }

    @RunsInEDT
    protected final void resizeHeight(Container c, int height) {
        Pair<Dimension, Insets> resizeInfo = ContainerDriver.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.i;
        this.resizeBy(c, resizeInfo, 0, height - size.height);
    }

    @RunsInEDT
    protected final void resize(Container c, int width, int height) {
        Pair<Dimension, Insets> resizeInfo = ContainerDriver.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.i;
        this.resizeBy(c, resizeInfo, width - size.width, height - size.height);
    }

    @RunsInEDT
    private static Pair<Dimension, Insets> resizeInfo(final Container c) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Dimension, Insets>>(){

            @Override
            protected Pair<Dimension, Insets> executeInEDT() {
                ContainerStateValidator.validateCanResize(c);
                return new Pair<Dimension, Insets>(c.getSize(), c.getInsets());
            }
        });
    }

    @RunsInEDT
    private void resizeBy(Container c, Pair<Dimension, Insets> resizeInfo, int x, int y) {
        this.simulateResizeStarted(c, resizeInfo, x, y);
        Dimension size = (Dimension)resizeInfo.i;
        ComponentSetSizeTask.setComponentSize(c, size.width + x, size.height + y);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateResizeStarted(Container c, Pair<Dimension, Insets> resizeInfo, int x, int y) {
        Point p = ContainerDriver.resizeLocation(resizeInfo);
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    private static Point resizeLocation(Pair<Dimension, Insets> resizeInfo) {
        return ContainerDriver.resizeLocation((Dimension)resizeInfo.i, (Insets)resizeInfo.ii);
    }

    private static Point resizeLocation(Dimension size, Insets insets) {
        return ContainerDriver.resizeLocation(size.width, size.height, insets.right, insets.bottom);
    }

    private static Point resizeLocation(int width, int height, int right, int bottom) {
        return new Point(width - right / 2, height - bottom / 2);
    }

    @RunsInEDT
    public void move(Container c, int x, int y) {
        Triple<Dimension, Insets, Point> moveInfo = ContainerDriver.moveInfo(c);
        Point locationOnScreen = (Point)moveInfo.iii;
        this.moveBy(c, moveInfo, x - locationOnScreen.x, y - locationOnScreen.y);
    }

    @RunsInEDT
    private static Triple<Dimension, Insets, Point> moveInfo(final Container c) {
        return GuiActionRunner.execute(new GuiQuery<Triple<Dimension, Insets, Point>>(){

            @Override
            protected Triple<Dimension, Insets, Point> executeInEDT() {
                ContainerDriver.validateCanMove(c);
                Point locationOnScreen = null;
                try {
                    locationOnScreen = c.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                if (locationOnScreen == null) {
                    throw ComponentStateValidator.componentNotShowingOnScreenFailure(c);
                }
                return new Triple<Dimension, Insets, Point>(c.getSize(), c.getInsets(), locationOnScreen);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateCanMove(Container c) {
        ComponentStateValidator.validateIsEnabledAndShowing(c);
        if (!ComponentMovableQuery.isUserMovable(c)) {
            throw new IllegalStateException(Strings.concat("Expecting component ", Formatting.format(c), " to be movable by the user"));
        }
    }

    @RunsInEDT
    private void moveBy(Container c, Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        this.simulateMoveStarted(c, moveInfo, x, y);
        Point locationOnScreen = (Point)moveInfo.iii;
        Point location = new Point(locationOnScreen.x + x, locationOnScreen.y + y);
        ComponentMoveTask.moveComponent(c, location);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMoveStarted(Container c, Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        Point p = this.moveLocation((Dimension)moveInfo.i, (Insets)moveInfo.ii);
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    private Point moveLocation(Dimension size, Insets insets) {
        return new Point(size.width / 2, insets.top / 2);
    }
}

