/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.lang.reflect.Array;
import org.fest.util.Objects;
import org.fest.util.Strings;
import org.fest.util.Systems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arrays {
    private static final String NO_COLUMNS = "[[]]";
    private static final String NO_ROWS = "[]";
    private static final String NULL = "null";

    public static boolean equal(String[][] one, String[][] two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        if (one.length == 0) {
            return true;
        }
        if (one[0].length != two[0].length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            for (int j = 0; j < one[i].length; ++j) {
                if (Objects.areEqual(one[i][j], two[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public static String format(String[][] array) {
        if (array == null) {
            return NULL;
        }
        int size = array.length;
        if (size == 0) {
            return NO_ROWS;
        }
        if (array[0].length == 0) {
            return NO_COLUMNS;
        }
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                b.append(Systems.LINE_SEPARATOR).append(" ");
            }
            Arrays.addLine(array[i], b);
            if (i == size - 1) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    private static void addLine(String[] line, StringBuilder b) {
        int lineSize = line.length;
        b.append("[");
        for (int i = 0; i < lineSize; ++i) {
            b.append(Strings.quote(line[i]));
            if (i == lineSize - 1) continue;
            b.append(", ");
        }
        b.append("]");
    }

    public static int[] copyOf(int[] array) {
        if (array == null) {
            throw new NullPointerException("The array to copy should not be null");
        }
        int arraySize = array.length;
        int[] copy = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static <T> T[] copyOf(T[] array) {
        if (array == null) {
            throw new NullPointerException("The array to copy should not be null");
        }
        int arraySize = array.length;
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), arraySize);
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static boolean isEmptyIntArray(int[] array) {
        return array == null || array.length == 0;
    }

    private Arrays() {
    }
}

