/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.inputmaps.InputMapSet;
import org.pushingpixels.substance.api.inputmaps.SubstanceInputMapUtilities;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;
import org.pushingpixels.substance.internal.utils.border.SubstanceEtchedBorder;
import org.pushingpixels.substance.internal.utils.border.SubstancePaneBorder;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.border.SubstanceToolBarBorder;
import org.pushingpixels.substance.internal.utils.icon.CheckBoxMenuItemIcon;
import org.pushingpixels.substance.internal.utils.icon.MenuArrowIcon;
import org.pushingpixels.substance.internal.utils.icon.RadioButtonMenuItemIcon;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollPaneBorder;

public class SkinUtilities {
    public static void addCustomEntriesToTable(UIDefaults table, SubstanceSkin skin) {
        ColorUIResource disabledForegroundColor;
        UIDefaults.LazyValue menuArrowIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new MenuArrowIcon(null);
            }
        };
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new SubstanceDefaultListCellRenderer.SubstanceUIResource();
            }
        };
        SubstanceColorScheme mainActiveScheme = skin.getActiveColorScheme(DecorationAreaType.NONE);
        SubstanceColorScheme mainEnabledScheme = skin.getEnabledColorScheme(DecorationAreaType.NONE);
        SubstanceColorScheme mainDisabledScheme = skin.getDisabledColorScheme(DecorationAreaType.NONE);
        ColorUIResource controlText = new ColorUIResource(mainActiveScheme.getLightColor());
        ColorUIResource foregroundColor = SubstanceColorUtilities.getForegroundColor(mainEnabledScheme);
        ColorUIResource backgroundActiveColor = new ColorUIResource(mainActiveScheme.getBackgroundFillColor());
        ColorUIResource backgroundDefaultColor = new ColorUIResource(mainEnabledScheme.getBackgroundFillColor());
        ColorUIResource textBackgroundColor = new ColorUIResource(mainActiveScheme.getTextBackgroundFillColor());
        ColorUIResource disabledTextComponentForegroundColor = disabledForegroundColor = SubstanceColorUtilities.getForegroundColor(mainDisabledScheme);
        float alpha = skin.getAlpha(null, ComponentState.DISABLED_UNSELECTED);
        if (alpha < 1.0f) {
            ColorUIResource defaultTextBackgroundColor = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
            disabledTextComponentForegroundColor = new ColorUIResource(SubstanceColorUtilities.getInterpolatedColor(disabledTextComponentForegroundColor, defaultTextBackgroundColor, alpha));
        }
        ColorUIResource lineColor = new ColorUIResource(mainActiveScheme.getLineColor());
        ColorUIResource lineColorDefault = new ColorUIResource(mainEnabledScheme.getLineColor());
        int lcb = SubstanceColorUtilities.getColorBrightness(lineColor.getRGB());
        ColorUIResource lineBwColor = new ColorUIResource(new Color(lcb, lcb, lcb));
        SubstanceColorScheme textHighlightColorScheme = skin.getColorScheme((Component)null, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, ComponentState.SELECTED);
        if (textHighlightColorScheme == null) {
            textHighlightColorScheme = skin.getColorScheme(null, ComponentState.ROLLOVER_SELECTED);
        }
        ColorUIResource selectionTextBackgroundColor = new ColorUIResource(textHighlightColorScheme.getSelectionBackgroundColor());
        ColorUIResource selectionTextForegroundColor = new ColorUIResource(textHighlightColorScheme.getSelectionForegroundColor());
        ColorUIResource selectionCellForegroundColor = new ColorUIResource(textHighlightColorScheme.getForegroundColor());
        ColorUIResource selectionCellBackgroundColor = new ColorUIResource(textHighlightColorScheme.getBackgroundFillColor());
        UIDefaults.LazyValue regularMarginBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(), new BasicBorders.MarginBorder());
            }
        };
        UIDefaults.LazyValue textBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BorderUIResource.CompoundBorderUIResource(new SubstanceTextComponentBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getControlFontSize())), new BasicBorders.MarginBorder());
            }
        };
        UIDefaults.LazyValue textMarginBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BasicBorders.MarginBorder();
            }
        };
        UIDefaults.LazyValue tooltipBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new SubstanceBorder(SubstanceSizeUtils.getToolTipBorderInsets(SubstanceSizeUtils.getControlFontSize()));
            }
        };
        UIDefaults.LazyValue comboBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new SubstanceBorder(SubstanceSizeUtils.getComboBorderInsets(SubstanceSizeUtils.getControlFontSize()));
            }
        };
        UIDefaults.LazyValue spinnerBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BorderUIResource.CompoundBorderUIResource(new SubstanceTextComponentBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getControlFontSize())), new BasicBorders.MarginBorder());
            }
        };
        final SubstanceColorScheme titlePaneScheme = skin.getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
        UIDefaults.LazyValue menuItemInsets = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                int menuItemMargin = SubstanceSizeUtils.getMenuItemMargin(SubstanceSizeUtils.getComponentFontSize(null));
                return new InsetsUIResource(menuItemMargin, menuItemMargin, menuItemMargin, menuItemMargin);
            }
        };
        UIDefaults.LazyValue emptyIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(new Icon(){

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }

                    @Override
                    public int getIconWidth() {
                        return 2;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                    }
                });
            }
        };
        Object[] objectArray = new Object[526];
        objectArray[0] = "control";
        objectArray[1] = controlText;
        objectArray[2] = "Button.defaultButtonFollowsFocus";
        objectArray[3] = Boolean.FALSE;
        objectArray[4] = "Button.disabledText";
        objectArray[5] = disabledForegroundColor;
        objectArray[6] = "Button.foreground";
        objectArray[7] = foregroundColor;
        objectArray[8] = "Button.margin";
        objectArray[9] = new InsetsUIResource(0, 0, 0, 0);
        objectArray[10] = "CheckBox.background";
        objectArray[11] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[12] = "CheckBox.border";
        objectArray[13] = new BorderUIResource.CompoundBorderUIResource(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getControlFontSize(), ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()), new BasicBorders.MarginBorder());
        objectArray[14] = "CheckBox.disabledText";
        objectArray[15] = disabledForegroundColor;
        objectArray[16] = "CheckBox.foreground";
        objectArray[17] = foregroundColor;
        objectArray[18] = "CheckBoxMenuItem.acceleratorForeground";
        objectArray[19] = foregroundColor;
        objectArray[20] = "CheckBoxMenuItem.acceleratorSelectionForeground";
        objectArray[21] = foregroundColor;
        objectArray[22] = "CheckBoxMenuItem.background";
        objectArray[23] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[24] = "CheckBoxMenuItem.borderPainted";
        objectArray[25] = Boolean.FALSE;
        objectArray[26] = "CheckBoxMenuItem.checkIcon";
        objectArray[27] = new CheckBoxMenuItemIcon(null, 1 + SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getControlFontSize()));
        objectArray[28] = "CheckBoxMenuItem.disabledForeground";
        objectArray[29] = disabledForegroundColor;
        objectArray[30] = "CheckBoxMenuItem.foreground";
        objectArray[31] = foregroundColor;
        objectArray[32] = "CheckBoxMenuItem.margin";
        objectArray[33] = menuItemInsets;
        objectArray[34] = "CheckBoxMenuItem.selectionForeground";
        objectArray[35] = selectionCellForegroundColor;
        objectArray[36] = "ColorChooser.background";
        objectArray[37] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[38] = "ColorChooser.foreground";
        objectArray[39] = foregroundColor;
        objectArray[40] = "ComboBox.background";
        objectArray[41] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[42] = "ComboBox.border";
        objectArray[43] = comboBorder;
        objectArray[44] = "ComboBox.disabledBackground";
        objectArray[45] = textBackgroundColor;
        objectArray[46] = "ComboBox.disabledForeground";
        objectArray[47] = disabledForegroundColor;
        objectArray[48] = "ComboBox.foreground";
        objectArray[49] = foregroundColor;
        objectArray[50] = "ComboBox.selectionBackground";
        objectArray[51] = selectionCellBackgroundColor;
        objectArray[52] = "ComboBox.selectionForeground";
        objectArray[53] = selectionCellForegroundColor;
        objectArray[54] = "DesktopIcon.border";
        objectArray[55] = regularMarginBorder;
        objectArray[56] = "DesktopIcon.width";
        objectArray[57] = new Integer(140);
        objectArray[58] = "Desktop.background";
        objectArray[59] = new ColorUIResource(new Color(0, true));
        objectArray[60] = "Desktop.foreground";
        objectArray[61] = foregroundColor;
        objectArray[62] = "Dialog.background";
        objectArray[63] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[64] = "EditorPane.background";
        objectArray[65] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[66] = "EditorPane.border";
        objectArray[67] = textMarginBorder;
        objectArray[68] = "EditorPane.foreground";
        objectArray[69] = foregroundColor;
        objectArray[70] = "EditorPane.caretForeground";
        objectArray[71] = foregroundColor;
        objectArray[72] = "EditorPane.disabledBackground";
        objectArray[73] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[74] = "EditorPane.inactiveBackground";
        objectArray[75] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[76] = "EditorPane.inactiveForeground";
        objectArray[77] = disabledTextComponentForegroundColor;
        objectArray[78] = "EditorPane.selectionBackground";
        objectArray[79] = selectionTextBackgroundColor;
        objectArray[80] = "EditorPane.selectionForeground";
        objectArray[81] = selectionTextForegroundColor;
        objectArray[82] = "FileChooser.upFolderIcon";
        objectArray[83] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/go-up.png");
            }
        };
        objectArray[84] = "FileChooser.newFolderIcon";
        objectArray[85] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/folder-new.png");
            }
        };
        objectArray[86] = "FileChooser.homeFolderIcon";
        objectArray[87] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/user-home.png");
            }
        };
        objectArray[88] = "FileChooser.listViewIcon";
        objectArray[89] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/application_view_list.png");
            }
        };
        objectArray[90] = "FileChooser.detailsViewIcon";
        objectArray[91] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/application_view_detail.png");
            }
        };
        objectArray[92] = "FileChooser.usesSingleFilePane";
        objectArray[93] = Boolean.TRUE;
        objectArray[94] = "FileView.computerIcon";
        objectArray[95] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/computer.png");
            }
        };
        objectArray[96] = "FileView.directoryIcon";
        objectArray[97] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/folder.png");
            }
        };
        objectArray[98] = "FileView.fileIcon";
        objectArray[99] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/text-x-generic.png");
            }
        };
        objectArray[100] = "FileView.floppyDriveIcon";
        objectArray[101] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/media-floppy.png");
            }
        };
        objectArray[102] = "FileView.hardDriveIcon";
        objectArray[103] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/drive-harddisk.png");
            }
        };
        objectArray[104] = "FormattedTextField.background";
        objectArray[105] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[106] = "FormattedTextField.border";
        objectArray[107] = textBorder;
        objectArray[108] = "FormattedTextField.caretForeground";
        objectArray[109] = foregroundColor;
        objectArray[110] = "FormattedTextField.disabledBackground";
        objectArray[111] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[112] = "FormattedTextField.foreground";
        objectArray[113] = foregroundColor;
        objectArray[114] = "FormattedTextField.inactiveBackground";
        objectArray[115] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[116] = "FormattedTextField.inactiveForeground";
        objectArray[117] = disabledTextComponentForegroundColor;
        objectArray[118] = "FormattedTextField.selectionBackground";
        objectArray[119] = selectionTextBackgroundColor;
        objectArray[120] = "FormattedTextField.selectionForeground";
        objectArray[121] = selectionTextForegroundColor;
        objectArray[122] = "InternalFrame.activeTitleBackground";
        objectArray[123] = selectionTextForegroundColor;
        objectArray[124] = "InternalFrame.inactiveTitleBackground";
        objectArray[125] = foregroundColor;
        objectArray[126] = "InternalFrame.border";
        objectArray[127] = new BorderUIResource(new SubstancePaneBorder());
        objectArray[128] = "InternalFrame.closeIcon";
        objectArray[129] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(titlePaneScheme, titlePaneScheme);
            }
        };
        objectArray[130] = "InternalFrame.iconifyIcon";
        objectArray[131] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMinimizeIcon(titlePaneScheme, titlePaneScheme);
            }
        };
        objectArray[132] = "InternalFrame.maximizeIcon";
        objectArray[133] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMaximizeIcon(titlePaneScheme, titlePaneScheme);
            }
        };
        objectArray[134] = "InternalFrame.minimizeIcon";
        objectArray[135] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getRestoreIcon(titlePaneScheme, titlePaneScheme);
            }
        };
        objectArray[136] = "InternalFrame.paletteCloseIcon";
        objectArray[137] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(titlePaneScheme, titlePaneScheme);
            }
        };
        objectArray[138] = "Label.background";
        objectArray[139] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[140] = "Label.foreground";
        objectArray[141] = foregroundColor;
        objectArray[142] = "Label.disabledText";
        objectArray[143] = disabledForegroundColor;
        objectArray[144] = "Label.disabledForeground";
        objectArray[145] = disabledForegroundColor;
        objectArray[146] = "List.background";
        objectArray[147] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[148] = "List.cellRenderer";
        objectArray[149] = listCellRendererActiveValue;
        objectArray[150] = "List.focusCellHighlightBorder";
        objectArray[151] = new SubstanceBorder(new Insets(1, 1, 1, 1));
        objectArray[152] = "List.focusSelectedCellHighlightBorder";
        objectArray[153] = new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1);
        objectArray[154] = "List.foreground";
        objectArray[155] = foregroundColor;
        objectArray[156] = "List.selectionBackground";
        objectArray[157] = selectionCellBackgroundColor;
        objectArray[158] = "List.selectionForeground";
        objectArray[159] = selectionCellForegroundColor;
        objectArray[160] = "Menu.arrowIcon";
        objectArray[161] = menuArrowIcon;
        objectArray[162] = "Menu.background";
        objectArray[163] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[164] = "Menu.borderPainted";
        objectArray[165] = Boolean.FALSE;
        objectArray[166] = "Menu.checkIcon";
        objectArray[168] = "Menu.disabledForeground";
        objectArray[169] = disabledForegroundColor;
        objectArray[170] = "Menu.foreground";
        objectArray[171] = foregroundColor;
        objectArray[172] = "Menu.margin";
        objectArray[173] = menuItemInsets;
        objectArray[174] = "Menu.selectionForeground";
        objectArray[175] = selectionCellForegroundColor;
        objectArray[176] = "MenuBar.background";
        objectArray[177] = skin.isRegisteredAsDecorationArea(DecorationAreaType.HEADER) ? new ColorUIResource(skin.getActiveColorScheme(DecorationAreaType.HEADER).getMidColor()) : SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[178] = "MenuBar.foreground";
        objectArray[179] = new ColorUIResource(skin.getActiveColorScheme(DecorationAreaType.HEADER).getForegroundColor());
        objectArray[180] = "MenuBar.border";
        objectArray[182] = "MenuItem.acceleratorForeground";
        objectArray[183] = foregroundColor;
        objectArray[184] = "MenuItem.acceleratorSelectionForeground";
        objectArray[185] = foregroundColor;
        objectArray[186] = "MenuItem.background";
        objectArray[187] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[188] = "MenuItem.borderPainted";
        objectArray[189] = Boolean.FALSE;
        objectArray[190] = "MenuItem.checkIcon";
        objectArray[192] = "MenuItem.disabledForeground";
        objectArray[193] = disabledForegroundColor;
        objectArray[194] = "MenuItem.foreground";
        objectArray[195] = foregroundColor;
        objectArray[196] = "MenuItem.margin";
        objectArray[197] = menuItemInsets;
        objectArray[198] = "MenuItem.selectionForeground";
        objectArray[199] = selectionCellForegroundColor;
        objectArray[200] = "OptionPane.background";
        objectArray[201] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[202] = "OptionPane.errorIcon";
        objectArray[203] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-error.png");
            }
        };
        objectArray[204] = "OptionPane.foreground";
        objectArray[205] = foregroundColor;
        objectArray[206] = "OptionPane.informationIcon";
        objectArray[207] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-information.png");
            }
        };
        objectArray[208] = "OptionPane.messageForeground";
        objectArray[209] = foregroundColor;
        objectArray[210] = "OptionPane.questionIcon";
        objectArray[211] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/help-browser.png");
            }
        };
        objectArray[212] = "OptionPane.warningIcon";
        objectArray[213] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-warning.png");
            }
        };
        objectArray[214] = "Panel.background";
        objectArray[215] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[216] = "Panel.foreground";
        objectArray[217] = foregroundColor;
        objectArray[218] = "PasswordField.background";
        objectArray[219] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[220] = "PasswordField.border";
        objectArray[221] = textBorder;
        objectArray[222] = "PasswordField.caretForeground";
        objectArray[223] = foregroundColor;
        objectArray[224] = "PasswordField.disabledBackground";
        objectArray[225] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[226] = "PasswordField.foreground";
        objectArray[227] = foregroundColor;
        objectArray[228] = "PasswordField.inactiveBackground";
        objectArray[229] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[230] = "PasswordField.inactiveForeground";
        objectArray[231] = disabledTextComponentForegroundColor;
        objectArray[232] = "PasswordField.selectionBackground";
        objectArray[233] = selectionTextBackgroundColor;
        objectArray[234] = "PasswordField.selectionForeground";
        objectArray[235] = selectionTextForegroundColor;
        objectArray[236] = "PopupMenu.background";
        objectArray[237] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[238] = "PopupMenu.border";
        objectArray[239] = regularMarginBorder;
        objectArray[240] = "ProgressBar.border";
        objectArray[241] = new BorderUIResource(new SubstanceBorder());
        objectArray[242] = "ProgressBar.cycleTime";
        objectArray[243] = new Integer(1000);
        objectArray[244] = "ProgressBar.repaintInterval";
        objectArray[245] = new Integer(50);
        objectArray[246] = "ProgressBar.horizontalSize";
        objectArray[247] = new DimensionUIResource(146, SubstanceSizeUtils.getControlFontSize());
        objectArray[248] = "ProgressBar.verticalSize";
        objectArray[249] = new DimensionUIResource(SubstanceSizeUtils.getControlFontSize(), 146);
        objectArray[250] = "ProgressBar.selectionBackground";
        objectArray[251] = foregroundColor;
        objectArray[252] = "ProgressBar.selectionForeground";
        objectArray[253] = foregroundColor;
        objectArray[254] = "RadioButton.background";
        objectArray[255] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[256] = "RadioButton.border";
        objectArray[257] = new BorderUIResource.CompoundBorderUIResource(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getControlFontSize(), ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()), new BasicBorders.MarginBorder());
        objectArray[258] = "RadioButton.foreground";
        objectArray[259] = foregroundColor;
        objectArray[260] = "RadioButton.disabledText";
        objectArray[261] = disabledForegroundColor;
        objectArray[262] = "RadioButtonMenuItem.acceleratorForeground";
        objectArray[263] = foregroundColor;
        objectArray[264] = "RadioButtonMenuItem.acceleratorSelectionForeground";
        objectArray[265] = foregroundColor;
        objectArray[266] = "RadioButtonMenuItem.background";
        objectArray[267] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[268] = "RadioButtonMenuItem.borderPainted";
        objectArray[269] = Boolean.FALSE;
        objectArray[270] = "RadioButtonMenuItem.checkIcon";
        objectArray[271] = new RadioButtonMenuItemIcon(null, SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getControlFontSize()));
        objectArray[272] = "RadioButtonMenuItem.disabledForeground";
        objectArray[273] = disabledForegroundColor;
        objectArray[274] = "RadioButtonMenuItem.foreground";
        objectArray[275] = foregroundColor;
        objectArray[276] = "RadioButtonMenuItem.margin";
        objectArray[277] = menuItemInsets;
        objectArray[278] = "RadioButtonMenuItem.selectionForeground";
        objectArray[279] = selectionCellForegroundColor;
        objectArray[280] = "RootPane.background";
        objectArray[281] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[282] = "RootPane.border";
        objectArray[283] = new SubstancePaneBorder();
        objectArray[284] = "ScrollBar.background";
        objectArray[285] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[286] = "ScrollBar.width";
        objectArray[287] = new Integer(SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()));
        objectArray[288] = "ScrollBar.minimumThumbSize";
        objectArray[289] = new DimensionUIResource(SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()) - 2);
        objectArray[290] = "ScrollPane.background";
        objectArray[291] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[292] = "ScrollPane.foreground";
        objectArray[293] = foregroundColor;
        objectArray[294] = "ScrollPane.border";
        objectArray[295] = new SubstanceScrollPaneBorder();
        objectArray[296] = "Separator.background";
        objectArray[297] = backgroundDefaultColor;
        objectArray[298] = "Separator.foreground";
        objectArray[299] = lineBwColor;
        objectArray[300] = "Slider.altTrackColor";
        objectArray[301] = lineColor;
        objectArray[302] = "Slider.background";
        objectArray[303] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[304] = "Slider.darkShadow";
        objectArray[305] = lineColor;
        objectArray[306] = "Slider.focus";
        objectArray[307] = lineColor;
        objectArray[308] = "Slider.focusInsets";
        objectArray[309] = new InsetsUIResource(2, 2, 0, 2);
        objectArray[310] = "Slider.foreground";
        objectArray[311] = lineColor;
        objectArray[312] = "Slider.highlight";
        objectArray[313] = textBackgroundColor;
        objectArray[314] = "Slider.shadow";
        objectArray[315] = lineColor;
        objectArray[316] = "Slider.tickColor";
        objectArray[317] = foregroundColor;
        objectArray[318] = "Spinner.arrowButtonInsets";
        objectArray[319] = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getControlFontSize());
        objectArray[320] = "Spinner.background";
        objectArray[321] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[322] = "Spinner.border";
        objectArray[323] = spinnerBorder;
        objectArray[324] = "Spinner.disableOnBoundaryValues";
        objectArray[325] = Boolean.TRUE;
        objectArray[326] = "Spinner.foreground";
        objectArray[327] = foregroundColor;
        objectArray[328] = "Spinner.editorBorderPainted";
        objectArray[329] = Boolean.TRUE;
        objectArray[330] = "SplitPane.background";
        objectArray[331] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[332] = "SplitPane.foreground";
        objectArray[333] = foregroundColor;
        objectArray[334] = "SplitPane.dividerFocusColor";
        objectArray[335] = backgroundDefaultColor;
        objectArray[336] = "SplitPaneDivider.draggingColor";
        objectArray[337] = backgroundActiveColor;
        objectArray[338] = "SplitPane.border";
        objectArray[339] = new BorderUIResource(new EmptyBorder(0, 0, 0, 0));
        objectArray[340] = "SplitPane.dividerSize";
        objectArray[341] = (int)(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) + (float)SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getControlFontSize(), -1, 6, -1, true));
        objectArray[342] = "SplitPaneDivider.border";
        objectArray[343] = new BorderUIResource(new EmptyBorder(1, 1, 1, 1));
        objectArray[344] = "TabbedPane.tabAreaBackground";
        objectArray[345] = backgroundDefaultColor;
        objectArray[346] = "TabbedPane.unselectedBackground";
        objectArray[347] = backgroundDefaultColor;
        objectArray[348] = "TabbedPane.background";
        objectArray[349] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[350] = "TabbedPane.borderHightlightColor";
        objectArray[351] = new ColorUIResource(mainActiveScheme.getMidColor());
        objectArray[352] = "TabbedPane.contentAreaColor";
        objectArray[354] = "TabbedPane.contentBorderInsets";
        objectArray[355] = new InsetsUIResource(4, 4, 4, 4);
        objectArray[356] = "TabbedPane.contentOpaque";
        objectArray[357] = Boolean.FALSE;
        objectArray[358] = "TabbedPane.darkShadow";
        objectArray[359] = new ColorUIResource(skin.getColorScheme((Component)null, ColorSchemeAssociationKind.BORDER, ComponentState.SELECTED).getLineColor());
        objectArray[360] = "TabbedPane.focus";
        objectArray[361] = foregroundColor;
        objectArray[362] = "TabbedPane.foreground";
        objectArray[363] = foregroundColor;
        objectArray[364] = "TabbedPane.highlight";
        objectArray[365] = new ColorUIResource(mainActiveScheme.getLightColor());
        objectArray[366] = "TabbedPane.light";
        objectArray[367] = mainEnabledScheme.isDark() ? new ColorUIResource(SubstanceColorUtilities.getAlphaColor(mainEnabledScheme.getUltraDarkColor(), 100)) : new ColorUIResource(mainEnabledScheme.getLightColor());
        objectArray[368] = "TabbedPane.selected";
        objectArray[369] = new ColorUIResource(mainActiveScheme.getExtraLightColor());
        objectArray[370] = "TabbedPane.selectedForeground";
        objectArray[371] = foregroundColor;
        objectArray[372] = "TabbedPane.selectHighlight";
        objectArray[373] = new ColorUIResource(mainActiveScheme.getMidColor());
        objectArray[374] = "TabbedPane.shadow";
        objectArray[375] = new ColorUIResource(SubstanceColorUtilities.getInterpolatedColor(mainEnabledScheme.getExtraLightColor(), mainEnabledScheme.getLightColor(), 0.5));
        objectArray[376] = "TabbedPane.tabRunOverlay";
        objectArray[377] = new Integer(0);
        objectArray[378] = "Table.background";
        objectArray[379] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[380] = "Table.cellNoFocusBorder";
        objectArray[381] = new BorderUIResource.EmptyBorderUIResource(SubstanceSizeUtils.getDefaultBorderInsets(SubstanceSizeUtils.getComponentFontSize(null)));
        objectArray[382] = "Table.focusCellBackground";
        objectArray[383] = backgroundActiveColor;
        objectArray[384] = "Table.focusCellForeground";
        objectArray[385] = foregroundColor;
        objectArray[386] = "Table.focusCellHighlightBorder";
        objectArray[387] = new SubstanceBorder();
        objectArray[388] = "Table.foreground";
        objectArray[389] = foregroundColor;
        objectArray[390] = "Table.gridColor";
        objectArray[391] = lineColorDefault;
        objectArray[392] = "Table.scrollPaneBorder";
        objectArray[393] = new SubstanceScrollPaneBorder();
        objectArray[394] = "Table.selectionBackground";
        objectArray[395] = selectionCellBackgroundColor;
        objectArray[396] = "Table.selectionForeground";
        objectArray[397] = selectionCellForegroundColor;
        objectArray[398] = "TableHeader.cellBorder";
        objectArray[400] = "TableHeader.foreground";
        objectArray[401] = foregroundColor;
        objectArray[402] = "TableHeader.background";
        objectArray[403] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[404] = "TextArea.background";
        objectArray[405] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[406] = "TextArea.border";
        objectArray[407] = textMarginBorder;
        objectArray[408] = "TextArea.caretForeground";
        objectArray[409] = foregroundColor;
        objectArray[410] = "TextArea.disabledBackground";
        objectArray[411] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[412] = "TextArea.foreground";
        objectArray[413] = foregroundColor;
        objectArray[414] = "TextArea.inactiveBackground";
        objectArray[415] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[416] = "TextArea.inactiveForeground";
        objectArray[417] = disabledTextComponentForegroundColor;
        objectArray[418] = "TextArea.selectionBackground";
        objectArray[419] = selectionTextBackgroundColor;
        objectArray[420] = "TextArea.selectionForeground";
        objectArray[421] = selectionTextForegroundColor;
        objectArray[422] = "TextField.background";
        objectArray[423] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[424] = "TextField.border";
        objectArray[425] = textBorder;
        objectArray[426] = "TextField.caretForeground";
        objectArray[427] = foregroundColor;
        objectArray[428] = "TextField.disabledBackground";
        objectArray[429] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[430] = "TextField.foreground";
        objectArray[431] = foregroundColor;
        objectArray[432] = "TextField.inactiveBackground";
        objectArray[433] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[434] = "TextField.inactiveForeground";
        objectArray[435] = disabledTextComponentForegroundColor;
        objectArray[436] = "TextField.selectionBackground";
        objectArray[437] = selectionTextBackgroundColor;
        objectArray[438] = "TextField.selectionForeground";
        objectArray[439] = selectionTextForegroundColor;
        objectArray[440] = "TextPane.background";
        objectArray[441] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, false);
        objectArray[442] = "TextPane.border";
        objectArray[443] = textMarginBorder;
        objectArray[444] = "TextPane.disabledBackground";
        objectArray[445] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[446] = "TextPane.foreground";
        objectArray[447] = foregroundColor;
        objectArray[448] = "TextPane.caretForeground";
        objectArray[449] = foregroundColor;
        objectArray[450] = "TextPane.inactiveBackground";
        objectArray[451] = SubstanceColorUtilities.getDefaultBackgroundColor(true, skin, true);
        objectArray[452] = "TextPane.inactiveForeground";
        objectArray[453] = disabledTextComponentForegroundColor;
        objectArray[454] = "TextPane.selectionBackground";
        objectArray[455] = selectionTextBackgroundColor;
        objectArray[456] = "TextPane.selectionForeground";
        objectArray[457] = selectionTextForegroundColor;
        objectArray[458] = "TitledBorder.titleColor";
        objectArray[459] = foregroundColor;
        objectArray[460] = "TitledBorder.border";
        objectArray[461] = new SubstanceEtchedBorder();
        objectArray[462] = "ToggleButton.foreground";
        objectArray[463] = foregroundColor;
        objectArray[464] = "ToggleButton.disabledText";
        objectArray[465] = disabledForegroundColor;
        objectArray[466] = "ToggleButton.margin";
        objectArray[467] = new InsetsUIResource(0, 0, 0, 0);
        objectArray[468] = "ToolBar.background";
        objectArray[469] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[470] = "ToolBar.border";
        objectArray[471] = new BorderUIResource(new SubstanceToolBarBorder());
        objectArray[472] = "ToolBar.isRollover";
        objectArray[473] = Boolean.TRUE;
        objectArray[474] = "ToolBar.foreground";
        objectArray[475] = foregroundColor;
        objectArray[476] = "ToolBarSeparator.background";
        objectArray[477] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[478] = "ToolBarSeparator.foreground";
        objectArray[479] = lineBwColor;
        objectArray[480] = "ToolBar.separatorSize";
        objectArray[482] = "ToolTip.border";
        objectArray[483] = tooltipBorder;
        objectArray[484] = "ToolTip.borderInactive";
        objectArray[485] = tooltipBorder;
        objectArray[486] = "ToolTip.background";
        objectArray[487] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[488] = "ToolTip.backgroundInactive";
        objectArray[489] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, true);
        objectArray[490] = "ToolTip.foreground";
        objectArray[491] = foregroundColor;
        objectArray[492] = "ToolTip.foregroundInactive";
        objectArray[493] = disabledForegroundColor;
        objectArray[494] = "Tree.closedIcon";
        objectArray[495] = emptyIcon;
        objectArray[496] = "Tree.collapsedIcon";
        objectArray[497] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceIconFactory.getTreeIcon(null, true));
            }
        };
        objectArray[498] = "Tree.expandedIcon";
        objectArray[499] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceIconFactory.getTreeIcon(null, false));
            }
        };
        objectArray[500] = "Tree.leafIcon";
        objectArray[501] = emptyIcon;
        objectArray[502] = "Tree.openIcon";
        objectArray[503] = emptyIcon;
        objectArray[504] = "Tree.background";
        objectArray[505] = SubstanceColorUtilities.getDefaultBackgroundColor(false, skin, false);
        objectArray[506] = "Tree.selectionBackground";
        objectArray[507] = selectionCellBackgroundColor;
        objectArray[508] = "Tree.foreground";
        objectArray[509] = foregroundColor;
        objectArray[510] = "Tree.hash";
        objectArray[511] = lineColorDefault;
        objectArray[512] = "Tree.rowHeight";
        objectArray[513] = new Integer(0);
        objectArray[514] = "Tree.selectionBorderColor";
        objectArray[515] = lineColor;
        objectArray[516] = "Tree.selectionForeground";
        objectArray[517] = selectionCellForegroundColor;
        objectArray[518] = "Tree.textBackground";
        objectArray[519] = backgroundDefaultColor;
        objectArray[520] = "Tree.textForeground";
        objectArray[521] = foregroundColor;
        objectArray[522] = "Viewport.background";
        objectArray[523] = backgroundDefaultColor;
        objectArray[524] = "Viewport.foreground";
        objectArray[525] = foregroundColor;
        Object[] defaults = objectArray;
        table.putDefaults(defaults);
        InputMapSet inputMapSet = SubstanceInputMapUtilities.getSystemInputMapSet();
        if (inputMapSet == null) {
            throw new IllegalStateException("Input map set is null!");
        }
        table.put("Button.focusInputMap", inputMapSet.getButtonFocusInputMap().getUiMap());
        table.put("CheckBox.focusInputMap", inputMapSet.getCheckBoxFocusInputMap().getUiMap());
        table.put("ComboBox.ancestorInputMap", inputMapSet.getComboBoxAncestorInputMap().getUiMap());
        table.put("Desktop.ancestorInputMap", inputMapSet.getDesktopAncestorInputMap().getUiMap());
        table.put("EditorPane.focusInputMap", inputMapSet.getEditorPaneFocusInputMap().getUiMap());
        table.put("FileChooser.ancestorInputMap", inputMapSet.getFileChooserAncestorInputMap().getUiMap());
        table.put("FormattedTextField.focusInputMap", inputMapSet.getFormattedTextFieldFocusInputMap().getUiMap());
        table.put("List.focusInputMap", inputMapSet.getListFocusInputMap().getUiMap());
        table.put("PasswordField.focusInputMap", inputMapSet.getPasswordFieldFocusInputMap().getUiMap());
        table.put("RadioButton.focusInputMap", inputMapSet.getRadioButtonFocusInputMap().getUiMap());
        table.put("RootPane.ancestorInputMap", inputMapSet.getRootPaneAncestorInputMap().getUiMap());
        table.put("ScrollBar.ancestorInputMap", inputMapSet.getScrollBarAncestorInputMap().getUiMap());
        table.put("ScrollPane.ancestorInputMap", inputMapSet.getScrollPaneAncestorInputMap().getUiMap());
        table.put("Slider.focusInputMap", inputMapSet.getSliderFocusInputMap().getUiMap());
        table.put("Spinner.ancestorInputMap", inputMapSet.getSpinnerAncestorInputMap().getUiMap());
        table.put("SplitPane.ancestorInputMap", inputMapSet.getSplitPaneAncestorInputMap().getUiMap());
        table.put("TabbedPane.ancestorInputMap", inputMapSet.getTabbedPaneAncestorInputMap().getUiMap());
        table.put("TabbedPane.focusInputMap", inputMapSet.getTabbedPaneFocusInputMap().getUiMap());
        table.put("Table.ancestorInputMap", inputMapSet.getTableAncestorInputMap().getUiMap());
        table.put("TableHeader.ancestorInputMap", inputMapSet.getTableHeaderAncestorInputMap().getUiMap());
        table.put("TextArea.focusInputMap", inputMapSet.getTextAreaFocusInputMap().getUiMap());
        table.put("TextField.focusInputMap", inputMapSet.getTextFieldFocusInputMap().getUiMap());
        table.put("TextPane.focusInputMap", inputMapSet.getTextPaneFocusInputMap().getUiMap());
        table.put("ToggleButton.focusInputMap", inputMapSet.getToggleButtonFocusInputMap().getUiMap());
        table.put("ToolBar.ancestorInputMap", inputMapSet.getToolBarAncestorInputMap().getUiMap());
        table.put("Tree.ancestorInputMap", inputMapSet.getTreeAncestorInputMap().getUiMap());
        table.put("Tree.focusInputMap", inputMapSet.getTreeFocusInputMap().getUiMap());
    }
}

