/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.swingx.SubstanceSwingxFillBackgroundDelegate;

public class SubstanceTaskPaneUI
extends BasicTaskPaneUI
implements TransitionAwareUI {
    protected Set lafWidgets;
    private SubstanceSwingxFillBackgroundDelegate bgDelegate = new SubstanceSwingxFillBackgroundDelegate();
    private RolloverControlListener substanceRolloverListener;
    protected StateTransitionTracker stateTransitionTracker;
    protected ButtonModel taskPaneModel = new DefaultButtonModel();

    public void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTaskPaneUI((JXTaskPane)comp);
    }

    public SubstanceTaskPaneUI(JXTaskPane taskPane) {
        this.taskPaneModel.setArmed(false);
        this.taskPaneModel.setSelected(false);
        this.taskPaneModel.setPressed(false);
        this.taskPaneModel.setRollover(false);
        this.stateTransitionTracker = new StateTransitionTracker(taskPane, this.taskPaneModel);
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverControlListener(this, this.taskPaneModel);
        this.group.addMouseListener(this.substanceRolloverListener);
        this.group.addMouseMotionListener(this.substanceRolloverListener);
        this.stateTransitionTracker.registerModelListeners();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallListeners() {
        this.group.removeMouseListener(this.substanceRolloverListener);
        this.group.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        super.uninstallListeners();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installDefaults() {
        SubstanceLookAndFeel.setDecorationType(this.group, DecorationAreaType.GENERAL);
        super.installDefaults();
    }

    public void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallUI(JComponent c) {
        DecorationPainterUtils.clearDecorationType(this.group);
        super.uninstallUI(c);
    }

    @Override
    protected Border createPaneBorder() {
        return new SubstancePaneBorder();
    }

    @Override
    protected Border createContentPaneBorder() {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.group, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        final Color borderColor = colorScheme.isDark() ? colorScheme.getDarkColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        Border outer = new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(borderColor);
                g2d.drawLine(x, y, x, y + height - 1);
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                g2d.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                g2d.dispose();
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 1, 1, 1);
            }
        };
        return new CompoundBorder(outer, new EmptyBorder(1, 2, 2, 2));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.bgDelegate.paint(c, (Graphics2D)g, false);
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.isInBorder(me);
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    protected int getTitleHeight(Component c) {
        return SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(c), super.getTitleHeight(c), 2, 3, false);
    }

    protected class SubstancePaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected Icon expandedIcon;
        protected Icon collapsedIcon;

        public SubstancePaneBorder() {
            this.borderColor = SubstanceColorSchemeUtilities.getColorScheme(SubstanceTaskPaneUI.this.group, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED).getMidColor();
            TransitionAwareIcon.ColorSchemeAssociationKindDelegate colorSchemeAssociationDelegate = new TransitionAwareIcon.ColorSchemeAssociationKindDelegate(){

                @Override
                public ColorSchemeAssociationKind getColorSchemeAssociationKind(ComponentState state) {
                    if (!state.isDisabled() && state != ComponentState.ENABLED) {
                        return ColorSchemeAssociationKind.HIGHLIGHT;
                    }
                    return ColorSchemeAssociationKind.MARK;
                }
            };
            this.expandedIcon = new TransitionAwareIcon(SubstanceTaskPaneUI.this.group, new TransitionAwareIcon.TransitionAwareUIDelegate(){

                @Override
                public TransitionAwareUI getTransitionAwareUI() {
                    return (TransitionAwareUI)((Object)SubstanceTaskPaneUI.this.group.getUI());
                }
            }, new TransitionAwareIcon.Delegate(){

                @Override
                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceImageCreator.getDoubleArrowIconDelta(SubstanceSizeUtils.getComponentFontSize(SubstanceTaskPaneUI.this.group), 0.0f, 3.0f, 0.0f, 1, scheme);
                }
            }, colorSchemeAssociationDelegate, "substance.swingx.taskpane.expanded");
            this.collapsedIcon = new TransitionAwareIcon(SubstanceTaskPaneUI.this.group, new TransitionAwareIcon.TransitionAwareUIDelegate(){

                @Override
                public TransitionAwareUI getTransitionAwareUI() {
                    return (TransitionAwareUI)((Object)SubstanceTaskPaneUI.this.group.getUI());
                }
            }, new TransitionAwareIcon.Delegate(){

                @Override
                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceImageCreator.getDoubleArrowIconDelta(SubstanceSizeUtils.getComponentFontSize(SubstanceTaskPaneUI.this.group), 0.0f, 3.0f, 0.0f, 5, scheme);
                }
            }, colorSchemeAssociationDelegate, "substance.swingx.taskpane.collapsed");
            SubstanceLookAndFeel.setDecorationType(this.label, DecorationAreaType.GENERAL);
            this.label.putClientProperty("substancelaf.internal.textUtilities.enforceFgColor", Boolean.TRUE);
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            StateTransitionTracker.ModelStateInfo modelStateInfo = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo().getCurrModelState();
            SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(group, ColorSchemeAssociationKind.HIGHLIGHT, currState);
            SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(group, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
            HighlightPainterUtils.paintHighlight(graphics, null, group, new Rectangle(0, 0, group.getWidth(), SubstanceTaskPaneUI.this.getTitleHeight(group)), 0.5f, null, baseFillScheme, baseBorderScheme);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = stateEntry.getKey();
                if (activeState == currState || (contribution = stateEntry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(group, ColorSchemeAssociationKind.HIGHLIGHT, activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(group, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
                graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)group, (float)contribution, (Graphics)g));
                HighlightPainterUtils.paintHighlight(graphics, null, group, new Rectangle(0, 0, group.getWidth(), SubstanceTaskPaneUI.this.getTitleHeight(group)), 0.5f, null, fillScheme, borderScheme);
            }
            graphics.dispose();
        }

        @Override
        protected Color getPaintColor(JXTaskPane group) {
            StateTransitionTracker.ModelStateInfo modelStateInfo = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo().getCurrModelState();
            if (currState.isDisabled() || activeStates.size() == 1) {
                return this.getColorSchemeForState(group, currState).getForegroundColor();
            }
            float aggrRed = 0.0f;
            float aggrGreen = 0.0f;
            float aggrBlue = 0.0f;
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                ComponentState activeState = activeEntry.getKey();
                SubstanceColorScheme scheme = this.getColorSchemeForState(group, activeState);
                Color schemeFg = scheme.getForegroundColor();
                float contribution = activeEntry.getValue().getContribution();
                aggrRed += (float)schemeFg.getRed() * contribution;
                aggrGreen += (float)schemeFg.getGreen() * contribution;
                aggrBlue += (float)schemeFg.getBlue() * contribution;
            }
            return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
        }

        private SubstanceColorScheme getColorSchemeForState(JXTaskPane group, ComponentState state) {
            ColorSchemeAssociationKind assocKind = ColorSchemeAssociationKind.FILL;
            if (!state.isDisabled() && state != ComponentState.ENABLED) {
                assocKind = ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme currScheme = SubstanceColorSchemeUtilities.getColorScheme(group, assocKind, state);
            return currScheme;
        }

        @Override
        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            Icon arrowIcon = group.isCollapsed() ? this.collapsedIcon : this.expandedIcon;
            int dx = (width - arrowIcon.getIconWidth()) / 2;
            int dy = 1 + (height - arrowIcon.getIconHeight()) / 2;
            arrowIcon.paintIcon(group, g, x + dx, y + dy);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }

        @Override
        protected void paintFocus(Graphics g, Color paintColor, int x, int y, int width, int height) {
            SubstanceCoreUtilities.paintFocus(g, SubstanceTaskPaneUI.this.group, SubstanceTaskPaneUI.this.group, SubstanceTaskPaneUI.this, new Rectangle(x, y, width - 1, height - 1), this.label.getBounds(), 1.0f, 0);
        }

        @Override
        protected void configureLabel(JXTaskPane group) {
            this.label.applyComponentOrientation(group.getComponentOrientation());
            this.label.setFont(group.getFont());
            this.label.setText(group.getTitle());
            this.label.setIcon(group.getIcon() == null ? new EmptyIcon() : group.getIcon());
        }
    }
}

