/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.AutumnSkin;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.skin.BusinessBlueSteelSkin;
import org.pushingpixels.substance.api.skin.BusinessSkin;
import org.pushingpixels.substance.api.skin.CremeCoffeeSkin;
import org.pushingpixels.substance.api.skin.CremeSkin;
import org.pushingpixels.substance.api.skin.GraphiteGlassSkin;
import org.pushingpixels.substance.api.skin.GraphiteSkin;
import org.pushingpixels.substance.api.skin.MagellanSkin;
import org.pushingpixels.substance.api.skin.MistAquaSkin;
import org.pushingpixels.substance.api.skin.ModerateSkin;
import org.pushingpixels.substance.api.skin.NebulaBrickWallSkin;
import org.pushingpixels.substance.api.skin.NebulaSkin;
import org.pushingpixels.substance.api.skin.OfficeSilver2007Skin;
import org.pushingpixels.substance.api.skin.RavenSkin;
import org.pushingpixels.substance.api.skin.SaharaSkin;
import test.check.SampleFrame;

public class MultipleSkins {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                JFrame.setDefaultLookAndFeelDecorated(true);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                Rectangle screenBounds = gc.getBounds();
                screenBounds.x = 0;
                screenBounds.y = 0;
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
                SubstanceSkin[][] skinGrid = new SubstanceSkin[][]{{new AutumnSkin(), new BusinessSkin(), new BusinessBlueSteelSkin(), new BusinessBlackSteelSkin()}, {new NebulaSkin(), new CremeSkin(), new CremeCoffeeSkin(), new ModerateSkin()}, {new OfficeSilver2007Skin(), new SaharaSkin(), new MistAquaSkin(), new NebulaBrickWallSkin()}, {new RavenSkin(), new GraphiteSkin(), new GraphiteGlassSkin(), new MagellanSkin()}};
                int x = maxBounds.x;
                int i = 0;
                while (i < 4) {
                    int y = maxBounds.y;
                    int j = 0;
                    while (j < 3) {
                        SampleFrame skinFrame = new SampleFrame();
                        skinFrame.getRootPane().putClientProperty("substancelaf.skin", skinGrid[i][j]);
                        SwingUtilities.updateComponentTreeUI(skinFrame);
                        skinFrame.setBounds(x, y, maxBounds.width / 4, maxBounds.height / 3);
                        skinFrame.setVisible(true);
                        skinFrame.setDefaultCloseOperation(3);
                        y += maxBounds.height / 3;
                        ++j;
                    }
                    x += maxBounds.width / 4;
                    ++i;
                }
            }
        });
    }
}

