/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.pushingpixels.substance.api.SubstanceConstants;
import test.Check;
import test.check.MousePopupListener;
import test.check.ScrollablePanel;
import test.check.command.ChainCommand;
import test.check.command.ClientPropertyCommand;
import test.check.command.ConfigurationCommand;
import test.check.command.DisableCommand;
import test.check.command.SelectCommand;

public class ButtonsPanel
extends JPanel {
    public JButton defaultButton;
    private int rowCount = 0;

    private AbstractButton[] getRow() {
        AbstractButton[] result = new AbstractButton[4];
        result[0] = new JButton("sample");
        result[0].setName("Button " + this.rowCount);
        result[1] = new JToggleButton("sample");
        result[1].setName("Toggle " + this.rowCount);
        result[2] = new JCheckBox("sample");
        result[2].setName("Check " + this.rowCount);
        result[3] = new JRadioButton("sample");
        result[3].setName("Radio " + this.rowCount);
        ++this.rowCount;
        return result;
    }

    private void addRow(DefaultFormBuilder builder, String label, Icon icon, ConfigurationCommand<? super AbstractButton> cmd) {
        int n;
        AbstractButton[] row = this.getRow();
        if (cmd != null) {
            AbstractButton[] abstractButtonArray = row;
            n = row.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractButton ab = abstractButtonArray[n2];
                cmd.configure(ab);
                ++n2;
            }
        }
        JLabel jl = new JLabel(label);
        if (icon != null) {
            jl.setIcon(icon);
        }
        builder.append(jl);
        AbstractButton[] abstractButtonArray = row;
        int n3 = row.length;
        n = 0;
        while (n < n3) {
            AbstractButton ab = abstractButtonArray[n];
            builder.append(ab);
            ++n;
        }
    }

    public ButtonsPanel() {
        this.setLayout(new BorderLayout());
        FormLayout lm = new FormLayout("right:pref, 10dlu, left:pref:grow(1), 4dlu,left:pref:grow(1), 4dlu, left:pref:grow(1), 4dlu, left:pref:grow(1)", "");
        lm.setColumnGroups(new int[][]{{3, 5, 7, 9}});
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.setDefaultDialogBorder();
        builder.append("");
        JLabel bLabel = new JLabel("Buttons");
        bLabel.setIcon(Check.getIcon("JButtonColor16"));
        JLabel tbLabel = new JLabel("Toggle buttons");
        tbLabel.setIcon(Check.getIcon("JToggleButtonColor16"));
        JLabel cbLabel = new JLabel("Check boxes");
        cbLabel.setIcon(Check.getIcon("JCheckBoxColor16"));
        JLabel rbLabel = new JLabel("Radio buttons");
        rbLabel.setIcon(Check.getIcon("JRadioButtonColor16"));
        builder.append((Component)bLabel, (Component)tbLabel);
        builder.append((Component)cbLabel, (Component)rbLabel);
        builder.appendSeparator("Regular settings");
        this.addRow(builder, "Enabled", null, null);
        this.addRow(builder, "Disabled", null, new DisableCommand());
        this.addRow(builder, "Selected", null, new SelectCommand());
        this.addRow(builder, "Disabled selected", null, new ChainCommand(new DisableCommand(), new SelectCommand()));
        this.addRow(builder, "HTML text", null, new TextCommand("<html>text <b>text</b> <font color='red'>text</font>"));
        this.addRow(builder, "Long text", null, new TextCommand("Some long long text"));
        this.addRow(builder, "With tooltip", null, new TooltipTextCommand("Sample tooltip"));
        this.addRow(builder, "Disabled with tooltip", null, new ChainCommand(new TooltipTextCommand("Sample tooltip"), new DisableCommand()));
        this.addRow(builder, "Popup menu", null, new PopupMenuCommand());
        this.addRow(builder, "With icon", Check.getIcon("flag_sweden"), new IconCommand(Check.getIcon("flag_sweden")));
        builder.appendSeparator("Focus indications");
        this.addRow(builder, "No focus painted", null, new NoFocusCommand());
        this.addRow(builder, "None", null, new FocusKindCommand(SubstanceConstants.FocusKind.NONE));
        this.addRow(builder, "Text", null, new FocusKindCommand(SubstanceConstants.FocusKind.TEXT));
        this.addRow(builder, "All", null, new FocusKindCommand(SubstanceConstants.FocusKind.ALL));
        this.addRow(builder, "All inner", null, new FocusKindCommand(SubstanceConstants.FocusKind.ALL_INNER));
        this.addRow(builder, "All strong inner", null, new FocusKindCommand(SubstanceConstants.FocusKind.ALL_STRONG_INNER));
        this.addRow(builder, "Underline", null, new FocusKindCommand(SubstanceConstants.FocusKind.UNDERLINE));
        this.addRow(builder, "Strong underline", null, new FocusKindCommand(SubstanceConstants.FocusKind.STRONG_UNDERLINE));
        builder.appendSeparator("Size settings");
        this.addRow(builder, "No min size", null, new NoMinSizeCommand());
        this.addRow(builder, "Custom margin", null, new MarginCommand());
        builder.appendSeparator("Side settings");
        this.addRow(builder, "Straight top", null, new StraightSideCommand((Object)SubstanceConstants.Side.TOP));
        this.addRow(builder, "Straight bottom", null, new StraightSideCommand((Object)SubstanceConstants.Side.BOTTOM));
        this.addRow(builder, "Straight left", null, new StraightSideCommand(EnumSet.of(SubstanceConstants.Side.LEFT)));
        this.addRow(builder, "Straight right", null, new StraightSideCommand(EnumSet.of(SubstanceConstants.Side.RIGHT)));
        this.addRow(builder, "Open top", null, new ChainCommand(new StraightSideCommand((Object)SubstanceConstants.Side.TOP), new OpenSideCommand((Object)SubstanceConstants.Side.TOP)));
        this.addRow(builder, "Open bottom", null, new ChainCommand(new StraightSideCommand((Object)SubstanceConstants.Side.BOTTOM), new OpenSideCommand((Object)SubstanceConstants.Side.BOTTOM)));
        this.addRow(builder, "Open left", null, new ChainCommand(new StraightSideCommand(EnumSet.of(SubstanceConstants.Side.LEFT)), new OpenSideCommand(EnumSet.of(SubstanceConstants.Side.LEFT))));
        this.addRow(builder, "Open right", null, new ChainCommand(new StraightSideCommand(EnumSet.of(SubstanceConstants.Side.RIGHT)), new OpenSideCommand(EnumSet.of(SubstanceConstants.Side.RIGHT))));
        builder.appendSeparator("Unicode texts");
        this.addRow(builder, "Hebrew", null, new ChainCommand(new TextCommand("\u05d0\u05d1\u05d2"), new IconCommand(Check.getIcon("flag_israel"))));
        this.addRow(builder, "Chinese", null, new ChainCommand(new FontCommand(new Font("Arial Unicode MS", 0, 11)), new TextCommand("\u4e01\u4e02\u4e03"), new IconCommand(Check.getIcon("flag_china"))));
        this.addRow(builder, "Cyrillic", null, new ChainCommand(new TextCommand("\u0430\u0431\u0432"), new IconCommand(Check.getIcon("flag_russia"))));
        this.addRow(builder, "Greek", null, new ChainCommand(new TextCommand("\u03b1\u03b2\u03b3"), new IconCommand(Check.getIcon("flag_greece"))));
        this.addRow(builder, "Latin", null, new ChainCommand(new TextCommand("\u00e6\u00f0\u0127\u2248"), new IconCommand(Check.getIcon("flag_italy"))));
        builder.appendSeparator("Misc settings");
        this.addRow(builder, "No content area", null, new NoContentAreaFilledCommand());
        this.addRow(builder, "No border", null, new NoBorderPaintedCommand());
        this.addRow(builder, "No background", null, new ChainCommand(new NoContentAreaFilledCommand(), new NoBorderPaintedCommand()));
        this.addRow(builder, "Flat", null, new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE));
        this.addRow(builder, "Never", null, new ClientPropertyCommand("substancelaf.buttonpaintnever", Boolean.TRUE));
        this.addRow(builder, "Fixed font", null, new FontCommand(new Font("Arial", 0, 12)));
        this.addRow(builder, "Null text", null, new TextCommand(null));
        this.addRow(builder, "Empty text", null, new TextCommand(""));
        JPanel panel = builder.getPanel();
        JScrollPane jsp = new JScrollPane(panel);
        panel.setOpaque(false);
        jsp.putClientProperty("lafwidget.scroll.auto", Boolean.TRUE);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        this.add((Component)jsp, "Center");
    }

    private class FocusKindCommand
    implements ConfigurationCommand<AbstractButton> {
        private SubstanceConstants.FocusKind focusKind;

        public FocusKindCommand(SubstanceConstants.FocusKind focusKind) {
            this.focusKind = focusKind;
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.putClientProperty("substancelaf.focusKind", (Object)this.focusKind);
        }
    }

    private class FontCommand
    implements ConfigurationCommand<AbstractButton> {
        private Font font;

        public FontCommand(Font font) {
            this.font = font;
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setFont(this.font);
        }
    }

    private class IconCommand
    implements ConfigurationCommand<AbstractButton> {
        private Icon icon;

        public IconCommand(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void configure(AbstractButton ab) {
            if (ab instanceof JRadioButton || ab instanceof JCheckBox) {
                return;
            }
            ab.setIcon(this.icon);
        }
    }

    private class MarginCommand
    implements ConfigurationCommand<AbstractButton> {
        private MarginCommand() {
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setMargin(new Insets(5, 5, 5, 5));
        }
    }

    private class NoBorderPaintedCommand
    implements ConfigurationCommand<AbstractButton> {
        private NoBorderPaintedCommand() {
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setBorderPainted(false);
        }
    }

    private class NoContentAreaFilledCommand
    implements ConfigurationCommand<AbstractButton> {
        private NoContentAreaFilledCommand() {
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setContentAreaFilled(false);
        }
    }

    private class NoFocusCommand
    implements ConfigurationCommand<AbstractButton> {
        private NoFocusCommand() {
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setFocusPainted(false);
        }
    }

    private class NoMinSizeCommand
    implements ConfigurationCommand<AbstractButton> {
        private NoMinSizeCommand() {
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        }
    }

    private class OpenSideCommand
    implements ConfigurationCommand<AbstractButton> {
        private Object sideObj;

        public OpenSideCommand(Object sideObj) {
            this.sideObj = sideObj;
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.putClientProperty("substancelaf.buttonopenSide", this.sideObj);
        }
    }

    private class PopupMenuCommand
    implements ConfigurationCommand<AbstractButton> {
        private PopupMenuCommand() {
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.addMouseListener(new MousePopupListener(ab));
        }
    }

    private class StraightSideCommand
    implements ConfigurationCommand<AbstractButton> {
        private Object sideObj;

        public StraightSideCommand(Object sideObj) {
            this.sideObj = sideObj;
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.putClientProperty("substancelaf.buttonside", this.sideObj);
        }
    }

    private class TextCommand
    implements ConfigurationCommand<AbstractButton> {
        private String text;

        public TextCommand(String text) {
            this.text = text;
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setText(this.text);
        }
    }

    private class TooltipTextCommand
    implements ConfigurationCommand<AbstractButton> {
        private String tooltipText;

        public TooltipTextCommand(String tooltipText) {
            this.tooltipText = tooltipText;
        }

        @Override
        public void configure(AbstractButton ab) {
            ab.setToolTipText(this.tooltipText);
        }
    }
}

