/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import org.pushingpixels.substance.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.substance.api.combo.WidestComboPopupPrototype;
import test.check.ColorComboBox;
import test.check.ControllablePanel;
import test.check.Deferrable;
import test.check.FlexiComboBox;
import test.check.ScrollablePanel;
import test.check.command.ConfigurationCommand;
import test.check.command.DisableCommand;
import test.check.command.EnableCommand;

public class CombosPanel
extends ControllablePanel
implements Deferrable {
    private boolean isInitialized;

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    public static void run(Component comp, ConfigurationCommand<? super JComboBox> command) {
        if (comp instanceof JComboBox) {
            command.configure((JComboBox)comp);
            return;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int i = 0;
            while (i < cont.getComponentCount()) {
                CombosPanel.run(cont.getComponent(i), command);
                ++i;
            }
        }
    }

    private JPanel getLeftComboPanel() {
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Simple combos");
        JComboBox<Object> comboRegular = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboRegular.setToolTipText("This is my combo 1");
        comboRegular.setMaximumRowCount(4);
        builder.append("Regular", comboRegular);
        JComboBox<Object> comboDisabled = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3"});
        comboDisabled.setEnabled(false);
        builder.append((Component)new JLabel("Disabled"), comboDisabled);
        JComboBox<Object> comboColored = new JComboBox<Object>(new Object[]{"entry31", "entry32", "entry33", "entry34", "entry35", "entry36", "aaa", "abb", "abc"});
        comboColored.setName("Colored combo");
        comboColored.setBackground(new Color(255, 128, 128));
        comboColored.setForeground(new Color(0, 0, 128));
        builder.append("Pink background", comboColored);
        JComboBox<Object> comboEditable = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        comboEditable.setEditable(true);
        builder.append("Editable", comboEditable);
        FlexiComboBox<Color> comboColors = new FlexiComboBox<Color>(new Color[]{new Color(255, 128, 128), new Color(128, 255, 128), new Color(128, 128, 255), new Color(255, 255, 128), new Color(255, 128, 255), new Color(128, 255, 255)}){

            @Override
            public String getCaption(Color item) {
                return String.valueOf(item.getRed()) + ":" + item.getGreen() + ":" + item.getBlue();
            }

            @Override
            public Color getItemColor(Color item) {
                return item;
            }
        };
        comboColors.setName("Colors combo");
        builder.append("Colors", (Component)comboColors);
        JComboBox<Object> comboFlat = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlat.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        builder.append("Flat", comboFlat);
        JComboBox<Object> comboDefaultCoreRenderer = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboDefaultCoreRenderer.setRenderer(new DefaultListCellRenderer());
        builder.append("Default core renderer", comboDefaultCoreRenderer);
        builder.appendSeparator("Miscellaneous");
        ColorComboBox colorCombo = new ColorComboBox();
        builder.append("Color chooser", (Component)colorCombo);
        JComboBox<Object> comboHebrew = new JComboBox<Object>(new Object[]{"\u05e8\u05d0\u05e9\u05d9 1", "\u05e8\u05d0\u05e9\u05d9 2", "\u05e8\u05d0\u05e9\u05d9 3", "\u05e8\u05d0\u05e9\u05d9 4", "\u05e8\u05d0\u05e9\u05d9 5", "\u05e8\u05d0\u05e9\u05d9 6", "\u05e8\u05d0\u05e9\u05d9 7", "\u05e8\u05d0\u05e9\u05d9 8", "\u05e8\u05d0\u05e9\u05d9 9"});
        comboHebrew.setToolTipText("RTL combo");
        comboHebrew.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        comboHebrew.setMaximumRowCount(6);
        builder.append("RTL (Hebrew)", comboHebrew);
        try {
            final ImageIcon israelFlag = new ImageIcon(ImageIO.read(this.getClass().getResource("/test/check/icons/flag_israel.png")));
            FlexiComboBox<String> comboHebrewCustomRenderer = new FlexiComboBox<String>(new String[]{"\u05e8\u05d0\u05e9\u05d9 1", "\u05e8\u05d0\u05e9\u05d9 2", "\u05e8\u05d0\u05e9\u05d9 3", "\u05e8\u05d0\u05e9\u05d9 4", "\u05e8\u05d0\u05e9\u05d9 5", "\u05e8\u05d0\u05e9\u05d9 6", "\u05e8\u05d0\u05e9\u05d9 7", "\u05e8\u05d0\u05e9\u05d9 8", "\u05e8\u05d0\u05e9\u05d9 9"}){

                @Override
                public String getCaption(String item) {
                    return item;
                }

                @Override
                public Icon getItemIcon(String item) {
                    return israelFlag;
                }
            };
            comboHebrewCustomRenderer.setToolTipText("RTL combo");
            comboHebrewCustomRenderer.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            comboHebrewCustomRenderer.setMaximumRowCount(6);
            builder.append("RTL (Hebrew) with icon", (Component)comboHebrewCustomRenderer);
        }
        catch (IOException israelFlag) {
            // empty catch block
        }
        JComboBox<Object> comboHebrewEditable = new JComboBox<Object>(new Object[]{"\u05e8\u05d0\u05e9\u05d9 1", "\u05e8\u05d0\u05e9\u05d9 2", "\u05e8\u05d0\u05e9\u05d9 3", "\u05e8\u05d0\u05e9\u05d9 4", "\u05e8\u05d0\u05e9\u05d9 5", "\u05e8\u05d0\u05e9\u05d9 6", "\u05e8\u05d0\u05e9\u05d9 7", "\u05e8\u05d0\u05e9\u05d9 8", "\u05e8\u05d0\u05e9\u05d9 9"});
        comboHebrewEditable.setToolTipText("RTL combo");
        comboHebrewEditable.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        comboHebrewEditable.setMaximumRowCount(6);
        comboHebrewEditable.setEditable(true);
        builder.append("RTL (Hebrew) editable", comboHebrewEditable);
        final JComboBox<Object> combo151 = new JComboBox<Object>();
        final ComboBoxTextEditor151 editor = new ComboBoxTextEditor151();
        combo151.setEditor(editor);
        combo151.addItem(new EditableDocument151());
        combo151.addItem("Default");
        combo151.addItem("No Sound");
        combo151.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.setCaretPosition(0);
                if (combo151.getSelectedItem() instanceof String) {
                    combo151.setEditable(false);
                } else {
                    combo151.setEditable(true);
                }
                editor.setCaretPosition(0);
            }
        });
        builder.append("Defect 151", combo151);
        return builder.getPanel();
    }

    private JPanel getRightComboPanel() {
        FormLayout lm = new FormLayout("right:pref, 4dlu, left:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Popup flyout");
        JComboBox<Object> comboFlyoutDefault = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlyoutDefault.setMaximumRowCount(4);
        builder.append("Default", comboFlyoutDefault);
        JComboBox<Object> comboFlyoutNorth = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlyoutNorth.setMaximumRowCount(4);
        comboFlyoutNorth.putClientProperty("substancelaf.comboboxpopupFlyoutOrientation", 1);
        builder.append("North", comboFlyoutNorth);
        JComboBox<Object> comboFlyoutEast = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlyoutEast.setMaximumRowCount(4);
        comboFlyoutEast.putClientProperty("substancelaf.comboboxpopupFlyoutOrientation", 3);
        builder.append("East", comboFlyoutEast);
        JComboBox<Object> comboFlyoutSouth = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlyoutSouth.setMaximumRowCount(4);
        comboFlyoutSouth.putClientProperty("substancelaf.comboboxpopupFlyoutOrientation", 5);
        builder.append("South", comboFlyoutSouth);
        JComboBox<Object> comboFlyoutWest = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlyoutWest.setMaximumRowCount(4);
        comboFlyoutWest.putClientProperty("substancelaf.comboboxpopupFlyoutOrientation", 7);
        builder.append("West", comboFlyoutWest);
        JComboBox<Object> comboFlyoutCenter = new JComboBox<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4", "entry5", "entry6"});
        comboFlyoutCenter.setMaximumRowCount(4);
        comboFlyoutCenter.putClientProperty("substancelaf.comboboxpopupFlyoutOrientation", 0);
        builder.append("Center", comboFlyoutCenter);
        builder.appendSeparator("Popup prototype");
        JComboBox<Object> comboProto1 = new JComboBox<Object>(new Object[]{"aa", "aaaaa", "aaaaaaaaaa", "this one is the one", "abcdefghijklmnopqrstuvwxyz"});
        comboProto1.setPrototypeDisplayValue("aaaaa");
        comboProto1.putClientProperty("substancelaf.comboPopupPrototype", "this one is the one");
        builder.append("Hard-coded value", comboProto1);
        JComboBox<Object> comboProto2 = new JComboBox<Object>(new Object[]{"aa", "aaaaa", "aaaaaaaaaa", "another one (not it)", "abcdefghijklmnopqrstuvwxyz"});
        comboProto2.setPrototypeDisplayValue("aaaaa");
        comboProto2.putClientProperty("substancelaf.comboPopupPrototype", new WidestComboPopupPrototype());
        builder.append("Widest core callback", comboProto2);
        JComboBox<Object> comboProto3 = new JComboBox<Object>(new Object[]{"aa", "aaaaa", "this is not", "this one is not it", "this one is it that is for the popup"});
        comboProto3.setPrototypeDisplayValue("aaaaa");
        comboProto3.putClientProperty("substancelaf.comboPopupPrototype", new ComboPopupPrototypeCallback(){

            @Override
            public Object getPopupPrototypeDisplayValue(JComboBox jc) {
                return jc.getModel().getElementAt(jc.getModel().getSize() - 1);
            }
        });
        builder.append("Custom callback", comboProto3);
        builder.appendSeparator("Empty combos");
        JComboBox<String> emptyModelCombo = new JComboBox<String>(new String[0]);
        builder.append("Empty model", emptyModelCombo);
        JComboBox<String> emptyStringCombo = new JComboBox<String>(new String[]{""});
        builder.append("Empty string", emptyStringCombo);
        JComboBox<String> spaceCombo = new JComboBox<String>(new String[]{" "});
        builder.append("Space string", spaceCombo);
        JComboBox<String> emptyEditableCombo = new JComboBox<String>(new String[0]);
        emptyEditableCombo.setEditable(true);
        builder.append("Empty model + editable", emptyEditableCombo);
        JComboBox<String> emptyStringEditableCombo = new JComboBox<String>(new String[]{""});
        emptyStringEditableCombo.setEditable(true);
        builder.append("Empty string + editable", emptyStringEditableCombo);
        JComboBox<String> spaceEditableCombo = new JComboBox<String>(new String[]{" "});
        spaceEditableCombo.setEditable(true);
        builder.append("Space string + editable", spaceEditableCombo);
        return builder.getPanel();
    }

    public CombosPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public synchronized void initialize() {
        ScrollablePanel gridPanel = new ScrollablePanel();
        gridPanel.setLayout(new GridLayout(1, 2));
        gridPanel.add(this.getLeftComboPanel());
        gridPanel.add(this.getRightComboPanel());
        this.add((Component)new JScrollPane(gridPanel, 22, 30), "Center");
        FormLayout lm = new FormLayout("fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        JButton checkEscape = new JButton("Check ESC key");
        checkEscape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog();
                dialog.setTitle("Press ESC key when combo is focused");
                dialog.setLayout(new FlowLayout());
                JComboBox<Object> sampleCombo = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
                sampleCombo.setEditable(true);
                dialog.add(sampleCombo);
                dialog.add(new JCheckBox("Sample checkbox"));
                dialog.add(new JButton("Sample button"));
                dialog.setDefaultCloseOperation(2);
                JRootPane rootPane = dialog.getRootPane();
                InputMap iMap = rootPane.getInputMap(1);
                iMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
                ActionMap aMap = rootPane.getActionMap();
                aMap.put("escape", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                dialog.pack();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                dialog.setLocation((d.width - dialog.getWidth()) / 2, (d.height - dialog.getHeight()) / 2);
                dialog.setVisible(true);
            }
        });
        JButton disableCombosButton = new JButton("Disable all");
        disableCombosButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CombosPanel.run(CombosPanel.this, new DisableCommand());
                    }
                });
            }
        });
        JButton enableCombosButton = new JButton("Enable all");
        enableCombosButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CombosPanel.run(CombosPanel.this, new EnableCommand());
                    }
                });
            }
        });
        JButton makeAllEditableButton = new JButton("Make all editable");
        makeAllEditableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CombosPanel.run(CombosPanel.this, new EditAllowCommand());
                    }
                });
            }
        });
        JButton makeAllNonEditableButton = new JButton("Make all non-editable");
        makeAllNonEditableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CombosPanel.run(CombosPanel.this, new EditDisallowCommand());
                    }
                });
            }
        });
        builder.append(disableCombosButton);
        builder.append(enableCombosButton);
        builder.append(makeAllNonEditableButton);
        builder.append(makeAllEditableButton);
        builder.append(checkEscape);
        this.controlPanel = builder.getPanel();
        this.isInitialized = true;
    }

    private class ComboBoxTextEditor151
    extends JTextField
    implements ComboBoxEditor {
        Document doc = super.getDocument();

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject instanceof EditableDocument151) {
                super.setCaretPosition(0);
                super.setDocument((Document)anObject);
            } else {
                super.setCaretPosition(0);
                super.setDocument(this.doc);
                super.setText(anObject.toString());
            }
        }

        @Override
        public Object getItem() {
            return super.getText();
        }

        @Override
        public String toString() {
            return super.getText();
        }
    }

    public static class EditAllowCommand
    implements ConfigurationCommand<JComboBox> {
        @Override
        public void configure(JComboBox combo) {
            combo.setEditable(true);
        }
    }

    public static class EditDisallowCommand
    implements ConfigurationCommand<JComboBox> {
        @Override
        public void configure(JComboBox combo) {
            combo.setEditable(false);
        }
    }

    private class EditableDocument151
    extends PlainDocument {
        public EditableDocument151() {
            this.setText("Long text to show the bug");
        }

        public String toString() {
            try {
                return super.getText(0, super.getLength());
            }
            catch (BadLocationException ex) {
                return "bad location";
            }
        }

        public void setText(String newText) {
            try {
                super.remove(0, super.getLength());
                super.insertString(0, newText, new SimpleAttributeSet());
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }
}

