/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.LafWidgetUtilities2;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.preview.DefaultPreviewPainter;
import org.pushingpixels.lafwidget.utils.LafConstants;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.NebulaBrickWallSkin;
import test.Check;
import test.SubstanceLogo;
import test.check.ColorPanel;
import test.check.FlexiComboBox;
import test.check.SampleFrame;
import test.check.SimpleDialog;

public class ControlPanelFactory {
    private static SimpleDialog simpleDialog;
    private static JDialog disposableDialog;

    public static JPanel getMainControlPanel(final JFrame mainFrame, final JTabbedPane mainTabbedPane, final Check.MyMainTabPreviewPainter mainTabPreviewPainter, final JToolBar toolbar) {
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.appendSeparator("Title pane settings");
        final JCheckBox markAsModified = new JCheckBox("Marked modified");
        markAsModified.setSelected(false);
        markAsModified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainFrame.getRootPane().putClientProperty("windowModified", markAsModified.isSelected() ? Boolean.TRUE : false);
            }
        });
        builder.append("Modified", (Component)markAsModified);
        final JCheckBox heapPanel = new JCheckBox("Has heap panel");
        heapPanel.setSelected(false);
        heapPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstanceLookAndFeel.setWidgetVisible(mainFrame.getRootPane(), heapPanel.isSelected(), SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS);
            }
        });
        builder.append("Heap panel", (Component)heapPanel);
        JButton changeTitleButton = new JButton("Change");
        changeTitleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String random = "abcdefghijklmnopqrstuvwxyz ";
                int length = 60 + (int)(150.0 * Math.random());
                String title = "";
                while (length > 0) {
                    title = String.valueOf(title) + random.charAt((int)((double)random.length() * Math.random()));
                    --length;
                }
                mainFrame.setTitle(title);
            }
        });
        builder.append("Title string", (Component)changeTitleButton);
        builder.appendSeparator("Miscellaneous");
        final JCheckBox useThemedDefaultIconsCheckBox = new JCheckBox("use themed icons");
        useThemedDefaultIconsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIManager.put("substancelaf.useThemedDefaultIcons", useThemedDefaultIconsCheckBox.isSelected() ? Boolean.TRUE : null);
                        mainFrame.repaint();
                    }
                });
            }
        });
        builder.append("Themed icons", (Component)useThemedDefaultIconsCheckBox);
        final JCheckBox useConstantThemesOnDialogs = new JCheckBox("use constant themes");
        useConstantThemesOnDialogs.setSelected(SubstanceLookAndFeel.isToUseConstantThemesOnDialogs());
        useConstantThemesOnDialogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceLookAndFeel.setToUseConstantThemesOnDialogs(useConstantThemesOnDialogs.isSelected());
                        SubstanceLookAndFeel.setSkin(SubstanceLookAndFeel.getCurrentSkin(mainFrame.getRootPane()));
                    }
                });
            }
        });
        builder.append("Option pane icons", (Component)useConstantThemesOnDialogs);
        final JComboBox<Object> placementCombo = new JComboBox<Object>(new Object[]{"top", "bottom", "left", "right"});
        placementCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected = (String)placementCombo.getSelectedItem();
                if ("top".equals(selected)) {
                    mainTabbedPane.setTabPlacement(1);
                }
                if ("bottom".equals(selected)) {
                    mainTabbedPane.setTabPlacement(3);
                }
                if ("left".equals(selected)) {
                    mainTabbedPane.setTabPlacement(2);
                }
                if ("right".equals(selected)) {
                    mainTabbedPane.setTabPlacement(4);
                }
            }
        });
        builder.append("Placement", placementCombo);
        try {
            final FlexiComboBox<LafConstants.TabOverviewKind> overviewKindCombo = new FlexiComboBox<LafConstants.TabOverviewKind>(new LafConstants.TabOverviewKind[]{LafConstants.TabOverviewKind.GRID, LafConstants.TabOverviewKind.MENU_CAROUSEL, LafConstants.TabOverviewKind.ROUND_CAROUSEL}){

                @Override
                public String getCaption(LafConstants.TabOverviewKind item) {
                    return item.getName();
                }
            };
            overviewKindCombo.setSelectedItem(LafWidgetUtilities2.getTabPreviewPainter((JTabbedPane)mainTabbedPane).getOverviewKind(mainTabbedPane));
            overviewKindCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mainTabPreviewPainter.setTabOverviewKind((LafConstants.TabOverviewKind)overviewKindCombo.getSelectedItem());
                }
            });
            builder.append("Overview kind", (Component)overviewKindCombo);
        }
        catch (NoClassDefFoundError overviewKindCombo) {
            // empty catch block
        }
        final FlexiComboBox<SubstanceConstants.MenuGutterFillKind> menuGutterFillCombo = new FlexiComboBox<SubstanceConstants.MenuGutterFillKind>(new SubstanceConstants.MenuGutterFillKind[]{SubstanceConstants.MenuGutterFillKind.NONE, SubstanceConstants.MenuGutterFillKind.SOFT, SubstanceConstants.MenuGutterFillKind.HARD, SubstanceConstants.MenuGutterFillKind.SOFT_FILL, SubstanceConstants.MenuGutterFillKind.HARD_FILL}){

            @Override
            public String getCaption(SubstanceConstants.MenuGutterFillKind item) {
                return item.name();
            }
        };
        menuGutterFillCombo.setSelectedItem((Object)SubstanceConstants.MenuGutterFillKind.HARD);
        menuGutterFillCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIManager.put("substancelaf.menuGutterFillKind", menuGutterFillCombo.getSelectedItem());
            }
        });
        builder.append("Menu fill", (Component)menuGutterFillCombo);
        final FlexiComboBox<SubstanceConstants.FocusKind> focusKindCombo = new FlexiComboBox<SubstanceConstants.FocusKind>(SubstanceConstants.FocusKind.values()){

            @Override
            public String getCaption(SubstanceConstants.FocusKind item) {
                return item.name();
            }
        };
        focusKindCombo.setSelectedItem((Object)SubstanceConstants.FocusKind.ALL_INNER);
        focusKindCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIManager.put("substancelaf.focusKind", focusKindCombo.getSelectedItem());
            }
        });
        builder.append("Focus kind", (Component)focusKindCombo);
        JButton buttonGlassPane = new JButton("Show");
        buttonGlassPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JPanel glassPane = new JPanel(){

                    @Override
                    public void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        Graphics2D graphics = (Graphics2D)g;
                        int height = this.getHeight();
                        int width = this.getWidth();
                        AlphaComposite c = AlphaComposite.getInstance(3, 0.4f);
                        graphics.setComposite(c);
                        int i = 0;
                        while (i < height) {
                            Color color = i % 2 == 0 ? new Color(200, 200, 255) : new Color(230, 230, 255);
                            graphics.setColor(color);
                            graphics.drawLine(0, i, width, i);
                            ++i;
                        }
                        AlphaComposite c2 = AlphaComposite.getInstance(3, 1.0f);
                        graphics.setComposite(c2);
                    }
                };
                glassPane.setOpaque(false);
                glassPane.addMouseListener(new MouseAdapter(){});
                glassPane.addKeyListener(new KeyAdapter(){});
                mainFrame.setGlassPane(glassPane);
                new Thread(){

                    @Override
                    public void run() {
                        glassPane.setVisible(true);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                        glassPane.setVisible(false);
                    }
                }.start();
            }
        });
        builder.append("Glass pane", (Component)buttonGlassPane);
        builder.appendSeparator("Custom animations");
        final JCheckBox allowFocusLoopAnimations = new JCheckBox("Allow animation");
        allowFocusLoopAnimations.setSelected(AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.FOCUS_LOOP_ANIMATION, null));
        allowFocusLoopAnimations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (allowFocusLoopAnimations.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.FOCUS_LOOP_ANIMATION);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.FOCUS_LOOP_ANIMATION);
                }
            }
        });
        builder.append("Focus loop", (Component)allowFocusLoopAnimations);
        final JCheckBox allowGlowIconAnimations = new JCheckBox("Allow animation");
        allowGlowIconAnimations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (allowGlowIconAnimations.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.ICON_GLOW);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.ICON_GLOW);
                }
            }
        });
        builder.append("Icon glow", (Component)allowGlowIconAnimations);
        final JCheckBox allowGhostIconAnimations = new JCheckBox("Allow animation");
        allowGhostIconAnimations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (allowGhostIconAnimations.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.GHOSTING_ICON_ROLLOVER);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.GHOSTING_ICON_ROLLOVER);
                }
            }
        });
        builder.append("Icon rollover", (Component)allowGhostIconAnimations);
        final JCheckBox allowGhostPressAnimations = new JCheckBox("Allow animation");
        allowGhostPressAnimations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (allowGhostPressAnimations.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.GHOSTING_BUTTON_PRESS);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.GHOSTING_BUTTON_PRESS);
                }
            }
        });
        builder.append("Button press", (Component)allowGhostPressAnimations);
        builder.appendSeparator("Toolbar");
        final JCheckBox isToolbarFlat = new JCheckBox("Is flat");
        isToolbarFlat.setSelected(true);
        isToolbarFlat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toolbar.putClientProperty("substancelaf.componentFlat", isToolbarFlat.isSelected());
                toolbar.repaint();
            }
        });
        builder.append("Flat", (Component)isToolbarFlat);
        builder.appendSeparator("Menu bar");
        final JCheckBox menuSearch = new JCheckBox("Has menu search");
        menuSearch.setSelected(false);
        menuSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstanceLookAndFeel.setWidgetVisible(mainFrame.getRootPane(), menuSearch.isSelected(), SubstanceConstants.SubstanceWidgetType.MENU_SEARCH);
            }
        });
        builder.append("Menu search", (Component)menuSearch);
        final JCheckBox menuLocale = new JCheckBox("Has custom locale");
        menuLocale.setSelected(false);
        menuLocale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (menuLocale.isSelected()) {
                    mainFrame.getJMenuBar().setLocale(Locale.FRENCH);
                    mainFrame.getJMenuBar().putClientProperty("lafwidgets.ignoreGlobalLocale", Boolean.TRUE);
                } else {
                    mainFrame.getJMenuBar().putClientProperty("lafwidgets.ignoreGlobalLocale", null);
                }
            }
        });
        builder.append("Menu locale", (Component)menuLocale);
        JPanel result = builder.getPanel();
        result.setName("Main control panel");
        return result;
    }

    public static JPanel getDialogControlPanel(final JFrame mainFrame) {
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.appendSeparator("Core choosers");
        JButton bfo = new JButton("Open dialog", Check.getIcon("JFileChooserColor16"));
        bfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFileChooser jfc = new JFileChooser();
                        jfc.showOpenDialog(mainFrame);
                    }
                });
            }
        });
        builder.append("File chooser", (Component)bfo);
        JButton bfs = new JButton("Save dialog", Check.getIcon("JFileChooserColor16"));
        bfs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFileChooser jfc = new JFileChooser();
                        jfc.showSaveDialog(mainFrame);
                    }
                });
            }
        });
        builder.append("", (Component)bfs);
        JButton bc = new JButton("Open", Check.getIcon("JColorChooserColor16"));
        bc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Color color = JColorChooser.showDialog(mainFrame, "Color chooser", new Color(23, 45, 200));
                        if (color != null) {
                            Check.out("Chosen " + color.toString());
                        }
                    }
                });
            }
        });
        builder.append("Color chooser", (Component)bc);
        JButton bcWindow = new JButton("open in window");
        bcWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final Window window = new Window(mainFrame);
                        window.setLayout(new BorderLayout());
                        window.add(new JColorChooser());
                        window.pack();
                        window.setLocationRelativeTo(null);
                        window.setVisible(true);
                        Timer timerDispose = new Timer(5000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                window.dispose();
                            }
                        });
                        timerDispose.setRepeats(false);
                        timerDispose.start();
                    }
                });
            }
        });
        builder.append("", (Component)bcWindow);
        builder.appendSeparator("Option panes");
        JButton bop = new JButton("Show");
        bop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane pane = new JOptionPane("Sample option pane");
                        JDialog dialog = pane.createDialog(mainFrame, "Sample title");
                        dialog.setVisible(true);
                        dialog.dispose();
                    }
                });
            }
        });
        builder.append("Plain", (Component)bop);
        JButton bopi = new JButton("Show", Check.getIcon("22/dialog-information"));
        bopi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(mainFrame, "Sample info message", "Sample title", 1);
                    }
                });
            }
        });
        builder.append("Info", (Component)bopi);
        JButton bope = new JButton("Show", Check.getIcon("22/dialog-error"));
        bope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(mainFrame, "Sample error message", "Sample title", 0);
                    }
                });
            }
        });
        builder.append("Error", (Component)bope);
        JButton bopw = new JButton("Show", Check.getIcon("22/dialog-warning"));
        bopw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(mainFrame, "Sample warning message", "Sample title", 2);
                    }
                });
            }
        });
        builder.append("Warning", (Component)bopw);
        JButton bopq = new JButton("Show", Check.getIcon("22/help-browser"));
        bopq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(mainFrame, "Sample question message", "Sample title", 3);
                    }
                });
            }
        });
        builder.append("Question", (Component)bopq);
        JButton bopc = new JButton("Show");
        bopc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showOptionDialog(mainFrame, new JPanel(), "Option", 2, -1, null, null, null);
                    }
                });
            }
        });
        builder.append("Custom", (Component)bopc);
        JButton buttonOptionPaneSimpleInput = new JButton("Show");
        buttonOptionPaneSimpleInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDialog dialog = new JDialog(mainFrame, "Sample dialog", true);
                        dialog.setSize(400, 300);
                        dialog.setLocationRelativeTo(mainFrame);
                        dialog.setLayout(new BorderLayout());
                        JDesktopPane panel = new JDesktopPane();
                        dialog.add((Component)panel, "Center");
                        JOptionPane.showInputDialog(panel, "Sample Question Message?", "Default Answer");
                        dialog.dispose();
                    }
                });
            }
        });
        builder.append("Simple input", (Component)buttonOptionPaneSimpleInput);
        JButton buttonOptionPaneComplexInput = new JButton("Show");
        buttonOptionPaneComplexInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDialog dialog = new JDialog(mainFrame, "Sample dialog", true);
                        dialog.setSize(400, 300);
                        dialog.setLocationRelativeTo(mainFrame);
                        dialog.setLayout(new BorderLayout());
                        JDesktopPane panel = new JDesktopPane();
                        dialog.add((Component)panel, "Center");
                        Object[] optionChoices = new String[]{"entry1", "entry2", "entry3", "entry4"};
                        JOptionPane.showInputDialog(panel, "Sample Question Message?", "Title Goes Here", 3, null, optionChoices, "entry1");
                        dialog.dispose();
                    }
                });
            }
        });
        builder.append("Complex input", (Component)buttonOptionPaneComplexInput);
        JButton buttonOptionPaneInternalInput = new JButton("Show");
        buttonOptionPaneInternalInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDialog dialog = new JDialog(mainFrame, "Sample dialog", true);
                        dialog.setSize(400, 300);
                        dialog.setLocationRelativeTo(mainFrame);
                        dialog.setLayout(new BorderLayout());
                        JDesktopPane panel = new JDesktopPane();
                        dialog.add((Component)panel, "Center");
                        JOptionPane.showInternalInputDialog(panel, "Sample info message", "Sample title", 1);
                        dialog.dispose();
                    }
                });
            }
        });
        builder.append("Internal input", (Component)buttonOptionPaneInternalInput);
        builder.appendSeparator("Default buttons");
        JButton openDisposable = new JButton("Open");
        openDisposable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (disposableDialog != null) {
                            disposableDialog.setVisible(true);
                            return;
                        }
                        disposableDialog = new JDialog();
                        disposableDialog.setTitle("Disposable");
                        JTree tree = new JTree();
                        JScrollPane jsp = new JScrollPane(tree, 22, 32);
                        jsp.putClientProperty("lafwidgets.componentPreviewPainter", new DefaultPreviewPainter());
                        disposableDialog.setLayout(new BorderLayout());
                        disposableDialog.add((Component)jsp, "Center");
                        disposableDialog.setSize(200, 100);
                        disposableDialog.setLocationRelativeTo(null);
                        disposableDialog.setDefaultCloseOperation(2);
                        disposableDialog.setVisible(true);
                    }
                });
            }
        });
        builder.append("Disposable dialog", (Component)openDisposable);
        JButton launchFrameDialogWithIcon = new JButton("Open");
        launchFrameDialogWithIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleDialog sd = new SimpleDialog();
                        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
                            sd.setIconImage(SubstanceLogo.getLogoImage(SubstanceLookAndFeel.getCurrentSkin(sd.getRootPane()).getColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
                        }
                        sd.getRootPane().setWindowDecorationStyle(1);
                        sd.setModal(false);
                        sd.pack();
                        sd.setLocationRelativeTo(null);
                        sd.setVisible(true);
                        sd.setDefaultCloseOperation(2);
                    }
                });
            }
        });
        builder.append("Dialog with icon", (Component)launchFrameDialogWithIcon);
        JButton bd = new JButton("Open");
        bd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleDialog sd = new SimpleDialog();
                        sd.setModal(false);
                        sd.pack();
                        sd.setLocationRelativeTo(null);
                        sd.setVisible(true);
                        ControlPanelFactory.simpleDialog = sd;
                    }
                });
            }
        });
        builder.append("Open a dialog", (Component)bd);
        JButton bcd = new JButton("Close");
        bcd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (simpleDialog != null) {
                            simpleDialog.removeAll();
                            simpleDialog.dispose();
                            ReferenceQueue weakQueue = new ReferenceQueue();
                            WeakReference<JButton> weakRef = new WeakReference<JButton>(simpleDialog.b1, weakQueue);
                            weakRef.enqueue();
                            simpleDialog.b1 = null;
                            ControlPanelFactory.simpleDialog = null;
                            System.gc();
                            Check.out("Waiting to remove");
                            try {
                                Reference ref = weakQueue.remove();
                                ref.clear();
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                                return;
                            }
                            Check.out("Removed");
                        }
                    }
                });
            }
        });
        builder.append("Close the dialog", (Component)bcd);
        JButton buttonDialogCloseOnEsc = new JButton("Show");
        buttonDialogCloseOnEsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final JDialog dialog = new JDialog(null, "Click ESC to dispose");
                        dialog.setSize(200, 200);
                        dialog.setLayout(new BorderLayout());
                        JPanel myContentPane = new JPanel();
                        myContentPane.setLayout(new BorderLayout());
                        dialog.setContentPane(myContentPane);
                        JTabbedPane tabs = new JTabbedPane();
                        JPanel tab1 = new JPanel(new FlowLayout());
                        tab1.add(new JLabel("test"));
                        JTextField tab1TextField = new JTextField("some text");
                        tab1TextField.putClientProperty("lafwidgets.textFlipSelectOnEscape", Boolean.TRUE);
                        tab1.add(tab1TextField);
                        tabs.addTab("Foo", tab1);
                        JPanel tab2 = new JPanel(new FlowLayout());
                        tab2.add(new JButton("Test"));
                        tabs.addTab("Bar", tab2);
                        dialog.add((Component)tabs, "Center");
                        dialog.add((Component)new JLabel("Press Esc to close dialog"), "North");
                        String actionName = "VK_ESCAPE";
                        AbstractAction action = new AbstractAction(actionName){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dialog.dispose();
                            }
                        };
                        myContentPane.getActionMap().put(actionName, action);
                        myContentPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), actionName);
                        dialog.setLocationRelativeTo(null);
                        dialog.setVisible(true);
                    }
                });
            }
        });
        builder.append("Dialog with ESC close", (Component)buttonDialogCloseOnEsc);
        JButton buttonDialogUndecorated = new JButton("Show");
        buttonDialogUndecorated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final JDialog dialog = new JDialog(null, "");
                        dialog.setSize(200, 200);
                        dialog.setUndecorated(true);
                        dialog.setLayout(new BorderLayout());
                        JPanel myContentPane = new JPanel();
                        myContentPane.setLayout(new BorderLayout());
                        dialog.setContentPane(myContentPane);
                        dialog.add((Component)new JLabel("Press Esc to close dialog"), "North");
                        String actionName = "VK_ESCAPE";
                        AbstractAction action = new AbstractAction(actionName){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dialog.dispose();
                            }
                        };
                        myContentPane.getActionMap().put(actionName, action);
                        myContentPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), actionName);
                        dialog.setLocationRelativeTo(null);
                        dialog.setVisible(true);
                    }
                });
            }
        });
        builder.append("Undecorated dialog", (Component)buttonDialogUndecorated);
        builder.appendSeparator("Miscellaneous");
        JButton customSkinFrame = new JButton("Show");
        customSkinFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SampleFrame testFrame = new SampleFrame();
                        testFrame.getRootPane().putClientProperty("substancelaf.skin", new NebulaBrickWallSkin());
                        SwingUtilities.updateComponentTreeUI(testFrame.getRootPane());
                        testFrame.setSize(315, 245);
                        testFrame.setLocationRelativeTo(mainFrame);
                        testFrame.setDefaultCloseOperation(2);
                        testFrame.setVisible(true);
                    }
                });
            }
        });
        builder.append("Nebula brick wall frame", (Component)customSkinFrame);
        JButton btf = new JButton("Show");
        btf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame testFrame = new JFrame("test1");
                        testFrame.setSize(262, 100);
                        testFrame.setLocationRelativeTo(mainFrame);
                        testFrame.setDefaultCloseOperation(2);
                        testFrame.setVisible(true);
                    }
                });
            }
        });
        builder.append("Regular frame", (Component)btf);
        JButton btfU = new JButton("Show");
        btfU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame.setDefaultLookAndFeelDecorated(false);
                        JDialog.setDefaultLookAndFeelDecorated(false);
                        JFrame testFrame = new JFrame("test undecorated");
                        testFrame.setSize(262, 100);
                        testFrame.setLocation(400, 400);
                        testFrame.setDefaultCloseOperation(2);
                        testFrame.setVisible(true);
                        JFrame.setDefaultLookAndFeelDecorated(true);
                        JDialog.setDefaultLookAndFeelDecorated(true);
                    }
                });
            }
        });
        builder.append("Undecorated frame", (Component)btfU);
        JButton bcp = new JButton("Open");
        bcp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame colorFrame = new JFrame();
                        final ColorPanel cp1 = new ColorPanel("default");
                        final ColorPanel cp2 = new ColorPanel("green");
                        cp2.setBackground(Color.green);
                        final ColorPanel cp3 = new ColorPanel("red");
                        cp3.setBackground(Color.red);
                        final ColorPanel cp4 = new ColorPanel("black");
                        cp4.setBackground(Color.black);
                        colorFrame.setLayout(new LayoutManager(){

                            @Override
                            public void addLayoutComponent(String name, Component comp) {
                            }

                            @Override
                            public void layoutContainer(Container parent) {
                                int h = parent.getHeight() / 2;
                                int w = parent.getWidth() / 2;
                                cp1.setBounds(0, 0, w, h);
                                cp2.setBounds(0, h, w, parent.getHeight() - h);
                                cp3.setBounds(w, 0, w, h + 1);
                                cp4.setBounds(w, h + 1, w, parent.getHeight() - h);
                            }

                            @Override
                            public Dimension minimumLayoutSize(Container parent) {
                                return this.preferredLayoutSize(parent);
                            }

                            @Override
                            public Dimension preferredLayoutSize(Container parent) {
                                return new Dimension(100, 100);
                            }

                            @Override
                            public void removeLayoutComponent(Component comp) {
                            }
                        });
                        colorFrame.add(cp1);
                        colorFrame.add(cp2);
                        colorFrame.add(cp3);
                        colorFrame.add(cp4);
                        colorFrame.setSize(400, 399);
                        colorFrame.setLocation(300, 300);
                        colorFrame.setDefaultCloseOperation(2);
                        colorFrame.setVisible(true);
                    }
                });
            }
        });
        builder.append("Color panels", (Component)bcp);
        JButton paneDialog = new JButton("Open");
        paneDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDialog dialog = new JDialog((Frame)mainFrame, true);
                        dialog.setTitle("Test text pane in scroll pane");
                        JTextPane textPane = new JTextPane();
                        String contents = "";
                        int i = 0;
                        while (i < 100) {
                            contents = String.valueOf(contents) + "This is sample line " + i + " and a lot of other irrelevant text\n";
                            ++i;
                        }
                        textPane.replaceSelection(contents);
                        JScrollPane scroll = new JScrollPane(textPane);
                        JPanel panel = new JPanel();
                        panel.setLayout(new BorderLayout());
                        panel.add((Component)scroll, "Center");
                        dialog.setLayout(new BorderLayout());
                        dialog.add((Component)panel, "Center");
                        dialog.setSize(400, 400);
                        dialog.setLocation(400, 200);
                        dialog.setVisible(true);
                    }
                });
            }
        });
        builder.append("Text pane dialog", (Component)paneDialog);
        return builder.getPanel();
    }
}

