/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import test.SubstanceLogo;
import test.check.ControllablePanel;
import test.check.SampleInternalFrame;
import test.check.SampleMenuFactory;
import test.check.ScrollablePanel;

public class DesktopPanel
extends ControllablePanel {
    private JDesktopPane jdp;
    private int count = 0;
    private Set<JInternalFrame> disposed = new HashSet<JInternalFrame>();

    public DesktopPanel() {
        this.setLayout(new BorderLayout());
        this.jdp = new JDesktopPane();
        this.add((Component)this.jdp, "Center");
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.appendSeparator("New sample frame");
        JButton sample = new JButton("Add");
        sample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SampleInternalFrame jif = new SampleInternalFrame(){};
                        jif.setBounds(0, 0, 300, 200);
                        DesktopPanel.this.jdp.add(jif);
                        jif.setVisible(true);
                        jif.setComponentOrientation(DesktopPanel.this.jdp.getComponentOrientation());
                    }
                });
            }
        });
        builder.append("Add sample", (Component)sample);
        builder.appendSeparator("New custom frame");
        final JCheckBox makeZero = new JCheckBox("Has zero bounds");
        builder.append("Custom settings", (Component)makeZero);
        final JCheckBox isClosable = new JCheckBox("Is closable");
        isClosable.setSelected(true);
        builder.append("", (Component)isClosable);
        final JCheckBox isMaximizable = new JCheckBox("Is maximizable");
        isMaximizable.setSelected(true);
        builder.append("", (Component)isMaximizable);
        final JCheckBox isIconifiable = new JCheckBox("Is iconifiable");
        isIconifiable.setSelected(true);
        builder.append("", (Component)isIconifiable);
        final JCheckBox isResizable = new JCheckBox("Is resizable");
        isResizable.setSelected(true);
        builder.append("", (Component)isResizable);
        JButton bt = new JButton("Add");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = "[" + DesktopPanel.this.count + "]Internal title ";
                int c = (int)(20.0 * Math.random());
                int i = 0;
                while (i < c) {
                    title = String.valueOf(title) + "0";
                    ++i;
                }
                final JInternalFrame jif = new JInternalFrame(title);
                jif.setFrameIcon(SubstanceLogo.getLogoIcon(SubstanceLookAndFeel.getCurrentSkin(jif.getRootPane()).getColorScheme(DecorationAreaType.SECONDARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
                SubstanceLookAndFeel.registerSkinChangeListener(new SkinChangeListener(){

                    @Override
                    public void skinChanged() {
                        jif.setFrameIcon(SubstanceLogo.getLogoIcon(SubstanceLookAndFeel.getCurrentSkin(jif.getRootPane()).getColorScheme(DecorationAreaType.SECONDARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
                    }
                });
                jif.setLayout(new BorderLayout());
                JPanel controls = new JPanel(new FlowLayout());
                int comps = 5 + (int)(10.0 * Math.random());
                int i2 = 0;
                while (i2 < comps) {
                    double r = Math.random();
                    if (r < 0.1) {
                        controls.add(new JButton("button" + i2));
                    } else if (r < 0.2) {
                        controls.add(new JLabel("label" + i2));
                    } else if (r < 0.3) {
                        controls.add(new JRadioButton("radio" + i2));
                    } else if (r < 0.4) {
                        controls.add(new JCheckBox("check" + i2));
                    } else if (r < 0.5) {
                        controls.add(new JToggleButton("toggle" + i2));
                    } else if (r < 0.6) {
                        controls.add(new JComboBox<Object>(new Object[]{"combo" + i2}));
                    } else if (r < 0.7) {
                        controls.add(new JTextField("text field" + i2));
                    } else if (r < 0.8) {
                        controls.add(new JPasswordField("password" + i2));
                    } else if (r < 0.9) {
                        controls.add(new JSpinner());
                    } else {
                        controls.add(new JList<Object>(new Object[]{"list" + i2}));
                    }
                    ++i2;
                }
                jif.add((Component)controls, "Center");
                jif.setClosable(isClosable.isSelected());
                jif.setMaximizable(isMaximizable.isSelected());
                jif.setIconifiable(isIconifiable.isSelected());
                jif.setResizable(isResizable.isSelected());
                JPanel buttons = new JPanel(new FlowLayout(2));
                final JCheckBox isModified = new JCheckBox("modified");
                isModified.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        jif.getRootPane().putClientProperty("windowModified", isModified.isSelected());
                    }
                });
                buttons.add(isModified);
                JButton changeTitleButton = new JButton("Change title");
                changeTitleButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String random = "abcdefghijklmnopqrstuvwxyz     ";
                        int length = (int)(50.0 * Math.random());
                        String title = "";
                        while (length > 0) {
                            title = String.valueOf(title) + random.charAt((int)((double)random.length() * Math.random()));
                            --length;
                        }
                        jif.setTitle(title);
                    }
                });
                buttons.add(changeTitleButton);
                JButton setNullTitlePane = new JButton("Remove title pane");
                setNullTitlePane.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((BasicInternalFrameUI)jif.getUI()).setNorthPane(null);
                                jif.revalidate();
                            }
                        });
                    }
                });
                buttons.add(setNullTitlePane);
                jif.add((Component)buttons, "South");
                DesktopPanel desktopPanel = DesktopPanel.this;
                desktopPanel.count = desktopPanel.count + 1;
                int width = 50 + (int)(400.0 * Math.random());
                int height = 50 + (int)(200.0 * Math.random());
                jif.setBounds(20 * (DesktopPanel.this.count % 10), 20 * (DesktopPanel.this.count % 10), width, height);
                if (makeZero.isSelected()) {
                    jif.setBounds(0, 0, 0, 0);
                }
                jif.setBackground(new Color(128 + (int)(128.0 * Math.random()), 128 + (int)(128.0 * Math.random()), 128 + (int)(128.0 * Math.random())));
                jif.setComponentOrientation(DesktopPanel.this.jdp.getComponentOrientation());
                DesktopPanel.this.jdp.add((Component)jif, 1);
                JMenuBar jmb = new JMenuBar();
                jmb.add(SampleMenuFactory.getSkinMenu());
                JMenu jm1 = new JMenu("Menu1");
                jm1.setMnemonic('1');
                int mcount = 0;
                for (LinkedList linkedList : SampleMenuFactory.getTestMenuItems()) {
                    if (mcount > 0) {
                        if (mcount % 2 == 0) {
                            jm1.addSeparator();
                        } else {
                            jm1.add(new JSeparator());
                        }
                    }
                    for (JMenuItem menuItem : linkedList) {
                        jm1.add(menuItem);
                    }
                    ++mcount;
                }
                jmb.add(jm1);
                jif.setJMenuBar(jmb);
                jif.show();
            }
        });
        builder.append("Add custom", (Component)bt);
        builder.appendSeparator("Operations");
        JButton minAll = new JButton("Execute");
        minAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame[] jInternalFrameArray = DesktopPanel.this.jdp.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jif = jInternalFrameArray[n2];
                    try {
                        jif.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        });
        builder.append("Minimize all", (Component)minAll);
        JButton closeAll = new JButton("Execute");
        closeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame[] jInternalFrameArray = DesktopPanel.this.jdp.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jif = jInternalFrameArray[n2];
                    try {
                        jif.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        });
        builder.append("Close all", (Component)closeAll);
        JButton disposeAll = new JButton("Execute");
        disposeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame[] jInternalFrameArray = DesktopPanel.this.jdp.getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jif = jInternalFrameArray[n2];
                    DesktopPanel.this.disposed.add(jif);
                    jif.dispose();
                    ++n2;
                }
            }
        });
        builder.append("Dispose all", (Component)disposeAll);
        JButton reshowAll = new JButton("Execute");
        reshowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (JInternalFrame jif : DesktopPanel.this.disposed) {
                    jif.setVisible(true);
                }
            }
        });
        builder.append("Reshow all", (Component)reshowAll);
        this.controlPanel = builder.getPanel();
        this.setPreferredSize(new Dimension(400, 400));
        this.setSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
    }
}

