/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;
import test.check.ControllablePanel;
import test.check.Deferrable;
import test.check.ScrollablePanel;

public class FileTreePanel
extends ControllablePanel
implements Deferrable {
    private boolean isInitialized;
    protected static FileSystemView fsv = FileSystemView.getFileSystemView();
    private JTree tree;

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    public FileTreePanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public synchronized void initialize() {
        ArrayList<File> rootsList = new ArrayList<File>();
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            rootsList.add(child);
            ++n2;
        }
        FileTreeNode rootTreeNode = new FileTreeNode(rootsList);
        this.tree = new JTree(rootTreeNode);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel ? new SubstanceFileTreeCellRenderer() : new FileTreeCellRenderer())));
        this.tree.setRootVisible(false);
        final JScrollPane jsp = new JScrollPane(this.tree);
        jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)jsp, "Center");
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.appendSeparator("General");
        final JCheckBox isEnabled = new JCheckBox("is enabled");
        isEnabled.setSelected(this.tree.isEnabled());
        isEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTreePanel.this.tree.setEnabled(isEnabled.isSelected());
            }
        });
        builder.append("Enabled", (Component)isEnabled);
        final JCheckBox watermarkBleed = new JCheckBox("is bleeding");
        watermarkBleed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTreePanel.this.tree.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                jsp.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                FileTreePanel.this.tree.repaint();
            }
        });
        builder.append("Watermark", (Component)watermarkBleed);
        final JCheckBox cbTreeSmartScroll = new JCheckBox("smart tree scroll");
        cbTreeSmartScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cbTreeSmartScroll.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(SubstanceLookAndFeel.TREE_SMART_SCROLL_ANIMATION_KIND, (Component)FileTreePanel.this.tree);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(SubstanceLookAndFeel.TREE_SMART_SCROLL_ANIMATION_KIND, (Component)FileTreePanel.this.tree);
                }
                FileTreePanel.this.tree.repaint();
            }
        });
        builder.append("Decorations", (Component)cbTreeSmartScroll);
        this.controlPanel = builder.getPanel();
        this.isInitialized = true;
    }

    private static class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private Map<File, String> rootNameCache = new HashMap<File, String>();

        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FileTreeNode ftn = (FileTreeNode)value;
            File file = ftn.file;
            String filename = "";
            if (file != null) {
                if (ftn.isFileSystemRoot) {
                    filename = this.rootNameCache.get(file);
                    if (filename == null) {
                        filename = fsv.getSystemDisplayName(file);
                        this.rootNameCache.put(file, filename);
                    }
                } else {
                    filename = file.getName();
                }
            }
            JLabel result = (JLabel)super.getTreeCellRendererComponent(tree, filename, sel, expanded, leaf, row, hasFocus);
            if (file != null) {
                Icon icon = this.iconCache.get(filename);
                if (icon == null) {
                    icon = fsv.getSystemIcon(file);
                    this.iconCache.put(filename, icon);
                }
                result.setIcon(icon);
            }
            return result;
        }
    }

    private static class FileTreeNode
    implements TreeNode {
        private File file;
        private List<File> children;
        private TreeNode parent;
        private boolean isFileSystemRoot;

        public FileTreeNode(File file, boolean isFileSystemRoot, TreeNode parent) {
            this.file = file;
            this.isFileSystemRoot = isFileSystemRoot;
            this.parent = parent;
            this.children = new ArrayList<File>();
            File[] children = file.listFiles();
            if (children != null) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    if (!fsv.isHiddenFile(child)) {
                        this.children.add(child);
                    }
                    ++n2;
                }
                Collections.sort(this.children, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (o1.equals(o2)) {
                            return 0;
                        }
                        if (o1.isDirectory() && o2.isFile()) {
                            return -1;
                        }
                        if (o1.isFile() && o2.isDirectory()) {
                            return 1;
                        }
                        int result = fsv.getSystemDisplayName(o1).toLowerCase().compareTo(fsv.getSystemDisplayName(o2).toLowerCase());
                        if (result != 0) {
                            return result;
                        }
                        return o1.compareTo(o2);
                    }
                });
            }
        }

        public FileTreeNode(List<File> children) {
            this.file = null;
            this.parent = null;
            this.children = children;
        }

        public Enumeration<?> children() {
            final int elementCount = this.children.size();
            return new Enumeration<File>(){
                int count = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.count < elementCount;
                }

                @Override
                public File nextElement() {
                    if (this.count < elementCount) {
                        return (File)FileTreeNode.this.children.get(this.count++);
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return new FileTreeNode(this.children.get(childIndex), this.parent == null, this);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            FileTreeNode ftn = (FileTreeNode)node;
            int i = 0;
            while (i < this.children.size()) {
                if (ftn.file.equals(this.children.get(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }

    private static class SubstanceFileTreeCellRenderer
    extends SubstanceDefaultTreeCellRenderer {
        private Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private Map<File, String> rootNameCache = new HashMap<File, String>();

        private SubstanceFileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FileTreeNode ftn = (FileTreeNode)value;
            File file = ftn.file;
            String filename = "";
            if (file != null) {
                if (ftn.isFileSystemRoot) {
                    filename = this.rootNameCache.get(file);
                    if (filename == null) {
                        filename = fsv.getSystemDisplayName(file);
                        this.rootNameCache.put(file, filename);
                    }
                } else {
                    filename = file.getName();
                }
            }
            JLabel result = (JLabel)super.getTreeCellRendererComponent(tree, filename, sel, expanded, leaf, row, hasFocus);
            if (file != null) {
                Icon icon = this.iconCache.get(filename);
                if (icon == null) {
                    icon = fsv.getSystemIcon(file);
                    this.iconCache.put(filename, icon);
                }
                result.setIcon(icon);
            }
            return result;
        }
    }
}

